/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.server;

import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.embedded.Server;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ServerEnvironmentImpl
implements ServerEnvironment,
PostConstruct {
    @Inject
    StartupContext startupContext;
    @Inject(optional=true)
    Server server = null;
    public static final String kGeneratedDirName = "generated";
    public static final String kRepositoryDirName = "applications";
    public static final String kEJBStubDirName = "ejb";
    public static final String kGeneratedXMLDirName = "xml";
    public static final String kConfigXMLFileName = "domain.xml";
    public static final String kLoggingPropertiesFileName = "logging.properties";
    public static final String kConfigDirName = "config";
    public static final String kInitFileName = "init.conf";
    public static final String DEFAULT_ADMIN_CONSOLE_CONTEXT_ROOT = "/admin";
    public static final String DEFAULT_ADMIN_CONSOLE_APP_NAME = "__admingui";
    private File root;
    private boolean verbose;
    private boolean debug;
    private ASenvPropertyReader asenv;
    private String domainName;
    private String instanceName;
    private static final String INSTANCE_ROOT_PROP_NAME = "com.sun.aas.instanceRoot";
    private ServerEnvironment.Status status = ServerEnvironment.Status.starting;

    public ServerEnvironmentImpl() {
    }

    public ServerEnvironmentImpl(File root) {
        this.root = root.getAbsoluteFile();
        this.asenv = new ASenvPropertyReader();
    }

    @Override
    public void postConstruct() {
        this.asenv = this.server == null ? new ASenvPropertyReader(this.startupContext.getRootDirectory().getParentFile()) : new ASenvPropertyReader(this.startupContext.getRootDirectory());
        if (this.root == null) {
            String envVar = System.getProperty(INSTANCE_ROOT_PROP_NAME);
            this.root = envVar != null ? new File(envVar) : this.startupContext.getRootDirectory();
        }
        this.asenv.getProps().put(INSTANCE_ROOT_PROP_NAME, this.root.getAbsolutePath());
        for (Map.Entry<String, String> entry : this.asenv.getProps().entrySet()) {
            File location = new File(entry.getValue());
            if (!location.isAbsolute()) {
                location = new File(this.asenv.getProps().get(INSTANCE_ROOT_PROP_NAME), entry.getValue());
            }
            System.setProperty(entry.getKey(), location.getAbsolutePath());
        }
        Properties args = this.startupContext.getArguments();
        this.verbose = Boolean.parseBoolean(args.getProperty("-verbose"));
        this.debug = Boolean.parseBoolean(args.getProperty("-debug"));
        String s = args.getProperty("-domainname");
        if (!this.ok(s)) {
            s = this.root.getName();
        }
        this.domainName = s;
        s = args.getProperty("-instancename");
        this.instanceName = !this.ok(s) ? "server" : s;
        this.asenv.getProps().put("com.sun.aas.instanceName", this.instanceName);
        System.setProperty("com.sun.aas.instanceName", this.instanceName);
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public File getDomainRoot() {
        return this.root;
    }

    public StartupContext getStartupContext() {
        return this.startupContext;
    }

    public File getConfigDirPath() {
        return new File(this.root, kConfigDirName);
    }

    public File getApplicationRepositoryPath() {
        return new File(this.root, kRepositoryDirName);
    }

    public File getApplicationStubPath() {
        return new File(this.root, kGeneratedDirName);
    }

    public File getInitFilePath() {
        return new File(this.getConfigDirPath(), kInitFileName);
    }

    public File getLibPath() {
        return new File(this.root, "lib");
    }

    public File getApplicationEJBStubPath() {
        return new File(this.getApplicationStubPath(), kEJBStubDirName);
    }

    public File getApplicationGeneratedXMLPath() {
        return new File(this.getApplicationStubPath(), kGeneratedXMLDirName);
    }

    public File getApplicationCompileJspPath() {
        return new File(this.getApplicationStubPath(), "jsp");
    }

    public File getWebModuleCompileJspPath() {
        return this.getApplicationCompileJspPath();
    }

    public String getModuleRepositoryPath() {
        return null;
    }

    public String getJavaWebStartPath() {
        return null;
    }

    public String getApplicationBackupRepositoryPath() {
        return null;
    }

    public String getInstanceClassPath() {
        return null;
    }

    public String getModuleStubPath() {
        return null;
    }

    public Map<String, String> getProps() {
        return Collections.unmodifiableMap(this.asenv.getProps());
    }

    private boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    public File getDefaultAdminConsoleFolderOnDisk() {
        File install = new File(this.asenv.getProps().get("com.sun.aas.installRoot"));
        File agp = new File(new File(new File(install, "lib"), "install"), kRepositoryDirName);
        return agp;
    }

    public File getMasterPasswordFile() {
        return new File(this.getDomainRoot(), "master-password");
    }

    public File getJKS() {
        return new File(this.getConfigDirPath(), "keystore.jks");
    }

    public ServerEnvironment.Status getStatus() {
        return this.status;
    }

    public void setStatus(ServerEnvironment.Status status) {
        this.status = status;
    }

    public boolean isEmbedded() {
        return this.server != null;
    }
}

