/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.servlet;

import javax.enterprise.inject.spi.BeanManager;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletRequestEvent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSessionEvent;
import org.jboss.weld.BeanManagerImpl;
import org.jboss.weld.Container;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.context.ContextLifecycle;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.ServletMessage;
import org.jboss.weld.servlet.ServletLifecycle;
import org.jboss.weld.servlet.api.ServletServices;
import org.jboss.weld.servlet.api.helpers.AbstractServletListener;
import org.slf4j.cal10n.LocLogger;

public class WeldListener
extends AbstractServletListener {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.SERVLET);
    private ServletLifecycle lifecycle;

    private ServletLifecycle getLifecycle() {
        if (this.lifecycle == null) {
            this.lifecycle = new ServletLifecycle(Container.instance().deploymentServices().get(ContextLifecycle.class));
        }
        return this.lifecycle;
    }

    private static BeanManagerImpl getBeanManager(ServletContext ctx) {
        BeanDeploymentArchive war = Container.instance().deploymentServices().get(ServletServices.class).getBeanDeploymentArchive(ctx);
        if (war == null) {
            throw new IllegalStateException("Unable to locate BeanDeploymentArchive. ServletContext: " + ctx);
        }
        BeanManagerImpl beanManager = Container.instance().beanDeploymentArchives().get(war);
        if (beanManager == null) {
            throw new IllegalStateException("Unable to locate BeanManager. ServletContext: " + ctx + "; BeanDeploymentArchive: " + war);
        }
        return beanManager;
    }

    public void contextInitialized(ServletContextEvent sce) {
        super.contextInitialized(sce);
        if (!Container.available()) {
            log.warn(ServletMessage.NOT_STARTING, new Object[0]);
            return;
        }
        if (!Container.instance().deploymentServices().contains(ServletServices.class)) {
            throw new IllegalStateException("Cannot use WeldListener without ServletServices");
        }
        sce.getServletContext().setAttribute(BeanManager.class.getName(), (Object)WeldListener.getBeanManager(sce.getServletContext()));
    }

    public void contextDestroyed(ServletContextEvent sce) {
        sce.getServletContext().removeAttribute(BeanManager.class.getName());
        super.contextDestroyed(sce);
    }

    public void sessionCreated(HttpSessionEvent event) {
        if (Container.available()) {
            this.getLifecycle().beginSession(event.getSession());
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        if (Container.available()) {
            this.getLifecycle().endSession(event.getSession());
        }
    }

    public void requestDestroyed(ServletRequestEvent event) {
        if (Container.available()) {
            if (event.getServletRequest() instanceof HttpServletRequest) {
                this.getLifecycle().endRequest((HttpServletRequest)event.getServletRequest());
            } else {
                throw new IllegalStateException("Non HTTP-Servlet lifecycle not defined");
            }
        }
    }

    public void requestInitialized(ServletRequestEvent event) {
        if (Container.available()) {
            if (event.getServletRequest() instanceof HttpServletRequest) {
                this.getLifecycle().beginRequest((HttpServletRequest)event.getServletRequest());
            } else {
                throw new IllegalStateException("Non HTTP-Servlet lifecycle not defined");
            }
        }
    }
}

