/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.SAXFragmentBuilder;
import org.eclipse.persistence.internal.oxm.TreeObjectBuilder;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XMLRelationshipMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.mappings.UnmarshalKeepAsElementPolicy;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XMLCompositeCollectionMappingNodeValue
extends XMLRelationshipMappingNodeValue
implements ContainerValue {
    private XMLCompositeCollectionMapping xmlCompositeCollectionMapping;

    public XMLCompositeCollectionMappingNodeValue(XMLCompositeCollectionMapping xmlCompositeCollectionMapping) {
        this.xmlCompositeCollectionMapping = xmlCompositeCollectionMapping;
    }

    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver) {
        if (this.xmlCompositeCollectionMapping.isReadOnly()) {
            return false;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Object collection = this.xmlCompositeCollectionMapping.getAttributeAccessor().getAttributeValueFromObject(object);
        if (null == collection) {
            return false;
        }
        Object iterator = cp.iteratorFor(collection);
        if (cp.hasNext(iterator)) {
            XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
            marshalRecord.closeStartGroupingElements(groupingFragment);
        } else {
            return false;
        }
        while (cp.hasNext(iterator)) {
            Object objectValue = cp.next(iterator, session);
            this.marshalSingleValue(xPathFragment, marshalRecord, object, objectValue, session, namespaceResolver, ObjectMarshalContext.getInstance());
        }
        return true;
    }

    public boolean startElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Attributes atts) {
        try {
            XMLDescriptor xmlDescriptor = (XMLDescriptor)this.xmlCompositeCollectionMapping.getReferenceDescriptor();
            if (xmlDescriptor == null) {
                QName leafType;
                xmlDescriptor = this.findReferenceDescriptor(xPathFragment, unmarshalRecord, atts, this.xmlCompositeCollectionMapping, this.xmlCompositeCollectionMapping.getKeepAsElementPolicy());
                if (xmlDescriptor == null && this.xmlCompositeCollectionMapping.getField() != null && (leafType = ((XMLField)this.xmlCompositeCollectionMapping.getField()).getLastXPathFragment().getLeafElementType()) != null) {
                    XPathFragment frag = new XPathFragment();
                    String xpath = leafType.getLocalPart();
                    String uri = leafType.getNamespaceURI();
                    if (uri != null && uri.length() > 0) {
                        frag.setNamespaceURI(uri);
                        String prefix = ((XMLDescriptor)this.xmlCompositeCollectionMapping.getDescriptor()).getNonNullNamespaceResolver().resolveNamespaceURI(uri);
                        if (prefix != null && prefix.length() > 0) {
                            xpath = prefix + ':' + xpath;
                        }
                    }
                    frag.setXPath(xpath);
                    XMLContext xmlContext = unmarshalRecord.getUnmarshaller().getXMLContext();
                    xmlDescriptor = xmlContext.getDescriptorByGlobalType(frag);
                }
                UnmarshalKeepAsElementPolicy policy = this.xmlCompositeCollectionMapping.getKeepAsElementPolicy();
                if (xmlDescriptor == null && policy == UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT || policy == UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT) {
                    if (unmarshalRecord.getTypeQName() != null) {
                        XMLConversionManager cfr_ignored_0 = (XMLConversionManager)unmarshalRecord.getSession().getDatasourcePlatform().getConversionManager();
                        Class theClass = (Class)XMLConversionManager.getDefaultXMLTypes().get(unmarshalRecord.getTypeQName());
                        if (theClass == null) {
                            this.setupHandlerForKeepAsElementPolicy(unmarshalRecord, xPathFragment, atts);
                            return true;
                        }
                    } else {
                        this.setupHandlerForKeepAsElementPolicy(unmarshalRecord, xPathFragment, atts);
                        return true;
                    }
                }
            }
            if (this.xmlCompositeCollectionMapping.getNullPolicy().valueIsNull(atts)) {
                this.getContainerPolicy().addInto(null, unmarshalRecord.getContainerInstance(this), unmarshalRecord.getSession());
            } else {
                XMLField xmlFld = (XMLField)this.xmlCompositeCollectionMapping.getField();
                if (xmlFld.hasLastXPathFragment()) {
                    unmarshalRecord.setLeafElementType(xmlFld.getLastXPathFragment().getLeafElementType());
                }
                this.processChild(xPathFragment, unmarshalRecord, atts, xmlDescriptor, this.xmlCompositeCollectionMapping);
            }
        }
        catch (SAXException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        return true;
    }

    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord) {
        Object collection = unmarshalRecord.getContainerInstance(this);
        this.endElement(xPathFragment, unmarshalRecord, collection);
    }

    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Object collection) {
        if (null == unmarshalRecord.getChildRecord()) {
            SAXFragmentBuilder builder = unmarshalRecord.getFragmentBuilder();
            UnmarshalKeepAsElementPolicy keepAsElementPolicy = this.xmlCompositeCollectionMapping.getKeepAsElementPolicy();
            if ((keepAsElementPolicy == UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT || keepAsElementPolicy == UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT) && builder.getNodes().size() != 0) {
                if (unmarshalRecord.getTypeQName() != null) {
                    XMLConversionManager cfr_ignored_0 = (XMLConversionManager)unmarshalRecord.getSession().getDatasourcePlatform().getConversionManager();
                    Class theClass = (Class)XMLConversionManager.getDefaultXMLTypes().get(unmarshalRecord.getTypeQName());
                    if (theClass != null) {
                        this.endElementProcessText(unmarshalRecord, this.xmlCompositeCollectionMapping.getConverter(), xPathFragment, collection);
                        return;
                    }
                }
                if (builder.getDocument() != null) {
                    this.setOrAddAttributeValueForKeepAsElement(builder, this.xmlCompositeCollectionMapping, (XMLConverter)this.xmlCompositeCollectionMapping.getConverter(), unmarshalRecord, true, collection);
                    return;
                }
            } else {
                this.endElementProcessText(unmarshalRecord, this.xmlCompositeCollectionMapping.getConverter(), xPathFragment, collection);
                return;
            }
            return;
        }
        Object objectValue = unmarshalRecord.getChildRecord().getCurrentObject();
        if (this.xmlCompositeCollectionMapping.hasConverter()) {
            Converter converter = this.xmlCompositeCollectionMapping.getConverter();
            objectValue = converter instanceof XMLConverter ? ((XMLConverter)converter).convertDataValueToObjectValue(objectValue, unmarshalRecord.getSession(), unmarshalRecord.getUnmarshaller()) : converter.convertObjectValueToDataValue(objectValue, unmarshalRecord.getSession());
        }
        unmarshalRecord.addAttributeValue(this, objectValue, collection);
        if (this.xmlCompositeCollectionMapping.getContainerAccessor() != null) {
            if (this.xmlCompositeCollectionMapping.getBidirectionalPolicy().getBidirectionalTargetContainerPolicy() == null) {
                this.xmlCompositeCollectionMapping.getContainerAccessor().setAttributeValueInObject(objectValue, unmarshalRecord.getCurrentObject());
            } else {
                Object backpointerContainer = this.xmlCompositeCollectionMapping.getContainerAccessor().getAttributeValueFromObject(objectValue);
                if (backpointerContainer == null) {
                    backpointerContainer = this.xmlCompositeCollectionMapping.getBidirectionalPolicy().getBidirectionalTargetContainerPolicy().containerInstance();
                    this.xmlCompositeCollectionMapping.getContainerAccessor().setAttributeValueInObject(objectValue, backpointerContainer);
                }
                this.xmlCompositeCollectionMapping.getBidirectionalPolicy().getBidirectionalTargetContainerPolicy().addInto(unmarshalRecord.getCurrentObject(), backpointerContainer, unmarshalRecord.getSession());
            }
        }
        unmarshalRecord.setChildRecord(null);
    }

    public Object getContainerInstance() {
        return this.getContainerPolicy().containerInstance();
    }

    public void setContainerInstance(Object object, Object containerInstance) {
        this.xmlCompositeCollectionMapping.setAttributeValueInObject(object, containerInstance);
    }

    public ContainerPolicy getContainerPolicy() {
        return this.xmlCompositeCollectionMapping.getContainerPolicy();
    }

    public boolean isContainerValue() {
        return true;
    }

    protected void addTypeAttributeIfNeeded(XMLDescriptor descriptor, DatabaseMapping mapping, MarshalRecord marshalRecord) {
        XMLSchemaReference xmlRef = descriptor.getSchemaReference();
        if (this.xmlCompositeCollectionMapping.shouldAddXsiType(marshalRecord, descriptor) && xmlRef != null) {
            this.addTypeAttribute(descriptor, marshalRecord, xmlRef.getSchemaContext());
        }
    }

    public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object value, AbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        UnmarshalKeepAsElementPolicy keepAsElementPolicy;
        XMLDescriptor descriptor;
        if (xPathFragment.hasLeafElementType()) {
            marshalRecord.setLeafElementType(xPathFragment.getLeafElementType());
        }
        XMLMarshaller marshaller = marshalRecord.getMarshaller();
        if (this.xmlCompositeCollectionMapping.hasConverter()) {
            Converter converter = this.xmlCompositeCollectionMapping.getConverter();
            value = converter instanceof XMLConverter ? ((XMLConverter)converter).convertObjectValueToDataValue(value, session, marshaller) : converter.convertObjectValueToDataValue(value, session);
        }
        if (null == value) {
            return this.xmlCompositeCollectionMapping.getNullPolicy().compositeObjectMarshal(xPathFragment, marshalRecord, object, session, namespaceResolver);
        }
        if (marshaller != null && marshaller.getMarshalListener() != null) {
            marshaller.getMarshalListener().beforeMarshal(value);
        }
        if ((descriptor = (XMLDescriptor)this.xmlCompositeCollectionMapping.getReferenceDescriptor()) == null || descriptor.hasInheritance()) {
            descriptor = (XMLDescriptor)session.getDescriptor(value.getClass());
        }
        if (((keepAsElementPolicy = this.xmlCompositeCollectionMapping.getKeepAsElementPolicy()) == UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT || keepAsElementPolicy == UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT) && value instanceof Node) {
            marshalRecord.node((Node)value, marshalRecord.getNamespaceResolver());
            return true;
        }
        if (descriptor != null) {
            TreeObjectBuilder objectBuilder = (TreeObjectBuilder)descriptor.getObjectBuilder();
            this.getXPathNode().startElement(marshalRecord, xPathFragment, object, session, namespaceResolver, objectBuilder, value);
            if (this.xmlCompositeCollectionMapping.getReferenceDescriptor() == null && descriptor.getSchemaReference() != null) {
                this.addTypeAttributeIfNeeded(descriptor, this.xmlCompositeCollectionMapping, marshalRecord);
            }
            List extraNamespaces = objectBuilder.addExtraNamespacesToNamespaceResolver(descriptor, marshalRecord, session);
            this.writeExtraNamespaces(extraNamespaces, marshalRecord, session);
            objectBuilder.buildRow((AbstractRecord)marshalRecord, value, session, marshaller);
            marshalRecord.endElement(xPathFragment, namespaceResolver);
            objectBuilder.removeExtraNamespacesFromNamespaceResolver(marshalRecord, extraNamespaces, session);
        } else {
            this.getXPathNode().startElement(marshalRecord, xPathFragment, object, session, namespaceResolver, null, value);
            QName schemaType = this.getSchemaType((XMLField)this.xmlCompositeCollectionMapping.getField(), value, session);
            String stringValue = this.getValueToWrite(schemaType, value, (XMLConversionManager)session.getDatasourcePlatform().getConversionManager(), namespaceResolver);
            this.updateNamespaces(schemaType, marshalRecord, (XMLField)this.xmlCompositeCollectionMapping.getField());
            marshalRecord.characters(stringValue);
            marshalRecord.endElement(xPathFragment, namespaceResolver);
        }
        if (marshaller != null && marshaller.getMarshalListener() != null) {
            marshaller.getMarshalListener().afterMarshal(value);
        }
        return true;
    }

    public XMLCompositeCollectionMapping getMapping() {
        return this.xmlCompositeCollectionMapping;
    }

    protected void setOrAddAttributeValue(UnmarshalRecord unmarshalRecord, Object value, XPathFragment xPathFragment, Object collection) {
        unmarshalRecord.addAttributeValue(this, value, collection);
    }

    public boolean getReuseContainer() {
        return this.getMapping().getReuseContainer();
    }
}

