/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.logging.LogDomains;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.logging.Logger;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.appclient.server.core.AppClientDeployerHelper;
import org.glassfish.appclient.server.core.jws.JavaWebStartInfo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=PerLookup.class)
public class AppClientServerApplication
implements ApplicationContainer<ApplicationClientDescriptor> {
    @Inject
    private Habitat habitat;
    private DeploymentContext dc;
    private Logger logger;
    private AppClientDeployerHelper helper;
    private ApplicationClientDescriptor acDesc;
    private Application appDesc;
    private String deployedAppName;
    private JavaWebStartInfo jwsInfo = null;

    public void init(DeploymentContext dc, AppClientDeployerHelper helper) {
        this.dc = dc;
        this.helper = helper;
        this.logger = LogDomains.getLogger(AppClientServerApplication.class, (String)"javax.enterprise.system.container.appclient");
        this.acDesc = helper.appClientDesc();
        this.appDesc = this.acDesc.getApplication();
        this.deployedAppName = ((DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class)).name();
    }

    public String deployedAppName() {
        return this.deployedAppName;
    }

    public ApplicationClientDescriptor getDescriptor() {
        return this.acDesc;
    }

    public AppClientDeployerHelper helper() {
        return this.helper;
    }

    public boolean start(ApplicationContext startupContext) throws Exception {
        return this.start();
    }

    boolean start() {
        if (this.jwsInfo == null) {
            this.jwsInfo = this.newJavaWebStartInfo();
        }
        this.jwsInfo.start();
        return true;
    }

    private JavaWebStartInfo newJavaWebStartInfo() {
        JavaWebStartInfo jwsInfo = this.habitat.getComponent(JavaWebStartInfo.class);
        jwsInfo.init(this);
        return jwsInfo;
    }

    public boolean stop(ApplicationContext stopContext) {
        return this.stop();
    }

    boolean stop() {
        if (this.jwsInfo != null) {
            this.jwsInfo.stop();
        }
        return true;
    }

    public boolean suspend() {
        if (this.jwsInfo != null) {
            this.jwsInfo.suspend();
        }
        return true;
    }

    public boolean resume() throws Exception {
        if (this.jwsInfo != null) {
            this.jwsInfo.resume();
        }
        return true;
    }

    public ClassLoader getClassLoader() {
        return new URLClassLoader(new URL[0]);
    }

    public DeploymentContext dc() {
        return this.dc;
    }

    public String registrationName() {
        return this.appDesc.getRegistrationName();
    }

    public String moduleExpression() {
        String moduleExpression = this.appDesc.isVirtual() ? this.appDesc.getRegistrationName() : this.appDesc.getRegistrationName() + "/" + this.acDesc.getModuleName();
        return moduleExpression;
    }
}

