/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.dynamic;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.exceptions.DynamicException;
import org.eclipse.persistence.indirection.IndirectContainer;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.dynamic.DynamicTypeImpl;
import org.eclipse.persistence.internal.dynamic.ValuesAccessor;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DynamicEntityImpl
implements DynamicEntity,
PersistenceEntity,
ChangeTracker,
FetchGroupTracker {
    protected Object[] values;
    protected transient DynamicTypeImpl type;
    private CacheKey cacheKey;
    private Vector<Object> primaryKey;
    private PropertyChangeListener changeListener = null;
    private FetchGroup fetchGroup;
    private boolean refreshFetchGroup = false;
    private Session session;

    protected DynamicEntityImpl(DynamicTypeImpl type) {
        this.type = type;
        this.values = new Object[type.getNumberOfProperties()];
    }

    public DynamicTypeImpl getType() throws DynamicException {
        if (this.type == null) {
            throw DynamicException.entityHasNullType(this);
        }
        return this.type;
    }

    @Override
    public <T> T get(String propertyName) {
        DatabaseMapping mapping = this.getType().getMapping(propertyName);
        Object value = mapping.getAttributeValueFromObject(this);
        if (mapping.isForeignReferenceMapping() && mapping.isLazy()) {
            if (value instanceof ValueHolderInterface) {
                value = ((ValueHolderInterface)value).getValue();
            }
            if (value instanceof IndirectContainer) {
                ((IndirectContainer)value).getValueHolder().getValue();
            }
        }
        try {
            return (T)value;
        }
        catch (ClassCastException cce) {
            throw DynamicException.invalidGetPropertyType(mapping, cce);
        }
    }

    @Override
    public DynamicEntity set(String propertyName, Object value) {
        DatabaseMapping mapping = this.getType().getMapping(propertyName);
        this.checkSetType(mapping, value);
        Object currentValue = mapping.getAttributeValueFromObject(this);
        if (currentValue instanceof ValueHolderInterface) {
            ((ValueHolderInterface)currentValue).setValue(value);
        } else {
            mapping.setAttributeValueInObject(this, value);
        }
        return this;
    }

    protected void checkSetType(DatabaseMapping mapping, Object value) {
        if (value == null) {
            if (mapping.isCollectionMapping() || mapping.getAttributeClassification() != null && mapping.getAttributeClassification().isPrimitive()) {
                throw DynamicException.invalidSetPropertyType(mapping, value);
            }
            return;
        }
        Class expectedType = mapping.getAttributeClassification();
        if (mapping.isForeignReferenceMapping()) {
            expectedType = mapping.isCollectionMapping() ? (((CollectionMapping)mapping).getContainerPolicy().isMapPolicy() ? Map.class : Collection.class) : ((ForeignReferenceMapping)mapping).getReferenceClass();
        }
        if (expectedType != null && expectedType.isPrimitive() && !value.getClass().isPrimitive()) {
            expectedType = Helper.getObjectClass(expectedType);
        }
        if (expectedType != null && !expectedType.isAssignableFrom(value.getClass())) {
            throw DynamicException.invalidSetPropertyType(mapping, value);
        }
    }

    public boolean isSet(DatabaseMapping mapping) {
        ValuesAccessor accessor = (ValuesAccessor)mapping.getAttributeAccessor();
        return accessor.isSet(this);
    }

    @Override
    public boolean isSet(String propertyName) {
        return this.isSet(this.getType().getMapping(propertyName));
    }

    @Override
    public CacheKey _persistence_getCacheKey() {
        return this.cacheKey;
    }

    @Override
    public void _persistence_setCacheKey(CacheKey key) {
        this.cacheKey = key;
    }

    @Override
    public Vector _persistence_getPKVector() {
        return this.primaryKey;
    }

    @Override
    public void _persistence_setPKVector(Vector pk) {
        this.primaryKey = pk;
    }

    @Override
    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this.changeListener;
    }

    @Override
    public void _persistence_setPropertyChangeListener(PropertyChangeListener listener) {
        this.changeListener = listener;
    }

    @Override
    public FetchGroup _persistence_getFetchGroup() {
        return this.fetchGroup;
    }

    @Override
    public void _persistence_setFetchGroup(FetchGroup group) {
        this.fetchGroup = group;
    }

    @Override
    public void _persistence_setShouldRefreshFetchGroup(boolean shouldRefreshFetchGroup) {
        this.refreshFetchGroup = shouldRefreshFetchGroup;
    }

    @Override
    public boolean _persistence_shouldRefreshFetchGroup() {
        return this.refreshFetchGroup;
    }

    @Override
    public boolean _persistence_isAttributeFetched(String attribute) {
        return this.fetchGroup == null || this.fetchGroup.containsAttribute(attribute);
    }

    @Override
    public void _persistence_resetFetchGroup() {
        throw new UnsupportedOperationException("DynamicEntityImpl._persistence_resetFetchGroup:: NOT SUPPORTED");
    }

    @Override
    public Session _persistence_getSession() {
        return this.session;
    }

    @Override
    public void _persistence_setSession(Session session) {
        this.session = session;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(20);
        sb.append('{');
        sb.append(Helper.getShortClassName(this.getClass()));
        if (this.primaryKey != null && this.primaryKey.size() > 0) {
            int len = this.primaryKey.size();
            for (int i = 0; i < len; ++i) {
                sb.append(' ');
                sb.append(this.primaryKey.elementAt(i));
            }
        }
        sb.append('}');
        return sb.toString();
    }
}

