/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.comm;

import com.sun.btrace.comm.Command;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class InstrumentCommand
extends Command {
    private byte[] code;
    private String[] args;

    public InstrumentCommand(byte[] code, String[] args) {
        super((byte)3);
        this.code = code;
        this.args = args;
    }

    protected InstrumentCommand() {
        this(null, null);
    }

    @Override
    protected void write(ObjectOutput out) throws IOException {
        out.writeInt(this.code.length);
        out.write(this.code);
        out.writeInt(this.args.length);
        for (String a : this.args) {
            out.writeUTF(a);
        }
    }

    @Override
    protected void read(ObjectInput in) throws IOException {
        int len = in.readInt();
        this.code = new byte[len];
        in.readFully(this.code);
        len = in.readInt();
        this.args = new String[len];
        for (int i = 0; i < len; ++i) {
            this.args[i] = in.readUTF();
        }
    }

    public byte[] getCode() {
        return this.code;
    }

    public String[] getArguments() {
        return this.args;
    }
}

