/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Binding;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.util.Extension;
import org.apache.catalina.util.ManifestResource;
import org.apache.catalina.util.StringManager;
import org.apache.naming.resources.Resource;

public final class ExtensionValidator {
    private static Logger log = Logger.getLogger(ExtensionValidator.class.getName());
    private static StringManager sm = StringManager.getManager("org.apache.catalina.util");
    private static HashMap containerAvailableExtensions = null;
    private static ArrayList containerManifestResources = new ArrayList();
    private static ResourceBundle messages = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static synchronized boolean validateApplication(DirContext dirContext, StandardContext context) throws IOException {
        block20: {
            appName = context.getPath();
            appManifestResources = new ArrayList<ManifestResource>();
            appManifestResource = null;
            if (dirContext == null) {
                return false;
            }
            inputStream = null;
            try {
                block19: {
                    wne = dirContext.listBindings("/META-INF/");
                    binding = (Binding)wne.nextElement();
                    if (!binding.getName().toUpperCase().equals("MANIFEST.MF")) break block19;
                    resource = (Resource)dirContext.lookup("/META-INF/" + binding.getName());
                    inputStream = resource.streamContent();
                    manifest = new Manifest(inputStream);
                    inputStream.close();
                    inputStream = null;
                    mre = new ManifestResource(ExtensionValidator.sm.getString("extensionValidator.web-application-manifest"), manifest, 2);
                    appManifestResources.add(mre);
                }
                var12_14 = null;
                ** if (inputStream == null) goto lbl-1000
            }
            catch (Throwable var11_18) {
                var12_15 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                throw var11_18;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    inputStream.close();
                }
                catch (Throwable t) {}
            }
lbl-1000:
            // 2 sources

            {
                break block20;
                catch (NamingException nex) {
                    var12_14 = null;
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable t) {}
                    }
                    break block20;
                }
                catch (NoSuchElementException nse) {
                    var12_14 = null;
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable t) {}
                    }
                }
            }
        }
        ne = null;
        try {
            if (dirContext != null) {
                ne = dirContext.listBindings("WEB-INF/lib/");
            }
            while (ne != null && ne.hasMoreElements()) {
                binding = (Binding)ne.nextElement();
                if (!binding.getName().toLowerCase().endsWith(".jar") || !((obj = dirContext.lookup("/WEB-INF/lib/" + binding.getName())) instanceof Resource) || (jmanifest = ExtensionValidator.getManifest((resource = (Resource)obj).streamContent())) == null) continue;
                mre = new ManifestResource(binding.getName(), jmanifest, 3);
                appManifestResources.add(mre);
            }
        }
        catch (NamingException nex) {
            // empty catch block
        }
        return ExtensionValidator.validateManifestResources(appName, appManifestResources);
    }

    private static boolean validateManifestResources(String appName, ArrayList resources) {
        boolean passes = true;
        int failureCount = 0;
        HashMap availableExtensions = null;
        for (ManifestResource mre : resources) {
            ArrayList requiredList = mre.getRequiredExtensions();
            if (requiredList == null) continue;
            if (availableExtensions == null) {
                availableExtensions = ExtensionValidator.buildAvailableExtensionsMap(resources);
            }
            if (containerAvailableExtensions == null) {
                containerAvailableExtensions = ExtensionValidator.buildAvailableExtensionsMap(containerManifestResources);
            }
            for (Extension requiredExt : requiredList) {
                Extension targetExt;
                String extId = requiredExt.getUniqueId();
                if (availableExtensions != null && availableExtensions.containsKey(extId)) {
                    targetExt = (Extension)availableExtensions.get(extId);
                    if (!targetExt.isCompatibleWith(requiredExt)) continue;
                    requiredExt.setFulfilled(true);
                    continue;
                }
                if (containerAvailableExtensions != null && containerAvailableExtensions.containsKey(extId)) {
                    targetExt = (Extension)containerAvailableExtensions.get(extId);
                    if (!targetExt.isCompatibleWith(requiredExt)) continue;
                    requiredExt.setFulfilled(true);
                    continue;
                }
                log.info(sm.getString("extensionValidator.extension-not-found-error", (Object)appName, (Object)mre.getResourceName(), requiredExt.getExtensionName()));
                passes = false;
                ++failureCount;
            }
        }
        if (!passes) {
            log.info(sm.getString("extensionValidator.extension-validation-error", (Object)appName, failureCount + ""));
        }
        return passes;
    }

    private static HashMap buildAvailableExtensionsMap(ArrayList resources) {
        HashMap<String, Extension> availableMap = null;
        for (ManifestResource mre : resources) {
            HashMap map = mre.getAvailableExtensions();
            if (map == null) continue;
            for (Extension ext : map.values()) {
                if (availableMap == null) {
                    availableMap = new HashMap<String, Extension>();
                    availableMap.put(ext.getUniqueId(), ext);
                    continue;
                }
                if (availableMap.containsKey(ext.getUniqueId())) continue;
                availableMap.put(ext.getUniqueId(), ext);
            }
        }
        return availableMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Manifest getManifest(InputStream inStream) throws IOException {
        Manifest manifest = null;
        JarInputStream jin = null;
        try {
            jin = new JarInputStream(inStream);
            manifest = jin.getManifest();
            jin.close();
            return manifest;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (jin == null) throw throwable;
            try {
                jin.close();
                throw throwable;
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private static void addSystemResource(File jarFile) throws IOException {
        Manifest manifest = ExtensionValidator.getManifest(new FileInputStream(jarFile));
        if (manifest != null) {
            ManifestResource mre = new ManifestResource(jarFile.getAbsolutePath(), manifest, 1);
            containerManifestResources.add(mre);
        }
    }

    static {
        String systemClasspath = System.getProperty("java.class.path");
        StringTokenizer strTok = new StringTokenizer(systemClasspath, File.pathSeparator);
        while (strTok.hasMoreTokens()) {
            File item;
            String classpathItem = strTok.nextToken();
            if (!classpathItem.toLowerCase().endsWith(".jar") || !(item = new File(classpathItem)).exists()) continue;
            try {
                ExtensionValidator.addSystemResource(item);
            }
            catch (IOException e) {
                log.log(Level.SEVERE, sm.getString("extensionValidator.failload", item), e);
            }
        }
        String extensionsDir = System.getProperty("java.ext.dirs");
        if (extensionsDir != null) {
            StringTokenizer extensionsTok = new StringTokenizer(extensionsDir, File.pathSeparator);
            while (extensionsTok.hasMoreTokens()) {
                File targetDir = new File(extensionsTok.nextToken());
                if (!targetDir.exists() || !targetDir.isDirectory()) continue;
                File[] files = targetDir.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    if (!files[i].getName().toLowerCase().endsWith(".jar")) continue;
                    try {
                        ExtensionValidator.addSystemResource(files[i]);
                        continue;
                    }
                    catch (IOException e) {
                        log.log(Level.SEVERE, sm.getString("extensionValidator.failload", files[i]), e);
                    }
                }
            }
        }
    }
}

