/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.appserv.connectors.internal.spi.ResourceDeployer;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class JdbcResourceDeployer
implements ResourceDeployer {
    @Inject
    private ConnectorRuntime runtime;
    private static final StringManager localStrings = StringManager.getManager(JdbcResourceDeployer.class);
    private static Logger _logger = LogDomains.getLogger(JdbcResourceDeployer.class, (String)"javax.enterprise.system.core");

    public void deployResource(Object resource) throws Exception {
        JdbcResource jdbcRes = (JdbcResource)resource;
        if (ConnectorsUtil.parseBoolean((String)jdbcRes.getEnabled())) {
            String jndiName = jdbcRes.getJndiName();
            String poolName = jdbcRes.getPoolName();
            this.runtime.createConnectorResource(jndiName, poolName, null);
            if (ConnectorsUtil.getValidSuffix((String)jndiName) == null) {
                this.runtime.createConnectorResource(ConnectorsUtil.getPMJndiName((String)jndiName), poolName, null);
            }
            _logger.finest("deployed resource " + jndiName);
        } else {
            _logger.log(Level.INFO, "core.resource_disabled", new Object[]{jdbcRes.getJndiName(), "jdbc"});
        }
    }

    public synchronized void undeployResource(Object resource) throws Exception {
        JdbcResource jdbcRes = (JdbcResource)resource;
        String jndiName = jdbcRes.getJndiName();
        this.runtime.deleteConnectorResource(jndiName);
        if (ConnectorsUtil.getValidSuffix((String)jndiName) == null) {
            this.runtime.deleteConnectorResource(ConnectorsUtil.getPMJndiName((String)jndiName));
        }
    }

    public synchronized void redeployResource(Object resource) throws Exception {
        this.undeployResource(resource);
        this.deployResource(resource);
    }

    public boolean handles(Object resource) {
        return resource instanceof JdbcResource;
    }

    public synchronized void enableResource(Object resource) throws Exception {
        this.deployResource(resource);
    }

    public synchronized void disableResource(Object resource) throws Exception {
        this.undeployResource(resource);
    }
}

