/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.modelgen.visitors;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.AbstractAnnotationValueVisitor6;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationValueVisitor<R, P>
extends AbstractAnnotationValueVisitor6<Object, Object> {
    @Override
    public Object visitAnnotation(AnnotationMirror annotationMirror, Object arg1) {
        MetadataAnnotation annotation = new MetadataAnnotation();
        annotation.setName(annotationMirror.getAnnotationType().toString());
        Set<? extends ExecutableElement> keys = annotationMirror.getElementValues().keySet();
        for (ExecutableElement executableElement : keys) {
            AnnotationValue annotationValue = annotationMirror.getElementValues().get(executableElement);
            String attribute = executableElement.getSimpleName().toString();
            Object attributeValue = annotationValue.accept(this, arg1);
            annotation.addAttribute(attribute, attributeValue);
        }
        return annotation;
    }

    @Override
    public Object visitArray(List<? extends AnnotationValue> annotationValues, Object arg1) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (AnnotationValue annotationValue : annotationValues) {
            values.add(annotationValue.accept(this, arg1));
        }
        return values.toArray();
    }

    @Override
    public Object visitBoolean(boolean bool, Object arg1) {
        return new Boolean(bool);
    }

    @Override
    public Object visitByte(byte b, Object arg1) {
        return new Byte(b);
    }

    @Override
    public Object visitChar(char c, Object arg1) {
        return new Character(c);
    }

    @Override
    public Object visitDouble(double d, Object arg1) {
        return new Double(d);
    }

    @Override
    public Object visitEnumConstant(VariableElement variableArgument, Object arg1) {
        return variableArgument.getSimpleName().toString();
    }

    @Override
    public Object visitFloat(float f, Object arg1) {
        return new Float(f);
    }

    @Override
    public Object visitInt(int i, Object arg1) {
        return new Integer(i);
    }

    @Override
    public Object visitLong(long l, Object arg1) {
        return new Long(l);
    }

    @Override
    public Object visitShort(short s, Object arg1) {
        return new Short(s);
    }

    @Override
    public Object visitString(String str, Object arg1) {
        return str;
    }

    @Override
    public Object visitType(TypeMirror typeMirror, Object arg1) {
        return ((Object)typeMirror).toString();
    }
}

