/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.interceptor.registry;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.interceptor.model.InterceptorClassMetadata;
import org.jboss.interceptor.model.InterceptorClassMetadataImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorClassMetadataRegistry {
    private static InterceptorClassMetadataRegistry interceptorMetadataRegistry = new InterceptorClassMetadataRegistry();
    private final Map<Class<?>, InterceptorClassMetadata> interceptorClassMetadataMap = new ConcurrentHashMap();
    private final Lock lock = new ReentrantLock();

    public static InterceptorClassMetadataRegistry getRegistry() {
        return interceptorMetadataRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterceptorClassMetadata getInterceptorClassMetadata(Class<?> interceptorClass) {
        if (!this.interceptorClassMetadataMap.containsKey(interceptorClass)) {
            try {
                this.lock.lock();
                if (!this.interceptorClassMetadataMap.containsKey(interceptorClass)) {
                    this.interceptorClassMetadataMap.put(interceptorClass, new InterceptorClassMetadataImpl(interceptorClass));
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.interceptorClassMetadataMap.get(interceptorClass);
    }
}

