/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Producer;
import javax.inject.Inject;
import javax.inject.Scope;
import org.jboss.weld.BeanManagerImpl;
import org.jboss.weld.DefinitionException;
import org.jboss.weld.IllegalProductException;
import org.jboss.weld.WeldException;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.AbstractReceiverBean;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.introspector.WeldMember;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Names;
import org.jboss.weld.util.Reflections;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProducerBean<X, T, S extends Member>
extends AbstractReceiverBean<X, T, S> {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BEAN);
    private Producer<T> producer;
    private boolean passivationCapable;

    public AbstractProducerBean(String idSuffix, AbstractClassBean<X> declaringBean, BeanManagerImpl manager) {
        super(idSuffix, declaringBean, manager);
    }

    @Override
    public abstract WeldMember<T, X, S> getAnnotatedItem();

    @Override
    public Class<?> getBeanClass() {
        return this.getDeclaringBean().getBeanClass();
    }

    @Override
    protected void initTypes() {
        if (this.getType().isArray() || this.getType().isPrimitive()) {
            HashSet<Class<Object>> types = new HashSet<Class<Object>>();
            types.add(this.getType());
            types.add(Object.class);
            this.types = types;
        } else {
            super.initTypes();
        }
    }

    protected void initType() {
        try {
            this.type = this.getAnnotatedItem().getJavaClass();
        }
        catch (ClassCastException e) {
            Type type = Beans.getDeclaredBeanType(this.getClass());
            throw new WeldException(BeanMessage.PRODUCER_CAST_ERROR, (Throwable)e, this.getAnnotatedItem().getJavaClass(), type == null ? " unknown " : type);
        }
    }

    protected void checkProducerReturnType() {
        if (this.getAnnotatedItem().getBaseType() instanceof TypeVariable || this.getAnnotatedItem().getBaseType() instanceof WildcardType) {
            throw new DefinitionException(BeanMessage.RETURN_TYPE_MUST_BE_CONCRETE, this.getAnnotatedItem().getBaseType());
        }
        for (Type type : this.getAnnotatedItem().getActualTypeArguments()) {
            if (type instanceof Class) continue;
            throw new DefinitionException(BeanMessage.TYPE_PARAMETER_MUST_BE_CONCRETE, this.getAnnotatedItem());
        }
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        this.getDeclaringBean().initialize(environment);
        super.initialize(environment);
        this.checkProducerReturnType();
        this.initPassivationCapable();
        this.initAlternative();
    }

    private void initPassivationCapable() {
        this.passivationCapable = !this.getAnnotatedItem().isFinal() || Serializable.class.isAssignableFrom(this.getAnnotatedItem().getJavaClass());
    }

    @Override
    protected void initAlternative() {
        this.alternative = Beans.isAlternative(this.getAnnotatedItem(), this.getMergedStereotypes()) || this.getDeclaringBean().isAlternative();
    }

    @Override
    public boolean isPassivationCapable() {
        return this.passivationCapable;
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return this.getProducer().getInjectionPoints();
    }

    protected void checkReturnValue(T instance) {
        if (instance == null && !this.isDependent()) {
            throw new IllegalProductException(BeanMessage.NULL_NOT_ALLOWED_FROM_PRODUCER, this.getProducer());
        }
        if (instance != null) {
            boolean passivating = this.manager.getServices().get(MetaAnnotationStore.class).getScopeModel(this.getScope()).isPassivating();
            if (passivating && !Reflections.isSerializable(instance.getClass())) {
                throw new IllegalProductException(BeanMessage.NON_SERIALIZABLE_PRODUCT_ERROR, this.getProducer());
            }
            InjectionPoint injectionPoint = this.manager.getCurrentInjectionPoint();
            if (injectionPoint == null || injectionPoint.equals(BeanManagerImpl.DUMMY_INJECTION_POINT)) {
                return;
            }
            if (!Reflections.isSerializable(instance.getClass()) && Beans.isPassivatingScope(injectionPoint.getBean(), this.manager)) {
                if (injectionPoint.getMember() instanceof Field) {
                    if (!injectionPoint.isTransient() && instance != null && !Reflections.isSerializable(instance.getClass())) {
                        throw new IllegalProductException(BeanMessage.NON_SERIALIZABLE_FIELD_INJECTION_ERROR, this, injectionPoint);
                    }
                } else if (injectionPoint.getMember() instanceof Method) {
                    Method method = (Method)injectionPoint.getMember();
                    if (method.isAnnotationPresent(Inject.class)) {
                        throw new IllegalProductException(BeanMessage.NON_SERIALIZABLE_INITIALIZER_PARAM_INJECTION_ERROR, this, injectionPoint);
                    }
                    if (method.isAnnotationPresent(Produces.class)) {
                        throw new IllegalProductException(BeanMessage.NON_SERIALIZABLE_PRODUCER_PARAM_INJECTION_ERROR, this, injectionPoint);
                    }
                } else if (injectionPoint.getMember() instanceof Constructor) {
                    throw new IllegalProductException(BeanMessage.NON_SERIALIZABLE_CONSTRUCTOR_PARAM_INJECTION_ERROR, this, injectionPoint);
                }
            }
        }
    }

    @Override
    protected void initScopeType() {
        HashSet<Annotation> scopeAnnotations = new HashSet<Annotation>();
        scopeAnnotations.addAll(this.getAnnotatedItem().getMetaAnnotations(Scope.class));
        scopeAnnotations.addAll(this.getAnnotatedItem().getMetaAnnotations(NormalScope.class));
        if (scopeAnnotations.size() > 1) {
            throw new DefinitionException(BeanMessage.ONLY_ONE_SCOPE_ALLOWED, this.getProducer());
        }
        if (scopeAnnotations.size() == 1) {
            this.scopeType = ((Annotation)scopeAnnotations.iterator().next()).annotationType();
            log.trace(BeanMessage.USING_SCOPE, this.scopeType, this);
            return;
        }
        this.initScopeTypeFromStereotype();
        if (this.scopeType == null) {
            this.scopeType = Dependent.class;
            log.trace(BeanMessage.USING_DEFAULT_SCOPE, this);
        }
    }

    public void setProducer(Producer<T> producer) {
        this.producer = producer;
    }

    public Producer<T> getProducer() {
        return this.producer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T create(CreationalContext<T> creationalContext) {
        try {
            T instance = this.getProducer().produce(creationalContext);
            this.checkReturnValue(instance);
            T t = instance;
            return t;
        }
        finally {
            if (this.getDeclaringBean().isDependent()) {
                creationalContext.release();
            }
        }
    }

    @Override
    public String getDescription() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Annotated " + Names.scopeTypeToString(this.getScope()));
        if (this.getName() == null) {
            buffer.append("unnamed producer bean");
        } else {
            buffer.append("simple producer bean '" + this.getName() + "'");
        }
        buffer.append(" [" + this.getBeanClass().getName() + "] for class type [" + this.getType().getName() + "] API types " + this.getTypes() + ", binding types " + this.getQualifiers());
        return buffer.toString();
    }
}

