/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.gadget;

import com.sun.jsftemplating.layout.LayoutDefinitionManager;
import com.sun.jsftemplating.layout.descriptors.handler.Handler;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerDefinition;
import com.sun.jsftemplating.util.FileUtil;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.glassfish.admingui.common.gadget.GadgetModule;
import org.glassfish.admingui.common.util.GuiUtil;
import org.jvnet.hk2.config.ConfigParser;
import org.jvnet.hk2.config.DomDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GadgetHandlers {
    public static void getGadgetModule(HandlerContext handlerCtx) {
        String gadgetName = (String)handlerCtx.getInputValue("name");
        URL url = null;
        try {
            if (!gadgetName.contains("://")) {
                url = FileUtil.searchForFile((String)gadgetName, null);
            }
            if (url == null) {
                url = new URL(gadgetName);
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Cannot creaqte URL from '" + gadgetName + "'!", ex);
        }
        GadgetModule module = GadgetHandlers.getGadgetModule(url);
        handlerCtx.setOutputValue("module", (Object)module);
    }

    public static GadgetModule getGadgetModule(URL url) {
        if (url == null) {
            return null;
        }
        ConfigParser parser = new ConfigParser(GuiUtil.getHabitat());
        Object id = null;
        DomDocument doc = parser.parse(url);
        GadgetModule module = (GadgetModule)doc.getRoot().get();
        return module;
    }

    public static Object invokeHandler(HandlerContext handlerCtx) {
        String handlerName = (String)handlerCtx.getInputValue("handler");
        HandlerDefinition handlerDef = LayoutDefinitionManager.getGlobalHandlerDefinition((String)handlerName);
        if (handlerDef == null) {
            throw new IllegalArgumentException("Handler '" + handlerName + "' not found!");
        }
        Handler oldHandler = handlerCtx.getHandler();
        Handler handler = new Handler(handlerDef);
        ArrayList<String> outputNames = new ArrayList<String>();
        String args = (String)handlerCtx.getInputValue("args");
        StringTokenizer tok = new StringTokenizer(args, ",");
        while (tok.hasMoreTokens()) {
            String nvp = tok.nextToken();
            int colon = nvp.indexOf(58);
            if (colon == -1) {
                throw new IllegalArgumentException("Handler I/O name:value must be separated by a ':'!");
            }
            String name = nvp.substring(0, colon).trim();
            String value = nvp.substring(colon + 1).trim();
            try {
                value = URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new IllegalArgumentException("Unable to decode value, this is not normal!", ex);
            }
            if (handlerDef.getInputDef(name) != null) {
                handler.setInputValue(name, (Object)value);
                continue;
            }
            handler.setOutputMapping(name, value, "el");
            outputNames.add(name);
        }
        ArrayList<Handler> handlers = new ArrayList<Handler>(1);
        handlers.add(handler);
        Object result = handlerCtx.getLayoutElement().dispatchHandlers(handlerCtx, handlers);
        HashMap<String, Object> outputValues = new HashMap<String, Object>();
        for (String outName : outputNames) {
            outputValues.put(outName, handler.getOutputValue(handlerCtx, outName));
        }
        handlerCtx.setHandler(oldHandler);
        Integer depth = (Integer)handlerCtx.getInputValue("depth");
        if (depth == null) {
            depth = 10;
        }
        handlerCtx.setOutputValue("values", (Object)GadgetHandlers.getJSON(outputValues, depth));
        return result;
    }

    public static String getJSON(Object obj, int depth) {
        if (depth == 0) {
            return "";
        }
        if (depth == -1) {
            depth = 10;
        }
        String value = "";
        if (obj == null) {
            value = "null";
        } else if (obj instanceof String) {
            StringCharacterIterator it = new StringCharacterIterator((String)obj);
            char ch = it.first();
            StringBuilder builder = new StringBuilder(((String)obj).length() << 2);
            builder.append("\"");
            while (ch != '\uffff') {
                switch (ch) {
                    case '\t': {
                        builder.append("\\t");
                        break;
                    }
                    case '\n': {
                        builder.append("\\n");
                        break;
                    }
                    case '\r': {
                        builder.append("\\r");
                        break;
                    }
                    case '\b': {
                        builder.append("\\b");
                        break;
                    }
                    case '\f': {
                        builder.append("\\f");
                        break;
                    }
                    case '\"': 
                    case '&': 
                    case '\'': 
                    case '(': 
                    case ')': 
                    case '/': 
                    case ':': 
                    case '<': 
                    case '>': 
                    case '\\': 
                    case '{': 
                    case '}': {
                        builder.append("\\");
                        builder.append(ch);
                        break;
                    }
                    default: {
                        if (ch > '~' || ch < ' ') {
                            builder.append("\\u");
                            String chStr = Integer.toHexString(ch);
                            int len = chStr.length();
                            for (int idx = 4; idx > len; --idx) {
                                builder.append('0');
                            }
                            builder.append(chStr);
                            break;
                        }
                        builder.append(ch);
                    }
                }
                ch = it.next();
            }
            builder.append("\"");
            value = builder.toString();
        } else if (obj instanceof Boolean || obj instanceof Number) {
            value = obj.toString();
        } else if (obj instanceof Object[]) {
            StringBuilder builder = new StringBuilder("[");
            boolean first = true;
            for (Object element : (Object[])obj) {
                if (first) {
                    first = false;
                } else {
                    builder.append(',');
                }
                if (depth == 1) {
                    builder.append(GadgetHandlers.getJSON(element.toString(), 1));
                    continue;
                }
                builder.append(GadgetHandlers.getJSON(element, depth - 1));
            }
            builder.append("]");
            value = builder.toString();
        } else if (obj instanceof Map) {
            StringBuilder builder = new StringBuilder("{");
            boolean first = true;
            Map map = (Map)obj;
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(',');
                }
                String key = it.next().toString();
                builder.append(GadgetHandlers.getJSON(key, 1) + ":");
                if (depth == 1) {
                    builder.append(GadgetHandlers.getJSON(map.get(key).toString(), 1));
                    continue;
                }
                builder.append(GadgetHandlers.getJSON(map.get(key), depth - 1));
            }
            builder.append("}");
            value = builder.toString();
        } else if (obj instanceof Collection) {
            StringBuilder builder = new StringBuilder("[");
            boolean first = true;
            Iterator it = ((Collection)obj).iterator();
            while (it.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(',');
                }
                if (depth == 1) {
                    builder.append(GadgetHandlers.getJSON(it.next().toString(), 1));
                    continue;
                }
                builder.append(GadgetHandlers.getJSON(it.next(), depth - 1));
            }
            builder.append("]");
            value = builder.toString();
        } else {
            StringBuilder builder = new StringBuilder("{");
            boolean first = true;
            Iterator<String> it = GadgetHandlers.getGetters(obj).iterator();
            while (it.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(',');
                }
                String methodName = it.next().toString();
                builder.append(GadgetHandlers.getJSON(methodName.substring(3), 1) + ":");
                Object result = GadgetHandlers.invokeGetter(obj, methodName);
                if (result != null && depth == 1) {
                    builder.append(GadgetHandlers.getJSON(result.toString(), 1));
                    continue;
                }
                builder.append(GadgetHandlers.getJSON(result, depth - 1));
            }
            builder.append("}");
            value = builder.toString();
        }
        return value;
    }

    private static Object invokeGetter(Object obj, String methodName) {
        try {
            return obj.getClass().getMethod(methodName, new Class[0]).invoke(obj, new Object[0]);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static List<String> getGetters(Object obj) {
        ArrayList<String> result = new ArrayList<String>();
        for (Method method : obj.getClass().getMethods()) {
            if (!method.getName().startsWith("get") || (method.getModifiers() & 1) == 0 || method.getParameterTypes().length != 0 || method.getName().equals("getClass") || method.getReturnType().getName().equals("void")) continue;
            result.add(method.getName());
        }
        return result;
    }
}

