/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.searchpolicy;

import java.util.ArrayList;
import java.util.List;
import org.apache.felix.framework.searchpolicy.CandidateSet;
import org.apache.felix.moduleloader.ICapability;

class ResolvedPackage {
    public final String m_name;
    public final CandidateSet m_cs;
    public final List m_capList = new ArrayList();

    public ResolvedPackage(String name, CandidateSet cs) {
        this.m_name = name;
        this.m_cs = cs;
    }

    public boolean isSubset(ResolvedPackage rp) {
        if (this.m_capList.size() > rp.m_capList.size()) {
            return false;
        }
        if (!this.m_name.equals(rp.m_name)) {
            return false;
        }
        return rp.m_capList.containsAll(this.m_capList);
    }

    public Object clone() {
        ResolvedPackage rp = new ResolvedPackage(this.m_name, this.m_cs);
        rp.m_capList.addAll(this.m_capList);
        return rp;
    }

    public void merge(ResolvedPackage rp) {
        for (int capIdx = 0; capIdx < rp.m_capList.size(); ++capIdx) {
            if (this.m_capList.contains(rp.m_capList.get(capIdx))) continue;
            this.m_capList.add(rp.m_capList.get(capIdx));
        }
    }

    public String toString() {
        return this.toString("", new StringBuffer()).toString();
    }

    public StringBuffer toString(String padding, StringBuffer sb) {
        sb.append(padding);
        sb.append(this.m_name);
        sb.append(" from [");
        for (int i = 0; i < this.m_capList.size(); ++i) {
            ICapability cap = (ICapability)this.m_capList.get(i);
            sb.append(cap.getModule());
            if (i + 1 >= this.m_capList.size()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb;
    }
}

