/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.felix.cm.PersistenceManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

class DynamicBindings {
    static final String BINDINGS_FILE_NAME = "org_apache_felix_cm_impl_DynamicBindings";
    private final PersistenceManager persistenceManager;
    private final Dictionary bindings;

    DynamicBindings(BundleContext bundleContext, PersistenceManager persistenceManager) throws IOException {
        this.persistenceManager = persistenceManager;
        if (persistenceManager.exists(BINDINGS_FILE_NAME)) {
            this.bindings = persistenceManager.load(BINDINGS_FILE_NAME);
            HashSet<String> locations = new HashSet<String>();
            Bundle[] bundles = bundleContext.getBundles();
            for (int i = 0; i < bundles.length; ++i) {
                locations.add(bundles[i].getLocation());
            }
            ArrayList<String> removedKeys = new ArrayList<String>();
            Enumeration ke = this.bindings.keys();
            while (ke.hasMoreElements()) {
                String pid = (String)ke.nextElement();
                String location = (String)this.bindings.get(pid);
                if (locations.contains(location)) continue;
                removedKeys.add(pid);
            }
            if (removedKeys.size() > 0) {
                Iterator rki = removedKeys.iterator();
                while (rki.hasNext()) {
                    this.bindings.remove(rki.next());
                }
                persistenceManager.store(BINDINGS_FILE_NAME, this.bindings);
            }
        } else {
            this.bindings = new Hashtable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getLocation(String pid) {
        DynamicBindings dynamicBindings = this;
        synchronized (dynamicBindings) {
            return (String)this.bindings.get(pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putLocation(String pid, String location) throws IOException {
        DynamicBindings dynamicBindings = this;
        synchronized (dynamicBindings) {
            if (location == null) {
                this.bindings.remove(pid);
            } else {
                this.bindings.put(pid, location);
            }
            this.persistenceManager.store(BINDINGS_FILE_NAME, this.bindings);
        }
    }
}

