/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import java.lang.reflect.Method;
import java.util.List;
import javax.enterprise.inject.spi.Decorator;
import org.jboss.interceptor.util.proxy.TargetInstanceProxyMethodHandler;
import org.jboss.weld.ForbiddenStateException;
import org.jboss.weld.bean.AnnotatedItemProvidingDecoratorWrapper;
import org.jboss.weld.bean.DecoratorImpl;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.introspector.jlr.MethodSignatureImpl;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.serialization.spi.helpers.SerializableContextualInstance;
import org.jboss.weld.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecoratorProxyMethodHandler
extends TargetInstanceProxyMethodHandler {
    private static final long serialVersionUID = 4577632640130385060L;
    private final List<SerializableContextualInstance<Decorator<Object>, Object>> decoratorInstances;

    public DecoratorProxyMethodHandler(List<SerializableContextualInstance<Decorator<Object>, Object>> decoratorInstances, Object instance) {
        super(instance, instance.getClass());
        this.decoratorInstances = decoratorInstances;
    }

    @Override
    protected Object doInvoke(Object self, Method method, Method proceed, Object[] args) throws Throwable {
        MethodSignatureImpl methodSignature = new MethodSignatureImpl(method);
        for (SerializableContextualInstance<Decorator<Object>, Object> beanInstance : this.decoratorInstances) {
            WeldMethod decoratorMethod;
            if (beanInstance.getContextual().get() instanceof DecoratorImpl) {
                decoratorMethod = ((DecoratorImpl)beanInstance.getContextual().get()).getAnnotatedItem().getWeldMethod(methodSignature);
            } else if (beanInstance.getContextual().get() instanceof AnnotatedItemProvidingDecoratorWrapper) {
                decoratorMethod = ((AnnotatedItemProvidingDecoratorWrapper)beanInstance.getContextual().get()).getAnnotatedItem().getWeldMethod(methodSignature);
            } else {
                throw new ForbiddenStateException(BeanMessage.UNEXPECTED_UNWRAPPED_CUSTOM_DECORATOR, beanInstance.getContextual().get());
            }
            if (decoratorMethod == null) continue;
            return decoratorMethod.invokeOnInstance(beanInstance.getInstance(), args);
        }
        return Reflections.ensureAccessible(method).invoke(this.getTargetInstance(), args);
    }
}

