/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resources;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.Callable;
import javax.enterprise.inject.spi.AnnotatedType;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.introspector.WeldAnnotation;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.jlr.WeldAnnotationImpl;
import org.jboss.weld.introspector.jlr.WeldClassImpl;
import org.jboss.weld.metadata.TypeStore;
import org.jboss.weld.util.collections.ConcurrentCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassTransformer
implements Service {
    private final ConcurrentCache<Type, WeldClass<?>> classes = new ConcurrentCache();
    private final ConcurrentCache<AnnotatedType<?>, WeldClass<?>> annotatedTypes = new ConcurrentCache();
    private final ConcurrentCache<Class<?>, WeldAnnotation<?>> annotations = new ConcurrentCache();
    private final TypeStore typeStore;

    public ClassTransformer(TypeStore typeStore) {
        this.typeStore = typeStore;
    }

    public <T> WeldClass<T> loadClass(final Class<T> rawType, final Type baseType) {
        return (WeldClass)this.classes.putIfAbsent(baseType, new Callable<WeldClass<T>>(){

            @Override
            public WeldClass<T> call() throws Exception {
                return WeldClassImpl.of(rawType, baseType, ClassTransformer.this);
            }
        });
    }

    public <T> WeldClass<T> loadClass(final Class<T> clazz) {
        return (WeldClass)this.classes.putIfAbsent(clazz, new Callable<WeldClass<T>>(){

            @Override
            public WeldClass<T> call() throws Exception {
                return WeldClassImpl.of(clazz, ClassTransformer.this);
            }
        });
    }

    public <T> WeldClass<T> loadClass(final AnnotatedType<T> clazz) {
        return (WeldClass)this.annotatedTypes.putIfAbsent(clazz, new Callable<WeldClass<T>>(){

            @Override
            public WeldClass<T> call() throws Exception {
                return WeldClassImpl.of(clazz, ClassTransformer.this);
            }
        });
    }

    public <T extends Annotation> WeldAnnotation<T> loadAnnotation(final Class<T> clazz) {
        return (WeldAnnotation)this.annotations.putIfAbsent(clazz, new Callable<WeldAnnotation<T>>(){

            @Override
            public WeldAnnotation<T> call() throws Exception {
                return WeldAnnotationImpl.of(clazz, ClassTransformer.this);
            }
        });
    }

    public TypeStore getTypeStore() {
        return this.typeStore;
    }

    @Override
    public void cleanup() {
        this.annotatedTypes.clear();
        this.annotations.clear();
        this.classes.clear();
    }
}

