/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecurityPermission;
import java.util.Collection;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Globals;
import org.apache.catalina.connector.Response;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.util.StringManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseFacade
implements HttpServletResponse {
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.connector");
    protected Response response = null;

    public ResponseFacade(Response response) {
        this.response = response;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void clear() {
        this.response = null;
    }

    public void finish() {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        this.response.setSuspended(true);
    }

    public boolean isFinished() {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        return this.response.isSuspended();
    }

    @Override
    public String getCharacterEncoding() {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        return this.response.getCharacterEncoding();
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        ServletOutputStream sos = this.response.getOutputStream();
        if (this.isFinished()) {
            this.response.setSuspended(true);
        }
        return sos;
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        PrintWriter writer = this.response.getWriter();
        if (this.isFinished()) {
            this.response.setSuspended(true);
        }
        return writer;
    }

    @Override
    public void setContentLength(int len) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        if (this.isCommitted()) {
            return;
        }
        this.response.setContentLength(len);
    }

    @Override
    public void setContentType(String type) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        if (this.isCommitted()) {
            return;
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            AccessController.doPrivileged(new SetContentTypePrivilegedAction(type));
        } else {
            this.response.setContentType(type);
        }
    }

    @Override
    public void setBufferSize(int size) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        if (this.isCommitted()) {
            throw new IllegalStateException();
        }
        this.response.setBufferSize(size);
    }

    @Override
    public int getBufferSize() {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        return this.response.getBufferSize();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void flushBuffer() throws IOException {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        if (this.isFinished()) {
            return;
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        ResponseFacade.this.response.setAppCommitted(true);
                        ResponseFacade.this.response.flushBuffer();
                        return null;
                    }
                });
                return;
            }
            catch (PrivilegedActionException e) {
                Exception ex = e.getException();
                if (!(ex instanceof IOException)) return;
                throw (IOException)ex;
            }
        } else {
            this.response.setAppCommitted(true);
            this.response.flushBuffer();
        }
    }

    @Override
    public void resetBuffer() {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        if (this.isCommitted()) {
            throw new IllegalStateException();
        }
        this.response.resetBuffer();
    }

    @Override
    public boolean isCommitted() {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        return this.response.isAppCommitted();
    }

    @Override
    public void reset() {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        if (this.isCommitted()) {
            throw new IllegalStateException();
        }
        this.response.reset();
    }

    @Override
    public void setLocale(Locale loc) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        if (this.isCommitted()) {
            return;
        }
        this.response.setLocale(loc);
    }

    @Override
    public Locale getLocale() {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        return this.response.getLocale();
    }

    @Override
    public void addCookie(Cookie cookie) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        if (this.isCommitted()) {
            return;
        }
        this.response.addCookie(cookie);
    }

    @Override
    public boolean containsHeader(String name) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        return this.response.containsHeader(name);
    }

    @Override
    public String encodeURL(String url) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        return this.response.encodeURL(url);
    }

    @Override
    public String encodeRedirectURL(String url) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        return this.response.encodeRedirectURL(url);
    }

    @Override
    public String encodeUrl(String url) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        return this.response.encodeURL(url);
    }

    @Override
    public String encodeRedirectUrl(String url) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        return this.response.encodeRedirectURL(url);
    }

    @Override
    public void sendError(int sc, String msg) throws IOException {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        if (this.isCommitted()) {
            throw new IllegalStateException();
        }
        this.response.setAppCommitted(true);
        this.response.sendError(sc, msg);
    }

    @Override
    public void sendError(int sc) throws IOException {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        if (this.isCommitted()) {
            throw new IllegalStateException();
        }
        this.response.setAppCommitted(true);
        this.response.sendError(sc);
    }

    @Override
    public void sendRedirect(String location) throws IOException {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        if (this.isCommitted()) {
            throw new IllegalStateException();
        }
        this.response.setAppCommitted(true);
        this.response.sendRedirect(location);
    }

    @Override
    public void setDateHeader(String name, long date) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        if (this.isCommitted()) {
            return;
        }
        this.response.setDateHeader(name, date);
    }

    @Override
    public void addDateHeader(String name, long date) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        if (this.isCommitted()) {
            return;
        }
        this.response.addDateHeader(name, date);
    }

    @Override
    public void setHeader(String name, String value) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        if (this.isCommitted()) {
            return;
        }
        this.response.setHeader(name, value);
    }

    @Override
    public void addHeader(String name, String value) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        if (this.isCommitted()) {
            return;
        }
        this.response.addHeader(name, value);
    }

    @Override
    public void setIntHeader(String name, int value) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        if (this.isCommitted()) {
            return;
        }
        this.response.setIntHeader(name, value);
    }

    @Override
    public void addIntHeader(String name, int value) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        if (this.isCommitted()) {
            return;
        }
        this.response.addIntHeader(name, value);
    }

    @Override
    public void setStatus(int sc) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        if (this.isCommitted()) {
            return;
        }
        this.response.setStatus(sc);
    }

    @Override
    public void setStatus(int sc, String msg) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        if (this.isCommitted()) {
            return;
        }
        this.response.setStatus(sc, msg);
    }

    @Override
    public String getContentType() {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        return this.response.getContentType();
    }

    @Override
    public void setCharacterEncoding(String arg0) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        this.response.setCharacterEncoding(arg0);
    }

    @Override
    public int getStatus() {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        return this.response.getStatus();
    }

    public String getMessage() {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        return this.response.getMessage();
    }

    public void setSuspended(boolean suspended) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        this.response.setSuspended(suspended);
    }

    public void setAppCommitted(boolean appCommitted) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        this.response.setAppCommitted(appCommitted);
    }

    public int getContentCount() {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        return this.response.getContentCount();
    }

    public boolean isError() {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        return this.response.isError();
    }

    @Override
    public String getHeader(String name) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        return this.response.getHeader(name);
    }

    @Override
    public Collection<String> getHeaders(String name) {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        return this.response.getHeaders(name);
    }

    @Override
    public Collection<String> getHeaderNames() {
        if (this.response == null) {
            throw new IllegalStateException(sm.getString("responseFacade.nullResponse"));
        }
        return this.response.getHeaderNames();
    }

    public Response getUnwrappedCoyoteResponse() throws AccessControlException {
        if (Globals.IS_SECURITY_ENABLED) {
            SecurityPermission perm = new SecurityPermission("getUnwrappedCoyoteResponse");
            AccessController.checkPermission(perm);
        }
        return this.response;
    }

    private final class SetContentTypePrivilegedAction
    implements PrivilegedAction {
        private String contentType;

        public SetContentTypePrivilegedAction(String contentType) {
            this.contentType = contentType;
        }

        public Object run() {
            ResponseFacade.this.response.setContentType(this.contentType);
            return null;
        }
    }
}

