/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.v3.server.CommonClassLoaderServiceImpl;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.DelegatingClassLoader;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class AppLibClassLoaderServiceImpl {
    @Inject
    Habitat habitat;
    @Inject
    CommonClassLoaderServiceImpl commonCLS;
    private Map<URI, DelegatingClassLoader.ClassFinder> classFinderRegistry = new HashMap<URI, DelegatingClassLoader.ClassFinder>();

    public ClassLoader getAppLibClassLoader(String application, List<URI> libURIs) throws MalformedURLException {
        ClassLoaderHierarchy clh = (ClassLoaderHierarchy)this.habitat.getComponent(ClassLoaderHierarchy.class);
        DelegatingClassLoader connectorCL = clh.getConnectorClassLoader(application);
        if (libURIs == null || libURIs.isEmpty()) {
            return connectorCL;
        }
        ClassLoader commonCL = this.commonCLS.getCommonClassLoader();
        DelegatingClassLoader applibCL = new DelegatingClassLoader(commonCL);
        for (DelegatingClassLoader.ClassFinder cf : connectorCL.getDelegates()) {
            applibCL.addDelegate(cf);
        }
        this.addDelegates(libURIs, applibCL);
        return applibCL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDelegates(Collection<URI> libURIs, DelegatingClassLoader holder) throws MalformedURLException {
        ClassLoader commonCL = this.commonCLS.getCommonClassLoader();
        for (URI libURI : libURIs) {
            AppLibClassLoaderServiceImpl appLibClassLoaderServiceImpl = this;
            synchronized (appLibClassLoaderServiceImpl) {
                DelegatingClassLoader.ClassFinder libCF = this.classFinderRegistry.get(libURI);
                if (libCF == null) {
                    libCF = new URLClassFinder(new URL[]{libURI.toURL()}, commonCL);
                    this.classFinderRegistry.put(libURI, libCF);
                }
                holder.addDelegate(libCF);
            }
        }
    }

    public DelegatingClassLoader.ClassFinder getAppLibClassFinder(Collection<URI> libURIs) throws MalformedURLException {
        ClassLoader commonCL = this.commonCLS.getCommonClassLoader();
        AppLibClassFinder appLibClassFinder = new AppLibClassFinder(commonCL);
        this.addDelegates(libURIs, appLibClassFinder);
        return appLibClassFinder;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AppLibClassFinder
    extends DelegatingClassLoader
    implements DelegatingClassLoader.ClassFinder {
        public AppLibClassFinder(ClassLoader parent, List<DelegatingClassLoader.ClassFinder> delegates) throws IllegalArgumentException {
            super(parent, delegates);
        }

        public AppLibClassFinder(ClassLoader parent) {
            super(parent);
        }

        public Class<?> findExistingClass(String name) {
            return null;
        }

        public URL findResource(String name) {
            return super.findResource(name);
        }

        public Enumeration<URL> findResources(String name) throws IOException {
            return super.findResources(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class URLClassFinder
    extends URLClassLoader
    implements DelegatingClassLoader.ClassFinder {
        public URLClassFinder(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            Class<?> c = this.findLoadedClass(name);
            if (c != null) {
                return c;
            }
            return super.findClass(name);
        }

        public Class<?> findExistingClass(String name) {
            return super.findLoadedClass(name);
        }
    }
}

