/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationConfig;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.server.AppServerStartup;
import com.sun.enterprise.v3.server.ContainerStarter;
import com.sun.enterprise.v3.server.SnifferManagerImpl;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.config.ApplicationName;
import org.glassfish.api.container.Container;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.ApplicationMetaDataProvider;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.CompositeHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.deployment.common.ApplicationConfigInfo;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.data.ContainerRegistry;
import org.glassfish.internal.data.EngineInfo;
import org.glassfish.internal.data.EngineRef;
import org.glassfish.internal.data.ModuleInfo;
import org.glassfish.internal.data.ProgressTracker;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class ApplicationLifecycle
implements Deployment {
    @Inject
    protected SnifferManagerImpl snifferManager;
    @Inject
    Habitat habitat;
    @Inject
    ContainerRegistry containerRegistry;
    @Inject
    public ApplicationRegistry appRegistry;
    @Inject
    ModulesRegistry modulesRegistry;
    @Inject
    protected Applications applications;
    @Inject
    protected Domain domain;
    @Inject(name="default-instance-name")
    protected Server server;
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    Events events;
    protected Logger logger = LogDomains.getLogger(AppServerStartup.class, (String)"javax.enterprise.system.core");
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ApplicationLifecycle.class);

    protected <T extends Container, U extends ApplicationContainer> Deployer<T, U> getDeployer(EngineInfo<T, U> engineInfo) {
        return engineInfo.getDeployer();
    }

    public ArchiveHandler getArchiveHandler(ReadableArchive archive) throws IOException {
        for (CompositeHandler handler : this.habitat.getAllByContract(CompositeHandler.class)) {
            if (!handler.handles(archive)) continue;
            return handler;
        }
        LinkedList<ArchiveHandler> handlerList = new LinkedList<ArchiveHandler>();
        for (ArchiveHandler handler : this.habitat.getAllByContract(ArchiveHandler.class)) {
            if (handler instanceof CompositeHandler || "DEFAULT".equals(handler.getClass().getAnnotation(Service.class).name())) continue;
            if ("connector".equals(handler.getClass().getAnnotation(Service.class).name())) {
                handlerList.addLast(handler);
                continue;
            }
            handlerList.addFirst(handler);
        }
        for (ArchiveHandler handler : handlerList) {
            if (!handler.handles(archive)) continue;
            return handler;
        }
        return (ArchiveHandler)this.habitat.getComponent(ArchiveHandler.class, "DEFAULT");
    }

    public ApplicationInfo deploy(ExtendedDeploymentContext context) {
        return this.deploy(null, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApplicationInfo deploy(Collection<Sniffer> sniffers, final ExtendedDeploymentContext context) {
        this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.DEPLOYMENT_START, context));
        report = context.getActionReport();
        commandParams = (DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class);
        appName = commandParams.name();
        if (commandParams.origin == OpsParams.Origin.deploy && this.appRegistry.get(appName) != null) {
            report.setMessage(ApplicationLifecycle.localStrings.getLocalString("appnamenotunique", "Application name {0} is already in use. Please pick a different name.", new Object[]{appName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return null;
        }
        if (commandParams.virtualservers == null) {
            commandParams.virtualservers = this.getVirtualServers(commandParams.target);
        }
        tracker = new ProgressTracker(){

            public void actOn(Logger logger) {
                ApplicationLifecycle.this.appRegistry.remove(appName);
                for (EngineRef module : this.get("started", EngineRef.class)) {
                    module.stop((ApplicationContext)context);
                }
                try {
                    ((PreDestroy)PreDestroy.class.cast(context)).preDestroy();
                }
                catch (Exception e) {
                    // empty catch block
                }
                for (EngineRef module : this.get("loaded", EngineRef.class)) {
                    module.unload(context);
                }
                for (EngineRef module : this.get("prepared", EngineRef.class)) {
                    module.clean(context);
                }
                if (!commandParams.keepfailedstubs.booleanValue()) {
                    context.clean();
                }
            }
        };
        context.addTransientAppMetaData("tracker", (Object)tracker);
        context.setPhase(ExtendedDeploymentContext.Phase.PREPARE);
        appInfo = null;
        handler = context.getArchiveHandler();
        if (handler == null) {
            handler = this.getArchiveHandler(context.getSource());
            context.setArchiveHandler(handler);
        }
        if (handler == null) {
            report.setMessage(ApplicationLifecycle.localStrings.getLocalString("unknownarchivetype", "Archive type of {0} was not recognized", new Object[]{context.getSource()}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            var9_10 = null;
            if (report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
                this.events.send(new EventListener.Event<Object>(Deployment.DEPLOYMENT_SUCCESS, appInfo));
                return var9_10;
            }
            this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.DEPLOYMENT_FAILURE, context));
            return var9_10;
        }
        {
            catch (Exception e) {
                report.failure(this.logger, "Exception while deploying the app", e);
                tracker.actOn(this.logger);
                return null;
            }
            catch (Throwable var18_23) {
                throw var18_23;
            }
            clh = (ClassLoaderHierarchy)this.habitat.getByContract(ClassLoaderHierarchy.class);
            context.createDeploymentClassLoader(clh, handler);
            cloader = context.getClassLoader();
            currentCL = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(cloader);
                if (sniffers != null && this.logger.isLoggable(Level.FINE)) {
                    for (Sniffer sniffer : sniffers) {
                        this.logger.fine("Before Sorting" + sniffer.getModuleType());
                    }
                }
                sortedEngineInfos = this.setupContainerInfos(handler, sniffers, (DeploymentContext)context);
                if (this.logger.isLoggable(Level.FINE)) {
                    for (EngineInfo info : sortedEngineInfos) {
                        this.logger.fine("After Sorting " + info.getSniffer().getModuleType());
                    }
                }
                if (sortedEngineInfos == null || sortedEngineInfos.isEmpty()) {
                    report.failure(this.logger, ApplicationLifecycle.localStrings.getLocalString("unknowncontainertype", "There is no installed container capable of handling this application {0}", new Object[]{context.getSource()}));
                    tracker.actOn(this.logger);
                    i$ = null;
                    Thread.currentThread().setContextClassLoader(currentCL);
                    if (report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
                        this.events.send(new EventListener.Event<Object>(Deployment.DEPLOYMENT_SUCCESS, appInfo));
                        return i$;
                    }
                    this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.DEPLOYMENT_FAILURE, context));
                    return i$;
                }
            }
            catch (Throwable var17_22) {}
            {
                Thread.currentThread().setContextClassLoader(currentCL);
                throw var17_22;
            }
        }
        {
            tempAppInfo = new ApplicationInfo(this.events, context.getSource(), appName);
            for (E m : context.getModuleMetadata()) {
                tempAppInfo.addMetaData(m);
            }
            tempAppInfo.setIsJavaEEApp(sortedEngineInfos);
            this.appRegistry.add(appName, tempAppInfo);
            context.createApplicationClassLoader(clh, handler);
            moduleInfo = null;
            try {
                moduleInfo = this.prepareModule(sortedEngineInfos, appName, (DeploymentContext)context, tracker);
            }
            catch (Exception prepareException) {
                report.failure(this.logger, "Exception while preparing the app", prepareException);
                tracker.actOn(this.logger);
                var16_20 = null;
                Thread.currentThread().setContextClassLoader(currentCL);
                if (report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
                    this.events.send(new EventListener.Event<ApplicationInfo>(Deployment.DEPLOYMENT_SUCCESS, appInfo));
                    return var16_20;
                }
                this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.DEPLOYMENT_FAILURE, context));
                return var16_20;
            }
        }
        {
            appInfo = (ApplicationInfo)context.getModuleMetaData(ApplicationInfo.class);
            if (appInfo == null) {
                appInfo = new ApplicationInfo(this.events, context.getSource(), appName);
                appInfo.addModule(moduleInfo);
                for (E m : context.getModuleMetadata()) {
                    moduleInfo.addMetaData(m);
                    appInfo.addMetaData(m);
                }
            } else {
                for (EngineRef ref : moduleInfo.getEngineRefs()) {
                    appInfo.add(ref);
                }
            }
            this.appRegistry.remove(appName);
            appInfo.setIsJavaEEApp(sortedEngineInfos);
            this.appRegistry.add(appName, appInfo);
            this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.APPLICATION_PREPARED, context), false);
            if (!commandParams.enabled.booleanValue()) ** GOTO lbl-1000
            Thread.currentThread().setContextClassLoader(context.getFinalClassLoader());
            appInfo.setLibraries(commandParams.libraries());
            try {
                appInfo.load(context, tracker);
                appInfo.start(context, tracker);
            }
            catch (Exception loadException) {
                report.failure(this.logger, "Exception while loading the app", loadException);
                tracker.actOn(this.logger);
                var16_21 = null;
                Thread.currentThread().setContextClassLoader(currentCL);
                if (report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
                    this.events.send(new EventListener.Event<ApplicationInfo>(Deployment.DEPLOYMENT_SUCCESS, appInfo));
                    return var16_21;
                }
                this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.DEPLOYMENT_FAILURE, context));
                return var16_21;
            }
        }
lbl-1000:
        // 2 sources

        {
            var15_17 = appInfo;
            Thread.currentThread().setContextClassLoader(currentCL);
            if (report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
                this.events.send(new EventListener.Event<ApplicationInfo>(Deployment.DEPLOYMENT_SUCCESS, appInfo));
                return var15_17;
            }
            this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.DEPLOYMENT_FAILURE, context));
            return var15_17;
        }
    }

    public boolean suspend(String appName) {
        boolean isSuccess = true;
        ApplicationInfo appInfo = this.appRegistry.get(appName);
        if (appInfo != null) {
            isSuccess = appInfo.suspend(this.logger);
        }
        return isSuccess;
    }

    public boolean resume(String appName) {
        boolean isSuccess = true;
        ApplicationInfo appInfo = this.appRegistry.get(appName);
        if (appInfo != null) {
            isSuccess = appInfo.resume(this.logger);
        }
        return isSuccess;
    }

    public List<EngineInfo> setupContainerInfos(DeploymentContext context) throws Exception {
        return this.setupContainerInfos(null, null, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EngineInfo> setupContainerInfos(ArchiveHandler handler, Collection<Sniffer> sniffers, DeploymentContext context) throws Exception {
        ActionReport report = context.getActionReport();
        if (sniffers == null) {
            ReadableArchive source = context.getSource();
            if (handler instanceof CompositeHandler) {
                context.getAppProps().setProperty("isComposite", "true");
                sniffers = this.snifferManager.getCompositeSniffers(context);
            } else {
                sniffers = this.snifferManager.getSniffers(source, context.getClassLoader());
            }
        }
        if (sniffers.size() == 0) {
            report.failure(this.logger, localStrings.getLocalString("deploy.unknownmoduletpe", "Module type not recognized"));
            return null;
        }
        this.snifferManager.validateSniffers(sniffers, context);
        LinkedHashMap<Deployer, EngineInfo> containerInfosByDeployers = new LinkedHashMap<Deployer, EngineInfo>();
        for (Sniffer sniffer : sniffers) {
            String msg;
            if (sniffer.getContainersNames() == null || sniffer.getContainersNames().length == 0) {
                report.failure(this.logger, "no container associated with application of type : " + sniffer.getModuleType(), null);
                return null;
            }
            Module snifferModule = this.modulesRegistry.find(sniffer.getClass());
            if (snifferModule == null) {
                report.failure(this.logger, "cannot find container module from service implementation " + sniffer.getClass(), null);
                return null;
            }
            String containerName = sniffer.getContainersNames()[0];
            EngineInfo engineInfo = this.containerRegistry.getContainer(containerName);
            if (engineInfo == null) {
                Collection<EngineInfo> containersInfo = null;
                ContainerRegistry containerRegistry = this.containerRegistry;
                synchronized (containerRegistry) {
                    if (this.containerRegistry.getContainer(containerName) == null && ((containersInfo = this.setupContainer(sniffer, snifferModule, this.logger, context)) == null || containersInfo.size() == 0)) {
                        String msg2 = "Cannot start container(s) associated to application of type : " + sniffer.getModuleType();
                        report.failure(this.logger, msg2, null);
                        throw new Exception(msg2);
                    }
                }
                if (!this.startContainers(containersInfo, this.logger, context)) {
                    msg = "Aborting, Failed to start container " + containerName;
                    report.failure(this.logger, msg, null);
                    throw new Exception(msg);
                }
            }
            if ((engineInfo = this.containerRegistry.getContainer(sniffer.getContainersNames()[0])) == null) {
                String msg3 = "Aborting, Failed to start container " + containerName;
                report.failure(this.logger, msg3, null);
                throw new Exception(msg3);
            }
            Deployer deployer = this.getDeployer(engineInfo);
            if (deployer == null) {
                if (!this.startContainers(Collections.singleton(engineInfo), this.logger, context)) {
                    msg = "Aborting, Failed to start container " + containerName;
                    report.failure(this.logger, msg, null);
                    throw new Exception(msg);
                }
                deployer = this.getDeployer(engineInfo);
                if (deployer == null) {
                    report.failure(this.logger, "Got a null deployer out of the " + engineInfo.getContainer().getClass() + " container, is it annotated with @Service ?");
                    return null;
                }
            }
            containerInfosByDeployers.put(deployer, engineInfo);
        }
        LinkedList providers = new LinkedList();
        providers.addAll(this.habitat.getAllByContract(ApplicationMetaDataProvider.class));
        ArrayList<EngineInfo> sortedEngineInfos = new ArrayList<EngineInfo>();
        HashMap<Class, ApplicationMetaDataProvider> typeByProvider = new HashMap<Class, ApplicationMetaDataProvider>();
        for (ApplicationMetaDataProvider provider : this.habitat.getAllByContract(ApplicationMetaDataProvider.class)) {
            if (provider.getMetaData() == null) continue;
            for (Class provided : provider.getMetaData().provides()) {
                typeByProvider.put(provided, provider);
            }
        }
        for (ApplicationMetaDataProvider provider : this.habitat.getAllByContract(ApplicationMetaDataProvider.class)) {
            if (provider.getMetaData() == null) continue;
            for (Class dependency : provider.getMetaData().requires()) {
                if (typeByProvider.containsKey(dependency)) continue;
                this.logger.warning("ApplicationMetaDataProvider " + provider + " requires " + dependency + " but no other ApplicationMetaDataProvider provides it");
            }
        }
        HashMap<Class, Deployer> typeByDeployer = new HashMap<Class, Deployer>();
        for (Deployer deployer : containerInfosByDeployers.keySet()) {
            if (deployer.getMetaData() == null) continue;
            for (Class provided : deployer.getMetaData().provides()) {
                typeByDeployer.put(provided, deployer);
            }
        }
        for (Deployer deployer : containerInfosByDeployers.keySet()) {
            if (deployer.getMetaData() == null) continue;
            for (Class dependency : deployer.getMetaData().requires()) {
                if (typeByDeployer.containsKey(dependency) || typeByProvider.containsKey(dependency)) continue;
                Service s = deployer.getClass().getAnnotation(Service.class);
                String serviceName = s != null && s.name() != null && s.name().length() > 0 ? s.name() : deployer.getClass().getSimpleName();
                report.failure(this.logger, serviceName + " deployer requires " + dependency + " but no other deployer provides it", null);
                return null;
            }
        }
        ArrayList<Deployer> orderedDeployers = new ArrayList<Deployer>();
        for (Deployer deployer : containerInfosByDeployers.keySet()) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Keyed Deployer " + deployer.getClass());
            }
            this.loadDeployer(orderedDeployers, deployer, typeByDeployer, typeByProvider, context);
        }
        for (Deployer deployer : orderedDeployers) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Ordered Deployer " + deployer.getClass());
            }
            MetaData metadata = deployer.getMetaData();
            try {
                if (metadata != null) {
                    if (metadata.provides() == null || metadata.provides().length == 0) {
                        deployer.loadMetaData(null, context);
                    } else {
                        for (Class provide : metadata.provides()) {
                            if (context.getModuleMetaData(provide) != null) continue;
                            context.addModuleMetaData(deployer.loadMetaData(provide, context));
                        }
                    }
                } else {
                    deployer.loadMetaData(null, context);
                }
            }
            catch (Exception e) {
                report.failure(this.logger, "Exception while invoking " + deployer.getClass() + " prepare method", e);
                throw e;
            }
            sortedEngineInfos.add((EngineInfo)containerInfosByDeployers.get(deployer));
        }
        return sortedEngineInfos;
    }

    private void loadDeployer(List<Deployer> results, Deployer deployer, Map<Class, Deployer> typeByDeployer, Map<Class, ApplicationMetaDataProvider> typeByProvider, DeploymentContext dc) throws IOException {
        if (results.contains(deployer)) {
            return;
        }
        results.add(deployer);
        if (deployer.getMetaData() != null) {
            for (Class required : deployer.getMetaData().requires()) {
                if (dc.getModuleMetaData(required) != null) continue;
                if (typeByDeployer.containsKey(required)) {
                    this.loadDeployer(results, typeByDeployer.get(required), typeByDeployer, typeByProvider, dc);
                    continue;
                }
                ApplicationMetaDataProvider provider = typeByProvider.get(required);
                if (provider == null) {
                    this.logger.severe("I don't get it, file a bug, no-one is providing " + required + " yet it passed validation");
                    continue;
                }
                LinkedList<ApplicationMetaDataProvider> providers = new LinkedList<ApplicationMetaDataProvider>();
                this.addRecursively(providers, typeByProvider, provider);
                for (ApplicationMetaDataProvider p : providers) {
                    dc.addModuleMetaData(p.load(dc));
                }
            }
        }
    }

    private void addRecursively(LinkedList<ApplicationMetaDataProvider> results, Map<Class, ApplicationMetaDataProvider> providers, ApplicationMetaDataProvider provider) {
        results.addFirst(provider);
        for (Class type : provider.getMetaData().requires()) {
            if (!providers.containsKey(type)) continue;
            this.addRecursively(results, providers, providers.get(type));
        }
    }

    public ModuleInfo prepareModule(List<EngineInfo> sortedEngineInfos, String moduleName, DeploymentContext context, ProgressTracker tracker) throws Exception {
        String isComposite;
        ActionReport report = context.getActionReport();
        ArrayList<EngineRef> addedEngines = new ArrayList<EngineRef>();
        for (EngineInfo engineInfo : sortedEngineInfos) {
            Deployer deployer = engineInfo.getDeployer();
            try {
                deployer.prepare(context);
                EngineRef engineRef = new EngineRef(engineInfo, null);
                addedEngines.add(engineRef);
                tracker.add("prepared", EngineRef.class, (Object)engineRef);
                tracker.add(Deployer.class, (Object)deployer);
            }
            catch (Exception e) {
                report.failure(this.logger, "Exception while invoking " + deployer.getClass() + " prepare method", e);
                throw e;
            }
        }
        if (this.events != null) {
            this.events.send(new EventListener.Event<DeploymentContext>(Deployment.MODULE_PREPARED, context), false);
        }
        if ((isComposite = context.getAppProps().getProperty("isComposite")) != null) {
            context.getModuleProps().setProperty("isComposite", isComposite);
        }
        ModuleInfo mi = new ModuleInfo(this.events, moduleName, addedEngines, context.getModuleProps());
        ApplicationConfigInfo savedAppConfig = new ApplicationConfigInfo(context.getAppProps());
        for (EngineRef er : mi.getEngineRefs()) {
            ApplicationConfig c = savedAppConfig.get(mi.getName(), er.getContainerInfo().getSniffer().getModuleType());
            if (c == null) continue;
            er.setApplicationConfig(c);
        }
        return mi;
    }

    protected Collection<EngineInfo> setupContainer(Sniffer sniffer, Module snifferModule, Logger logger, DeploymentContext context) {
        ActionReport report = context.getActionReport();
        ContainerStarter starter = (ContainerStarter)this.habitat.getComponent(ContainerStarter.class);
        Collection<EngineInfo> containersInfo = starter.startContainer(sniffer, snifferModule);
        if (containersInfo == null || containersInfo.size() == 0) {
            report.failure(logger, "Cannot start container(s) associated to application of type : " + sniffer.getModuleType(), null);
            return null;
        }
        return containersInfo;
    }

    protected boolean startContainers(Collection<EngineInfo> containersInfo, Logger logger, DeploymentContext context) {
        ActionReport report = context.getActionReport();
        for (EngineInfo engineInfo : containersInfo) {
            Container container;
            try {
                container = engineInfo.getContainer();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Cannot start container  " + engineInfo.getSniffer().getModuleType(), e);
                return false;
            }
            Class<? extends Deployer> deployerClass = container.getDeployer();
            try {
                Deployer deployer = (Deployer)this.habitat.getComponent(deployerClass);
                engineInfo.setDeployer(deployer);
            }
            catch (ComponentException e) {
                report.failure(logger, "Cannot instantiate or inject " + deployerClass, e);
                engineInfo.stop(logger);
                return false;
            }
            catch (ClassCastException e) {
                engineInfo.stop(logger);
                report.failure(logger, deployerClass + " does not implement " + " the org.jvnet.glassfish.api.deployment.Deployer interface", e);
                return false;
            }
        }
        return true;
    }

    protected void stopContainers(EngineInfo[] ctrInfos, Logger logger) {
        for (EngineInfo ctrInfo : ctrInfos) {
            try {
                ctrInfo.stop(logger);
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Cannot release container " + ctrInfo.getSniffer().getModuleType(), e);
            }
        }
    }

    protected ApplicationInfo unload(String appName, ExtendedDeploymentContext context) {
        ActionReport report = context.getActionReport();
        ApplicationInfo info = this.appRegistry.get(appName);
        if (info == null) {
            report.failure(context.getLogger(), "Application " + appName + " not registered", null);
            return null;
        }
        info.stop(context, context.getLogger());
        info.unload(context);
        return info;
    }

    public void undeploy(String appName, ExtendedDeploymentContext context) {
        ApplicationInfo info;
        ActionReport report = context.getActionReport();
        if (report.getExtraProperties() != null) {
            context.getAppProps().put("ActionReportProperties", report.getExtraProperties());
        }
        if ((info = this.appRegistry.get(appName)) == null) {
            report.failure(context.getLogger(), "Application " + appName + " not registered", null);
            this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.UNDEPLOYMENT_FAILURE, context));
            return;
        }
        this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.UNDEPLOYMENT_VALIDATION, context), false);
        if (report.getActionExitCode() == ActionReport.ExitCode.FAILURE) {
            return;
        }
        this.events.send(new EventListener.Event<ApplicationInfo>(Deployment.UNDEPLOYMENT_START, info));
        this.unload(appName, context);
        try {
            info.clean(context);
        }
        catch (Exception e) {
            report.failure(context.getLogger(), "Exception while cleaning application artifacts", e);
            this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.UNDEPLOYMENT_FAILURE, context));
            return;
        }
        if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
            this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.UNDEPLOYMENT_SUCCESS, context));
        } else {
            this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.UNDEPLOYMENT_FAILURE, context));
        }
        this.appRegistry.remove(appName);
        info = null;
    }

    public void registerAppInDomainXML(final ApplicationInfo applicationInfo, DeploymentContext context) throws TransactionFailure {
        final Properties appProps = context.getAppProps();
        final DeployCommandParameters deployParams = context.getCommandParameters(DeployCommandParameters.class);
        ConfigSupport.apply(new ConfigCode(){

            public Object run(ConfigBeanProxy ... params) throws PropertyVetoException, TransactionFailure {
                Applications apps = (Applications)params[0];
                Server servr = (Server)params[1];
                Application app = params[0].createChild(Application.class);
                app.setName(deployParams.name);
                if (deployParams.libraries != null) {
                    app.setLibraries(deployParams.libraries);
                }
                if (deployParams.description != null) {
                    app.setDescription(deployParams.description);
                }
                if (appProps.getProperty("context-root") != null) {
                    app.setContextRoot(appProps.getProperty("context-root"));
                }
                if (appProps.getProperty("location") != null) {
                    app.setLocation(appProps.getProperty("location"));
                    app.setEnabled(String.valueOf(true));
                } else {
                    app.setEnabled(deployParams.enabled.toString());
                }
                if (appProps.getProperty("object-type") != null) {
                    app.setObjectType(appProps.getProperty("object-type"));
                }
                if (appProps.getProperty("directory-deployed") != null) {
                    app.setDirectoryDeployed(appProps.getProperty("directory-deployed"));
                }
                apps.getModules().add(app);
                if (applicationInfo != null) {
                    applicationInfo.save(app);
                }
                for (String string : appProps.keySet()) {
                    if (string.equals("location") || string.equals("context-root") || string.equals("object-type") || string.equals("directory-deployed") || string.startsWith("appConfig")) continue;
                    Property prop = (Property)app.createChild(Property.class);
                    app.getProperty().add(prop);
                    prop.setName(string);
                    prop.setValue(appProps.getProperty(string));
                }
                ApplicationRef appRef = params[1].createChild(ApplicationRef.class);
                appRef.setRef(deployParams.name);
                if (deployParams.virtualservers != null) {
                    appRef.setVirtualServers(deployParams.virtualservers);
                } else {
                    HttpService httpService = (HttpService)ApplicationLifecycle.this.habitat.getComponent(HttpService.class);
                    StringBuilder sb = new StringBuilder();
                    for (VirtualServer s : httpService.getVirtualServer()) {
                        if (s.getId().equals("__asadmin")) continue;
                        if (sb.length() > 0) {
                            sb.append(',');
                        }
                        sb.append(s.getId());
                    }
                    appRef.setVirtualServers(sb.toString());
                }
                appRef.setEnabled(deployParams.enabled.toString());
                servr.getApplicationRef().add(appRef);
                return Boolean.TRUE;
            }
        }, new ConfigBeanProxy[]{this.applications, this.server});
    }

    public void unregisterAppFromDomainXML(final String appName) throws TransactionFailure {
        ConfigSupport.apply(new ConfigCode(){

            public Object run(ConfigBeanProxy ... params) throws PropertyVetoException, TransactionFailure {
                Applications apps = (Applications)params[0];
                Server servr = (Server)params[1];
                for (ApplicationRef appRef : servr.getApplicationRef()) {
                    if (!appRef.getRef().equals(appName)) continue;
                    ((Server)params[1]).getApplicationRef().remove(appRef);
                    break;
                }
                for (ApplicationName module : apps.getModules()) {
                    if (!module.getName().equals(appName)) continue;
                    ((Applications)params[0]).getModules().remove(module);
                    break;
                }
                return Boolean.TRUE;
            }
        }, new ConfigBeanProxy[]{this.applications, this.server});
    }

    public boolean isRegistered(String appName) {
        return ConfigBeansUtilities.getModule((String)appName) != null;
    }

    public ApplicationInfo get(String appName) {
        return this.appRegistry.get(appName);
    }

    public Deployment.DeploymentContextBuilder getBuilder(Logger logger, OpsParams params, ActionReport report) {
        return new DeploymentContextBuidlerImpl(logger, params, report);
    }

    private ReadableArchive getArchive(Deployment.DeploymentContextBuilder builder) throws IOException {
        ReadableArchive archive = builder.sourceAsArchive();
        if (archive == null && builder.sourceAsFile() == null) {
            throw new IOException("Source archive or file not provided to builder");
        }
        if (archive == null && builder.sourceAsFile() != null && (archive = ((ArchiveFactory)this.habitat.getComponent(ArchiveFactory.class)).openArchive(builder.sourceAsFile())) == null) {
            throw new IOException("Invalid archive type : " + builder.sourceAsFile().getAbsolutePath());
        }
        return archive;
    }

    private ExtendedDeploymentContext getContext(ExtendedDeploymentContext initial, Deployment.DeploymentContextBuilder builder) throws IOException {
        ArchiveHandler archiveHandler;
        DeploymentContextBuidlerImpl copy = new DeploymentContextBuidlerImpl(builder);
        ReadableArchive archive = this.getArchive(copy);
        copy.source(archive);
        if (initial == null) {
            initial = new DeploymentContextImpl((Deployment.DeploymentContextBuilder)copy, (ServerEnvironment)this.env);
        }
        if ((archiveHandler = copy.archiveHandler()) == null) {
            archiveHandler = this.getArchiveHandler(archive);
        }
        File sourceFile = new File(archive.getURI().getSchemeSpecificPart());
        initial.getAppProps().put("defaultAppName", DeploymentUtils.getDefaultEEName((String)sourceFile.getName()));
        if (!sourceFile.isDirectory()) {
            File expansionDir = new File(this.domain.getApplicationRoot(), copy.params().name());
            if (!expansionDir.mkdirs()) {
                this.logger.fine(localStrings.getLocalString("deploy.cannotcreateexpansiondir", "Error while creating directory for jar expansion: {0}", new Object[]{expansionDir}));
            }
            try {
                Long start = System.currentTimeMillis();
                ArchiveFactory archiveFactory = (ArchiveFactory)this.habitat.getComponent(ArchiveFactory.class);
                archiveHandler.expand(archive, archiveFactory.createArchive(expansionDir), (DeploymentContext)initial);
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Deployment expansion took " + (System.currentTimeMillis() - start));
                }
                try {
                    archive.close();
                }
                catch (IOException e) {
                    this.logger.log(Level.SEVERE, localStrings.getLocalString("deploy.errorclosingarchive", "Error while closing deployable artifact {0}", new Object[]{archive.getURI().getSchemeSpecificPart()}), e);
                    throw e;
                }
                archive = archiveFactory.openArchive(expansionDir);
                initial.setSource(archive);
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, localStrings.getLocalString("deploy.errorexpandingjar", "Error while expanding archive file"), e);
                throw e;
            }
        }
        initial.setArchiveHandler(archiveHandler);
        return initial;
    }

    private String getVirtualServers(String target) {
        List hosts;
        HttpService httpService;
        Config config;
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        Server server = this.domain.getServerNamed(target);
        if (server != null && (config = this.domain.getConfigs().getConfigByName(server.getConfigRef())) != null && (httpService = config.getHttpService()) != null && (hosts = httpService.getVirtualServer()) != null) {
            for (VirtualServer host : hosts) {
                if ("__asadmin".equals(host.getId())) continue;
                if (first) {
                    sb.append(host.getId());
                    first = false;
                    continue;
                }
                sb.append(",");
                sb.append(host.getId());
            }
        }
        return sb.toString();
    }

    public class DeploymentContextBuidlerImpl
    implements Deployment.DeploymentContextBuilder {
        private final Logger logger;
        private final ActionReport report;
        private final OpsParams params;
        private File sFile;
        private ReadableArchive sArchive;
        private ArchiveHandler handler;

        public DeploymentContextBuidlerImpl(Logger logger, OpsParams params, ActionReport report) {
            this.logger = logger;
            this.report = report;
            this.params = params;
        }

        public DeploymentContextBuidlerImpl(Deployment.DeploymentContextBuilder b) throws IOException {
            this.logger = b.logger();
            this.report = b.report();
            this.params = b.params();
            ReadableArchive archive = ApplicationLifecycle.this.getArchive(b);
            this.source(archive);
            this.handler = b.archiveHandler();
        }

        public Deployment.DeploymentContextBuilder source(File source) {
            this.sFile = source;
            return this;
        }

        public File sourceAsFile() {
            return this.sFile;
        }

        public ReadableArchive sourceAsArchive() {
            return this.sArchive;
        }

        public ArchiveHandler archiveHandler() {
            return this.handler;
        }

        public Deployment.DeploymentContextBuilder source(ReadableArchive archive) {
            this.sArchive = archive;
            return this;
        }

        public Deployment.DeploymentContextBuilder archiveHandler(ArchiveHandler handler) {
            this.handler = handler;
            return this;
        }

        public ExtendedDeploymentContext build() throws IOException {
            return this.build(null);
        }

        public Logger logger() {
            return this.logger;
        }

        public ActionReport report() {
            return this.report;
        }

        public OpsParams params() {
            return this.params;
        }

        public ExtendedDeploymentContext build(ExtendedDeploymentContext initialContext) throws IOException {
            return ApplicationLifecycle.this.getContext(initialContext, this);
        }
    }
}

