/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component;

import com.sun.hk2.component.ExistingSingletonInhabitant;
import com.sun.hk2.component.ScopedInhabitant;
import com.sun.hk2.component.SingletonInhabitant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.Scope;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.component.Womb;
import org.jvnet.hk2.component.Wombs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Inhabitants {
    public static <T> Inhabitant<T> create(T instance) {
        return new ExistingSingletonInhabitant<T>(instance);
    }

    public static <T> Inhabitant<T> create(Class<T> c, Habitat habitat, MultiMap<String, String> metadata) {
        return Inhabitants.wrapByScope(c, Wombs.create(c, habitat, metadata), habitat);
    }

    public static <T> Inhabitant<T> wrapByScope(Class<T> c, Womb<T> womb, Habitat habitat) {
        Scoped scoped = c.getAnnotation(Scoped.class);
        if (scoped == null) {
            return new SingletonInhabitant<T>(womb);
        }
        Class<? extends Scope> scopeClass = scoped.value();
        if (scopeClass == PerLookup.class) {
            return womb;
        }
        if (scopeClass == Singleton.class) {
            return new SingletonInhabitant<T>(womb);
        }
        Scope scope = habitat.getByType(scopeClass);
        if (scope == null) {
            throw new ComponentException("Failed to look up %s for %s", scopeClass, c);
        }
        return new ScopedInhabitant<T>(womb, scope);
    }

    public static <T> Collection<String> getIndexes(Inhabitant<T> i) {
        ArrayList<String> indexes = new ArrayList<String>();
        Iterator<Map.Entry<String, List<String>>> itr = i.metadata().entrySet().iterator();
        while (itr.hasNext()) {
            indexes.add(itr.next().getKey());
        }
        return indexes;
    }

    public static <T> Collection<String> getNamesFor(Inhabitant<T> i, String indexName) {
        return new ArrayList<String>(i.metadata().get(indexName));
    }
}

