/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.orbutil.misc;

import java.util.ArrayList;
import java.util.List;

public class OperationTracer {
    private static boolean enabled = false;
    private static ThreadLocal<List<Element>> state = new ThreadLocal(){

        public List<Element> initialValue() {
            return new ArrayList<Element>();
        }
    };

    public static void enable() {
        enabled = true;
    }

    public static void disable() {
        enabled = false;
    }

    private OperationTracer() {
    }

    public static String getAsString() {
        StringBuilder sb = new StringBuilder();
        List<Element> elements = state.get();
        int count = 0;
        for (Element elem : elements) {
            if (count == 0) {
                sb.append(elem.getAsString());
                sb.append(':');
            } else if (count == 1) {
                sb.append(elem.getAsString());
            } else {
                sb.append(',');
                sb.append(elem.getAsString());
            }
            ++count;
        }
        return sb.toString();
    }

    public static void begin(final String label) {
        if (enabled) {
            List<Element> elements = state.get();
            elements.clear();
            elements.add(new Element(){

                @Override
                public String getAsString() {
                    return label;
                }
            });
        }
    }

    public static void finish() {
        if (enabled) {
            state.get().clear();
        }
    }

    public static void startReadValue(String name) {
        if (enabled) {
            state.get().add(new ValueElement(name));
        }
    }

    public static void readingField(String fieldName) {
        Element elem;
        List<Element> elements;
        int lastIndex;
        if (enabled && (lastIndex = (elements = state.get()).size() - 1) >= 0 && (elem = elements.get(lastIndex)) instanceof ValueElement) {
            ValueElement ve = (ValueElement)elem;
            ve.setFieldName(fieldName);
        }
    }

    public static void endReadValue() {
        if (enabled) {
            OperationTracer.end();
        }
    }

    public static void startReadArray(String name, int size) {
        if (enabled) {
            state.get().add(new ArrayElement(name, size));
        }
    }

    public static void readingIndex(int index) {
        Element elem;
        List<Element> elements;
        int lastIndex;
        if (enabled && (lastIndex = (elements = state.get()).size() - 1) >= 0 && (elem = elements.get(lastIndex)) instanceof ArrayElement) {
            ArrayElement ae = (ArrayElement)elem;
            ae.setIndex(index);
        }
    }

    public static void endReadArray() {
        if (enabled) {
            OperationTracer.end();
        }
    }

    private static void end() {
        List<Element> elements = state.get();
        int lastIndex = elements.size() - 1;
        if (lastIndex >= 0) {
            elements.remove(lastIndex);
        }
    }

    private static class ValueElement
    implements Element {
        private String valueName;
        private String fieldName;

        public ValueElement(String valueName) {
            this.valueName = valueName;
            this.fieldName = null;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public String getAsString() {
            if (this.fieldName == null) {
                return this.valueName;
            }
            return this.valueName + '.' + this.fieldName;
        }
    }

    private static class ArrayElement
    implements Element {
        private String componentName;
        private int size;
        private int index;

        public ArrayElement(String componentName, int size) {
            this.componentName = componentName;
            this.size = size;
            this.index = -1;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        @Override
        public String getAsString() {
            if (this.index < 0) {
                return this.componentName + '<' + this.size + '>';
            }
            return this.componentName + '<' + this.size + ">[" + this.index + ']';
        }
    }

    static interface Element {
        public String getAsString();
    }
}

