/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.base.io;

import com.sun.ejb.base.io.IOUtils;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.spi.io.SerializableObjectFactory;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.rmi.Remote;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.enterprise.iiop.api.GlassFishORBHelper;
import org.glassfish.enterprise.iiop.api.ProtocolManager;

abstract class AbstractSerializableS1ASEJBReference
implements SerializableObjectFactory {
    protected long containerId;
    protected String debugStr;
    protected static Logger _ejbLogger = LogDomains.getLogger(AbstractSerializableS1ASEJBReference.class, (String)"javax.enterprise.system.container.ejb");

    AbstractSerializableS1ASEJBReference(long containerId) {
        this.containerId = containerId;
        BaseContainer container = EjbContainerUtilImpl.getInstance().getContainer(containerId);
        if (container == null) {
            _ejbLogger.log(Level.WARNING, "ejb.base.io.EJBOutputStream.null_container: " + containerId);
            this.debugStr = "" + containerId;
        } else {
            this.debugStr = container.toString();
        }
    }

    protected static Remote doRemoteRefClassLoaderConversion(Remote reference) throws IOException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        Remote returnReference = reference;
        if (reference.getClass().getClassLoader() != contextClassLoader) {
            try {
                byte[] serializedRef = IOUtils.serializeObject(reference, false);
                returnReference = (Remote)IOUtils.deserializeObject(serializedRef, false, contextClassLoader);
                GlassFishORBHelper orbHelper = EjbContainerUtilImpl.getInstance().getORBHelper();
                ProtocolManager protocolMgr = orbHelper.getProtocolManager();
                protocolMgr.connectObject(returnReference);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Exception e) {
                IOException ioEx = new IOException(e.getMessage());
                ioEx.initCause(e);
                throw ioEx;
            }
        }
        return returnReference;
    }
}

