/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scn.client.util;

import com.sun.scn.client.ui.Preferences;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.logging.Logger;

public class ProxyHelper {
    private static Logger log = Logger.getLogger(ProxyHelper.class.getName());

    public static Proxy getProxy(Preferences clientPrefs, String destUrl) {
        boolean useJWSProxySettings = clientPrefs.getJwsProxy();
        if (useJWSProxySettings && ProxyHelper.isRunningUnderJWS()) {
            ProxySelector ps = ProxySelector.getDefault();
            try {
                List<Proxy> proxies = ps.select(new URI(destUrl));
                if (proxies.size() > 0) {
                    return proxies.get(0);
                }
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        } else {
            String proxyHost = clientPrefs.getProxyHost();
            int proxyPort = clientPrefs.getProxyPortValue();
            if (proxyHost == null || proxyHost.equals("") || proxyPort == -1) {
                return Proxy.NO_PROXY;
            }
            InetSocketAddress addr = new InetSocketAddress(proxyHost, proxyPort);
            return new Proxy(Proxy.Type.HTTP, addr);
        }
        return Proxy.NO_PROXY;
    }

    public static boolean isRunningUnderJWS() {
        try {
            Class<?> serviceManagerClass = Class.forName("javax.jnlp.ServiceManager");
            Method lookupMethod = serviceManagerClass.getMethod("lookup", String.class);
            lookupMethod.invoke(null, "javax.jnlp.BasicService");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

