/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scn.servicetags.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLUtil {
    public static String getRequiredTextValue(Element e, String tagName) {
        NodeList nodeList = e.getElementsByTagName(tagName);
        assert (nodeList.getLength() == 1);
        Node node = nodeList.item(0);
        if (node == null) {
            throw new RuntimeException("missing required element: " + tagName);
        }
        String s = nodeList.item(0).getTextContent();
        if (s != null) {
            try {
                s = URLDecoder.decode(nodeList.item(0).getTextContent(), "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                s = nodeList.item(0).getTextContent();
            }
        }
        if (s == null) {
            return "";
        }
        return s;
    }

    public static List<String> getOptionalTextValues(Element e, String tagName) {
        NodeList nodeList = e.getElementsByTagName(tagName);
        assert (nodeList.getLength() < 2);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node == null) continue;
            String s = node.getTextContent();
            if (s != null) {
                try {
                    s = URLDecoder.decode(node.getTextContent(), "UTF-8");
                }
                catch (UnsupportedEncodingException uee) {
                    s = node.getTextContent();
                }
            }
            if (s == null || s.equalsIgnoreCase("null")) continue;
            list.add(s);
        }
        return list;
    }

    public static String getOptionalTextValue(Element e, String tagName) {
        NodeList nodeList = e.getElementsByTagName(tagName);
        assert (nodeList.getLength() < 2);
        Node node = nodeList.item(0);
        if (node == null) {
            return "";
        }
        String s = node.getTextContent();
        if (s != null) {
            try {
                s = URLDecoder.decode(node.getTextContent(), "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                s = node.getTextContent();
            }
        }
        if (s == null || s.equalsIgnoreCase("null")) {
            return "";
        }
        return s;
    }

    public static void writeDocument(Document doc, OutputStream out) throws IOException {
        TransformerFactory tfactory = TransformerFactory.newInstance();
        try {
            Transformer serializer = tfactory.newTransformer();
            serializer.setOutputProperty("indent", "yes");
            serializer.transform(new DOMSource(doc), new StreamResult(out));
        }
        catch (TransformerException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static void writeElement(Element e, OutputStream out) throws IOException {
        TransformerFactory tfactory = TransformerFactory.newInstance();
        try {
            Transformer serializer = tfactory.newTransformer();
            serializer.setOutputProperty("indent", "yes");
            serializer.transform(new DOMSource(e), new StreamResult(out));
        }
        catch (TransformerException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }
}

