/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.FieldDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.QueryDescriptor;
import com.sun.enterprise.deployment.util.BeanMethodCalculator;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.EjbVisitor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.internal.api.Globals;

public class EjbCMPEntityDescriptor
extends EjbEntityDescriptor {
    private static final String FIELD_ACCESS_METHOD_PREFIX = "get";
    public static final int UNDEFINED = -1;
    public static final int CMP_1_1 = 1;
    public static final int CMP_2_x = 2;
    private int cmpVersion = -1;
    private PersistenceDescriptor pers;
    private String abstractSchemaName = null;
    private FieldDescriptor primaryKeyFieldDesc;
    private String stateImplClassName = null;
    private String ejbImplementationImplClassName = null;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EjbCMPEntityDescriptor.class);
    static Logger _logger = DOLUtils.getDefaultLogger();

    public EjbCMPEntityDescriptor() {
        this.setPersistenceType("Container");
    }

    public EjbCMPEntityDescriptor(EjbDescriptor other) {
        super(other);
        this.setPersistenceType("Container");
        if (other instanceof EjbCMPEntityDescriptor) {
            EjbCMPEntityDescriptor entity = (EjbCMPEntityDescriptor)other;
            this.pers = entity.pers;
            this.cmpVersion = entity.cmpVersion;
            this.abstractSchemaName = entity.abstractSchemaName;
        }
    }

    public void setStateImplClassName(String name) {
        this.stateImplClassName = name;
    }

    public String getStateImplClassName() {
        return this.stateImplClassName;
    }

    public Vector getFields() {
        Vector fields = new Vector();
        if (!this.isEJB20()) {
            fields = super.getFields();
        }
        return fields;
    }

    public Vector getFieldDescriptors() {
        Vector fieldDescriptors;
        block5: {
            fieldDescriptors = new Vector();
            if (this.isEJB20()) {
                try {
                    ClassLoader cl = this.getEjbBundleDescriptor().getClassLoader();
                    BeanMethodCalculator bmc = Globals.getDefaultHabitat().getComponent(BeanMethodCalculator.class);
                    if (bmc != null) {
                        fieldDescriptors = bmc.getPossibleCmpCmrFields(cl, this.getEjbClassName());
                        break block5;
                    }
                    _logger.log(Level.FINE, "enterprise.deploymnet.ejbcontainernotinstalled");
                }
                catch (Throwable t) {
                    String errorMsg = localStrings.getLocalString("enterprise.deployment.errorloadingejbclass", "error loading the ejb class {0} in getFields on EjbDescriptor\n {1}", new Object[]{this.getEjbClassName(), t.toString()});
                    _logger.log(Level.FINE, errorMsg);
                }
            } else {
                fieldDescriptors = super.getFieldDescriptors();
            }
        }
        return fieldDescriptors;
    }

    public int getCMPVersion() {
        if (this.cmpVersion == -1) {
            String bundleVersion;
            this.cmpVersion = this.getEjbBundleDescriptor() != null ? ((bundleVersion = this.getEjbBundleDescriptor().getSpecVersion()).startsWith("1.") ? 1 : 2) : 2;
        }
        return this.cmpVersion;
    }

    public void setCMPVersion(int version) {
        if (version != 1 && version != 2) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.invalidcmpversion", "Invalid CMP version: {0}.", new Object[]{version}));
        }
        this.cmpVersion = version;
    }

    public boolean isEJB20() {
        return this.getCMPVersion() == 2;
    }

    public void setEjbBundleDescriptor(EjbBundleDescriptor bundleDescriptor) {
        super.setEjbBundleDescriptor(bundleDescriptor);
    }

    public Vector getPossibleTransactionAttributes() {
        Vector<ContainerTransaction> txAttributes = null;
        if (this.isEJB20()) {
            txAttributes = new Vector<ContainerTransaction>();
            txAttributes.add(new ContainerTransaction("Required", ""));
            txAttributes.add(new ContainerTransaction("RequiresNew", ""));
            txAttributes.add(new ContainerTransaction("Mandatory", ""));
            if (this.isTimedObject()) {
                txAttributes.add(new ContainerTransaction("NotSupported", ""));
            }
        } else {
            txAttributes = super.getPossibleTransactionAttributes();
        }
        return txAttributes;
    }

    public void setPersistenceDescriptor(PersistenceDescriptor pd) {
        this.pers = pd;
        pd.setParentDescriptor(this);
    }

    public PersistenceDescriptor getPersistenceDescriptor() {
        if (this.pers == null) {
            this.pers = new PersistenceDescriptor();
            this.setPersistenceDescriptor(this.pers);
        }
        return this.pers;
    }

    private void invalidatePersistenceInfo() {
        if (this.pers != null) {
            this.pers.invalidate();
        }
    }

    public void setPrimaryKeyFieldDesc(FieldDescriptor pkf) {
        this.primaryKeyFieldDesc = pkf;
        this.invalidatePersistenceInfo();
    }

    public FieldDescriptor getPrimaryKeyFieldDesc() {
        return this.primaryKeyFieldDesc;
    }

    public void setAbstractSchemaName(String abstractSchemaName) {
        this.abstractSchemaName = abstractSchemaName;
    }

    public String getAbstractSchemaName() {
        return this.abstractSchemaName;
    }

    public void setEjbImplementationImplClassName(String className) {
        this.ejbImplementationImplClassName = className;
    }

    public String getEjbImplementationImplClassName() {
        return this.ejbImplementationImplClassName;
    }

    public static Vector getPossibleCmpCmrFields(ClassLoader cl, String className) throws Exception {
        Vector<FieldDescriptor> fieldDescriptors = new Vector<FieldDescriptor>();
        Class<?> theClass = cl.loadClass(className);
        Method[] methods = theClass.getMethods();
        for (int mIndex = 0; mIndex < methods.length; ++mIndex) {
            Method next = methods[mIndex];
            String nextName = next.getName();
            int nextModifiers = next.getModifiers();
            if (!Modifier.isAbstract(nextModifiers) || !nextName.startsWith(FIELD_ACCESS_METHOD_PREFIX) || nextName.length() <= 3) continue;
            String field = nextName.substring(3, 4).toLowerCase() + nextName.substring(4);
            fieldDescriptors.add(new FieldDescriptor(field));
        }
        return fieldDescriptors;
    }

    public void print(StringBuffer toStringBuffer) {
        super.print(toStringBuffer);
        toStringBuffer.append("\n cmpVersion ").append(this.cmpVersion).append("\n primKeyField ");
        if (this.getPrimaryKeyFieldDesc() != null) {
            ((Descriptor)this.getPrimaryKeyFieldDesc()).print(toStringBuffer);
        }
        if (this.pers != null) {
            ((Descriptor)this.pers).print(toStringBuffer);
        }
    }

    public void visit(EjbVisitor aVisitor) {
        super.visit(aVisitor);
        PersistenceDescriptor persistenceDesc = this.getPersistenceDescriptor();
        for (FieldDescriptor fd : persistenceDesc.getCMPFields()) {
            aVisitor.accept(fd);
        }
        for (Object method : persistenceDesc.getQueriedMethods()) {
            if (!(method instanceof MethodDescriptor)) continue;
            QueryDescriptor qd = persistenceDesc.getQueryFor((MethodDescriptor)method);
            aVisitor.accept((MethodDescriptor)method, qd);
        }
    }
}

