/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.metadata.cache;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import javax.enterprise.util.Nonbinding;
import javax.interceptor.InterceptorBinding;
import org.jboss.weld.DefinitionException;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.ReflectionMessage;
import org.jboss.weld.metadata.cache.AnnotationModel;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.Reflections;
import org.jboss.weld.util.collections.Arrays2;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorBindingModel<T extends Annotation>
extends AnnotationModel<T> {
    private static final Set<Class<? extends Annotation>> META_ANNOTATIONS = Arrays2.asSet(InterceptorBinding.class);
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.REFLECTION);
    private Set<WeldMethod<?, ?>> nonBindingTypes;
    private Set<Annotation> inheritedInterceptionBindingTypes;
    private Set<Annotation> metaAnnotations;

    public InterceptorBindingModel(Class<T> type, ClassTransformer transformer) {
        super(type, transformer);
        if (this.isValid()) {
            this.initNonBindingTypes();
            this.initInterceptionBindingTypes();
            this.checkArrayAndAnnotationValuedMembers();
            this.checkMetaAnnotations();
            this.metaAnnotations = this.getAnnotatedAnnotation().getAnnotations();
        }
    }

    @Override
    protected Set<Class<? extends Annotation>> getMetaAnnotationTypes() {
        return META_ANNOTATIONS;
    }

    public Set<Annotation> getMetaAnnotations() {
        return this.metaAnnotations;
    }

    protected void initNonBindingTypes() {
        this.nonBindingTypes = this.getAnnotatedAnnotation().getAnnotatedMembers(Nonbinding.class);
    }

    protected void initInterceptionBindingTypes() {
        this.inheritedInterceptionBindingTypes = this.getAnnotatedAnnotation().getMetaAnnotations(InterceptorBinding.class);
    }

    @Override
    protected void initValid() {
        super.initValid();
        if (!this.getAnnotatedAnnotation().isAnnotationPresent(Target.class)) {
            this.valid = false;
            log.debug(ReflectionMessage.MISSING_TARGET, this.getAnnotatedAnnotation());
        } else {
            ElementType[] targetElementTypes = this.getAnnotatedAnnotation().getAnnotation(Target.class).value();
            if (!Arrays2.unorderedEquals((Object[])targetElementTypes, new Object[]{ElementType.TYPE, ElementType.METHOD}) && !Arrays2.unorderedEquals((Object[])targetElementTypes, new Object[]{ElementType.TYPE})) {
                this.valid = false;
                log.debug(ReflectionMessage.MISSING_TARGET_TYPE_METHOD_OR_TARGET_TYPE, this.getAnnotatedAnnotation());
            }
        }
    }

    private void checkMetaAnnotations() {
        if (Arrays2.containsAll((Object[])this.getAnnotatedAnnotation().getAnnotation(Target.class).value(), new Object[]{ElementType.METHOD})) {
            for (Annotation inheritedBinding : this.getInheritedInterceptionBindingTypes()) {
                if (Arrays2.containsAll((Object[])inheritedBinding.annotationType().getAnnotation(Target.class).value(), new Object[]{ElementType.METHOD})) continue;
                this.valid = false;
                log.debug(ReflectionMessage.TARGET_TYPE_METHOD_INHERITS_FROM_TARGET_TYPE, this.getAnnotatedAnnotation(), inheritedBinding);
            }
        }
    }

    private void checkArrayAndAnnotationValuedMembers() {
        for (WeldMethod<?, ?> annotatedMethod : this.getAnnotatedAnnotation().getMembers()) {
            if (!Reflections.isArrayType(annotatedMethod.getJavaClass()) && !Annotation.class.isAssignableFrom(annotatedMethod.getJavaClass()) || this.nonBindingTypes.contains(annotatedMethod)) continue;
            throw new DefinitionException("Member of array type or annotation type must be annotated @NonBinding " + annotatedMethod);
        }
    }

    public Set<Annotation> getInheritedInterceptionBindingTypes() {
        return this.inheritedInterceptionBindingTypes;
    }

    public boolean isEqual(Annotation instance, Annotation other) {
        return this.isEqual(instance, other, false);
    }

    public boolean isEqual(Annotation instance, Annotation other, boolean includeNonBindingTypes) {
        if (instance.annotationType().equals(this.getRawType()) && other.annotationType().equals(this.getRawType())) {
            for (WeldMethod<?, ?> annotatedMethod : this.getAnnotatedAnnotation().getMembers()) {
                if (!includeNonBindingTypes && this.nonBindingTypes.contains(annotatedMethod)) continue;
                try {
                    Object thatValue;
                    Object thisValue = annotatedMethod.invoke(instance, new Object[0]);
                    if (thisValue.equals(thatValue = annotatedMethod.invoke(other, new Object[0]))) continue;
                    return false;
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            return true;
        }
        return false;
    }
}

