/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.util.TypeLiteral;
import org.jboss.weld.BeanManagerImpl;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.introspector.AnnotationStore;
import org.jboss.weld.introspector.WeldAnnotated;
import org.jboss.weld.introspector.jlr.AbstractWeldAnnotated;
import org.jboss.weld.metadata.TypeStore;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.util.Names;
import org.jboss.weld.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolvableWeldClass<T>
extends AbstractWeldAnnotated<T, Class<T>>
implements Resolvable {
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private static final Set<Annotation> EMPTY_ANNOTATION_SET = Collections.emptySet();
    private final Class<T> rawType;
    private final Set<Type> typeClosure;
    private final Type[] actualTypeArguments;
    private final String _string;
    private final BeanManagerImpl manager;

    public static <T> WeldAnnotated<T, Class<T>> of(TypeLiteral<T> typeLiteral, Annotation[] annotations, BeanManagerImpl manager) {
        return new ResolvableWeldClass<T>(typeLiteral.getType(), annotations, manager);
    }

    public static <T> WeldAnnotated<T, Class<T>> of(Type type, Annotation[] annotations, BeanManagerImpl manager) {
        return new ResolvableWeldClass<T>(type, annotations, manager);
    }

    public static <T> WeldAnnotated<T, Class<T>> of(InjectionPoint injectionPoint, BeanManagerImpl manager) {
        if (injectionPoint instanceof WeldInjectionPoint) {
            WeldAnnotated ip = (WeldAnnotated)((Object)injectionPoint);
            return ip;
        }
        return new ResolvableWeldClass<T>(injectionPoint.getType(), injectionPoint.getAnnotated().getAnnotations(), manager);
    }

    public static <T> WeldAnnotated<T, Class<T>> of(Member member, Annotation[] annotations, BeanManagerImpl manager) {
        if (member instanceof Field) {
            return new ResolvableWeldClass<T>(((Field)member).getGenericType(), annotations, manager);
        }
        if (member instanceof Method) {
            return new ResolvableWeldClass<T>(((Method)member).getGenericReturnType(), annotations, manager);
        }
        throw new IllegalStateException();
    }

    private ResolvableWeldClass(Type type, AnnotationStore annotationStore, BeanManagerImpl manager) {
        super(annotationStore);
        this.manager = manager;
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (!(parameterizedType.getRawType() instanceof Class)) {
                throw new IllegalArgumentException("Cannot extract rawType from " + type);
            }
            this.rawType = (Class)parameterizedType.getRawType();
            this.actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
            this._string = this.rawType.toString() + "<" + Arrays.asList(this.actualTypeArguments).toString() + ">; binding types = " + Names.annotationsToString(annotationStore.getBindings());
        } else if (type instanceof Class) {
            this.rawType = (Class)type;
            this.actualTypeArguments = new Type[0];
            this._string = this.rawType.toString() + "; binding types = " + Names.annotationsToString(annotationStore.getBindings());
        } else {
            throw new IllegalArgumentException("Unable to extract type information from " + type);
        }
        this.typeClosure = new HashSet<Type>();
        this.typeClosure.add(type);
    }

    private ResolvableWeldClass(Type type, Annotation[] annotations, BeanManagerImpl manager) {
        this(type, AnnotationStore.of(annotations, EMPTY_ANNOTATION_ARRAY, manager.getServices().get(TypeStore.class)), manager);
    }

    private ResolvableWeldClass(Type type, Set<Annotation> annotations, BeanManagerImpl manager) {
        this(type, AnnotationStore.of(annotations, EMPTY_ANNOTATION_SET, manager.getServices().get(TypeStore.class)), manager);
    }

    @Override
    public String toString() {
        return this._string;
    }

    @Override
    public Class<T> getDelegate() {
        return this.rawType;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return this.actualTypeArguments;
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class<T> getJavaClass() {
        return this.rawType;
    }

    @Override
    public boolean isFinal() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPublic() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPrivate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPackagePrivate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Package getPackage() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isStatic() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isProxyable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Type> getTypeClosure() {
        return this.typeClosure;
    }

    @Override
    public AbstractClassBean<?> getDeclaringBean() {
        return null;
    }

    @Override
    public Type getBaseType() {
        return this.getJavaClass();
    }

    @Override
    public boolean isAssignableTo(Class<?> clazz) {
        return Reflections.isAssignableFrom(clazz, this.getBaseType());
    }
}

