/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mbeanserver;

import java.io.IOException;
import java.net.BindException;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.jmxmp.JMXMPConnectorServer;
import org.glassfish.admin.mbeanserver.BootAMXListener;
import org.glassfish.admin.mbeanserver.ConnectorStarter;
import org.jvnet.hk2.component.Habitat;

final class JMXMPConnectorStarter
extends ConnectorStarter {
    public static final String JMXMP = "jmxmp";

    JMXMPConnectorStarter(MBeanServer mbeanServer, String address, int port, String authRealmName, boolean securityEnabled, Habitat habitat, BootAMXListener bootListener) {
        super(mbeanServer, address, port, authRealmName, securityEnabled, habitat, bootListener);
    }

    public synchronized JMXConnectorServer start() {
        if (this.mConnectorServer != null) {
            return this.mConnectorServer;
        }
        boolean tryOtherPorts = false;
        boolean TRY_COUNT = true;
        int port = this.mPort;
        boolean tryCount = false;
        while (tryCount < true) {
            try {
                this.mConnectorServer = this.startJMXMPConnectorServer(port);
                break;
            }
            catch (BindException e) {
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (port < 1000) {
                port += 1000;
                continue;
            }
            ++port;
        }
        return this.mConnectorServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JMXConnectorServer startJMXMPConnectorServer(int port) throws MalformedURLException, IOException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("jmx.remote.protocol.provider.pkgs", "com.sun.jmx.remote.protocol");
        env.put("jmx.remote.protocol.provider.class.loader", this.getClass().getClassLoader());
        JMXAuthenticator authenticator = this.getAccessController();
        if (authenticator != null) {
            env.put("jmx.remote.authenticator", authenticator);
        }
        JMXServiceURL serviceURL = new JMXServiceURL("service:jmx:jmxmp://" + this.hostname() + ":" + port);
        JMXMPConnectorServer jmxmp = null;
        boolean startedOK = false;
        try {
            jmxmp = new JMXMPConnectorServer(serviceURL, env, this.mMBeanServer);
            if (this.mBootListener != null) {
                jmxmp.addNotificationListener(this.mBootListener, null, serviceURL.toString());
            }
            jmxmp.start();
            startedOK = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (!startedOK) {
                try {
                    if (jmxmp != null) {
                        jmxmp.stop();
                    }
                }
                catch (Exception e) {
                    JMXMPConnectorStarter.ignore(e);
                }
            }
        }
        this.mJMXServiceURL = serviceURL;
        this.mConnectorServer = jmxmp;
        return this.mConnectorServer;
    }
}

