/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.derby.impl.drda.DDMReader;
import org.apache.derby.impl.drda.DRDAProtocolException;
import org.apache.derby.impl.drda.EXTDTAReaderInputStream;

final class LayerBStreamedEXTDTAReaderInputStream
extends EXTDTAReaderInputStream {
    private final DDMReader reader;
    private ByteArrayInputStream currentBuffer;

    LayerBStreamedEXTDTAReaderInputStream(DDMReader dDMReader) throws DRDAProtocolException {
        this.reader = dDMReader;
        this.currentBuffer = dDMReader.readLOBInitStream();
    }

    public final int read() throws IOException {
        int n;
        int n2 = n = this.currentBuffer == null ? -1 : this.currentBuffer.read();
        if (n < 0) {
            n = this.refreshCurrentBuffer();
        }
        return n;
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.currentBuffer.read(byArray, n, n2);
        if (n3 < 0 && this.reader.doingLayerBStreaming()) {
            this.currentBuffer = this.reader.readLOBContinuationStream();
            n3 = this.currentBuffer.read(byArray, n, n2);
        }
        return n3;
    }

    public final int available() {
        return this.currentBuffer.available();
    }

    private int refreshCurrentBuffer() throws IOException {
        if (!this.reader.doingLayerBStreaming()) {
            return -1;
        }
        this.currentBuffer = this.reader.readLOBContinuationStream();
        return this.currentBuffer.read();
    }
}

