/*
 * Decompiled with CFR 0.152.
 */
package com.sun.data.provider.impl;

import com.sun.data.provider.DataProviderException;
import com.sun.data.provider.FieldKey;
import com.sun.data.provider.FilterCriteria;
import com.sun.data.provider.RowKey;
import com.sun.data.provider.TableDataProvider;
import java.text.Collator;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;

public class CompareFilterCriteria
extends FilterCriteria {
    private transient ResourceBundle bundle = null;
    protected Locale compareLocale;
    protected boolean matchEqualTo = true;
    protected boolean matchLessThan = false;
    protected boolean matchGreaterThan = false;
    private FieldKey fieldKey;
    private Object compareValue;

    public CompareFilterCriteria() {
    }

    private ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = ResourceBundle.getBundle("com/sun/data/provider/impl/Bundle");
        }
        return this.bundle;
    }

    public CompareFilterCriteria(FieldKey fieldKey) {
        this.fieldKey = fieldKey;
    }

    public CompareFilterCriteria(Object compareValue) {
        this.compareValue = compareValue;
    }

    public CompareFilterCriteria(FieldKey fieldKey, Object compareValue) {
        this.fieldKey = fieldKey;
        this.compareValue = compareValue;
    }

    public CompareFilterCriteria(FieldKey fieldKey, Object compareValue, boolean matchLessThan, boolean matchEqualTo, boolean matchGreaterThan) {
        this.fieldKey = fieldKey;
        this.compareValue = compareValue;
        this.matchLessThan = matchLessThan;
        this.matchEqualTo = matchEqualTo;
        this.matchGreaterThan = matchGreaterThan;
    }

    public String getDisplayName() {
        String name = super.getDisplayName();
        if (name != null && !"".equals(name)) {
            return name;
        }
        FieldKey key = this.getFieldKey();
        Object val = this.getCompareValue();
        StringBuffer sb = new StringBuffer();
        sb.append(this.isInclude() ? this.getBundle().getString("INCLUDE") + " [" : this.getBundle().getString("EXCLUDE") + " [");
        sb.append(key != null ? key.getDisplayName() : this.getBundle().getString("NO_DATA_KEY"));
        sb.append("] ");
        boolean anyMatches = false;
        if (this.matchLessThan) {
            anyMatches = true;
            sb.append(this.getBundle().getString("LESS_THAN"));
        }
        if (this.matchEqualTo) {
            if (anyMatches) {
                sb.append(this.getBundle().getString("OR"));
            }
            anyMatches = true;
            sb.append(this.getBundle().getString("EQUAL_TO"));
        }
        if (this.matchGreaterThan) {
            if (anyMatches) {
                sb.append(this.getBundle().getString("OR"));
            }
            sb.append(this.getBundle().getString("GREATER_THAN"));
        }
        sb.append("[" + val + "]");
        return sb.toString();
    }

    public void setFieldKey(FieldKey fieldKey) {
        this.fieldKey = fieldKey;
    }

    public FieldKey getFieldKey() {
        return this.fieldKey;
    }

    public void setCompareValue(Object value) {
        this.compareValue = value;
    }

    public Object getCompareValue() {
        return this.compareValue;
    }

    public void setCompareLocale(Locale compareLocale) {
        this.compareLocale = compareLocale;
    }

    public Locale getCompareLocale() {
        return this.compareLocale;
    }

    public void setMatchEqualTo(boolean matchEqualTo) {
        this.matchEqualTo = matchEqualTo;
    }

    public boolean isMatchEqualTo() {
        return this.matchEqualTo;
    }

    public void setMatchLessThan(boolean matchLessThan) {
        this.matchLessThan = matchLessThan;
    }

    public boolean isMatchLessThan() {
        return this.matchLessThan;
    }

    public void setMatchGreaterThan(boolean matchGreaterThan) {
        this.matchGreaterThan = matchGreaterThan;
    }

    public boolean isMatchGreaterThan() {
        return this.matchGreaterThan;
    }

    public boolean match(TableDataProvider provider, RowKey row) throws DataProviderException {
        if (this.fieldKey == null) {
            return true;
        }
        Object o = provider.getValue(this.fieldKey, row);
        int compare = CompareFilterCriteria.compare(o, this.compareValue, this.compareLocale);
        switch (compare) {
            case -1: {
                return this.matchLessThan;
            }
            case 0: {
                return this.matchEqualTo;
            }
            case 1: {
                return this.matchGreaterThan;
            }
        }
        return false;
    }

    public static int compare(Object o1, Object o2, Locale compareLocale) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1 instanceof Comparator && o2 instanceof Comparator) {
            return ((Comparator)o1).compare(o1, o2);
        }
        if (o1 instanceof Character && o2 instanceof Character) {
            return ((Character)o1).compareTo(o2);
        }
        if (o1 instanceof Date && o2 instanceof Date) {
            return ((Date)o1).compareTo(o2);
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            Double d1 = new Double(((Number)o1).doubleValue());
            Double d2 = new Double(((Number)o2).doubleValue());
            return d1.compareTo(d2);
        }
        if (o1 instanceof Boolean && o2 instanceof Boolean) {
            boolean b2;
            boolean b1 = (Boolean)o1;
            if (b1 == (b2 = ((Boolean)o2).booleanValue())) {
                return 0;
            }
            if (b1) {
                return -1;
            }
            return 1;
        }
        if (o1 instanceof String && o2 instanceof String) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            Collator collator = Collator.getInstance(compareLocale != null ? compareLocale : Locale.getDefault());
            collator.setStrength(3);
            return collator.compare(s1, s2);
        }
        String s1 = o1.toString();
        String s2 = o2.toString();
        return s1.compareTo(s2);
    }
}

