/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.common;

import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.common.ActionReporter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="plain")
@Scoped(value=PerLookup.class)
public class PlainTextActionReporter
extends ActionReporter {
    public static final String MAGIC = "PlainTextActionReporter";
    private PrintWriter writer;
    private static final String INDENT = "    ";

    public void writeReport(OutputStream os) throws IOException {
        this.writer = new PrintWriter(os);
        this.writer.print(MAGIC);
        if (this.isFailure()) {
            this.writer.print("FAILURE");
            Throwable t = this.getFailureCause();
            if (t != null) {
                this.writer.print(t);
            }
        } else {
            this.writer.print("SUCCESS");
        }
        if (this.superSimple(this.topMessage)) {
            this.writer.print(this.topMessage.getMessage());
        } else {
            this.writer.print("\n");
            if (StringUtils.ok((String)this.actionDescription)) {
                this.writer.println("Description: " + this.actionDescription);
            }
            this.write("", this.topMessage);
        }
        if (!this.subActions.isEmpty()) {
            this.writer.println("There are " + this.subActions.size() + " sub operations");
        }
        this.writer.flush();
    }

    public String getContentType() {
        return "text/plain";
    }

    private boolean superSimple(ActionReport.MessagePart part) {
        List<ActionReport.MessagePart> list = part.getChildren();
        Properties props = part.getProps();
        boolean hasChildren = list != null && !list.isEmpty();
        boolean hasProps = props != null && props.size() > 0;
        return !hasProps && !hasChildren;
    }

    private void write(String indent, ActionReport.MessagePart part) {
        this.writer.printf("%s%s\n", indent, part.getMessage());
        this.write(indent + INDENT, part.getProps());
        for (ActionReport.MessagePart child : part.getChildren()) {
            this.write(indent + INDENT, child);
        }
    }

    private void write(String indent, Properties props) {
        if (props == null || props.size() <= 0) {
            return;
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = "" + entry.getKey();
            String val = "" + entry.getValue();
            this.writer.printf("%s[%s=%s]\n", indent, key, val);
        }
    }
}

