/*
 * Decompiled with CFR 0.152.
 */
package jmaki.runtime;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.regex.Pattern;
import jmaki.runtime.AjaxContext;
import jmaki.runtime.AjaxException;
import jmaki.runtime.AjaxWriter;
import jmaki.runtime.CommonGlobalRenderer;
import jmaki.runtime.IOUtil;
import jmaki.runtime.LocalizedMessage;
import jmaki.runtime.ResourceManager;
import jmaki.runtime.WidgetPropertyHolder;
import jmaki.runtime.WidgetResourceException;
import jmaki.runtime.config.Config;
import jmaki.runtime.config.GlobalConfig;
import jmaki.runtime.jsf.event.JMakiEventListener;
import jmaki.runtime.jsf.event.JMakiEventSource;
import org.json.JSONRegExp;

public class WidgetCommonRenderer {
    private Config widgetConfig;
    private AjaxContext ajx;
    private ResourceManager resourceManager;
    private GlobalConfig globalConfig;
    private String args;
    private String name;
    private String script;
    private String publish;
    private String subscribe;
    private String service;
    private String style;
    private String template;
    private String uuid;
    private String formid;
    private Object value;
    private JMakiEventSource eventSource;
    private String absoluteWidgetPath;
    private boolean isWidgetWebAppResource;
    public static String COMP_JS_MINIFIED = "component-min.js";
    public static String COMP_JS = "component.js";

    /*
     * Enabled aggressive block sorting
     */
    public void init(AjaxContext ajx, WidgetPropertyHolder widget) throws AjaxException {
        String widgetDir;
        block20: {
            block25: {
                block19: {
                    String tmpScript;
                    String widgetPath;
                    block21: {
                        block24: {
                            block23: {
                                block22: {
                                    this.ajx = ajx;
                                    this.resourceManager = ajx.getResourceHandler();
                                    this.globalConfig = ajx.getGlobalConfig();
                                    this.args = widget.getArgs();
                                    this.publish = widget.getPublish();
                                    this.subscribe = widget.getSubscribe();
                                    this.service = widget.getService();
                                    this.value = widget.getValue();
                                    if (widget instanceof JMakiEventSource) {
                                        this.eventSource = (JMakiEventSource)((Object)widget);
                                        this.formid = widget.getFormid();
                                    }
                                    this.name = widget.getName();
                                    widgetPath = this.resourceManager.getWidgetDir(this.name);
                                    widgetDir = null;
                                    this.script = widget.getScript();
                                    if (this.script != null || !ajx.getUseMinified()) break block21;
                                    widgetDir = ajx.getWorkingDir() + widgetPath;
                                    tmpScript = IOUtil.resolvePath(widgetDir, COMP_JS_MINIFIED);
                                    if (!this.resourceManager.isWebAppResource(tmpScript)) break block22;
                                    this.script = tmpScript;
                                    this.isWidgetWebAppResource = true;
                                    break block19;
                                }
                                widgetDir = ajx.getWorkingDir() + widgetPath;
                                tmpScript = IOUtil.resolvePath(widgetDir, COMP_JS);
                                if (!this.resourceManager.isWebAppResource(tmpScript)) break block23;
                                this.script = tmpScript;
                                this.isWidgetWebAppResource = true;
                                break block19;
                            }
                            widgetDir = this.resourceManager.getWebResourcePath() + widgetPath;
                            tmpScript = IOUtil.resolvePath(widgetDir, COMP_JS_MINIFIED);
                            if (!this.resourceManager.isWebAppResource(tmpScript)) break block24;
                            this.script = tmpScript;
                            this.isWidgetWebAppResource = true;
                            break block19;
                        }
                        widgetDir = this.resourceManager.getWebResourcePath() + widgetPath;
                        tmpScript = IOUtil.resolvePath(widgetDir, COMP_JS);
                        if (this.resourceManager.isWebAppResource(tmpScript)) {
                            this.script = tmpScript;
                            this.isWidgetWebAppResource = true;
                            break block19;
                        } else {
                            widgetDir = this.resourceManager.getResourcesDir() + widgetPath;
                            tmpScript = IOUtil.resolvePath(widgetDir, COMP_JS_MINIFIED);
                            if (this.resourceManager.isClassPathResource(tmpScript)) {
                                this.script = tmpScript;
                                this.isWidgetWebAppResource = false;
                                break block19;
                            } else {
                                widgetDir = this.resourceManager.getResourcesDir() + widgetPath;
                                tmpScript = IOUtil.resolvePath(widgetDir, COMP_JS);
                                if (!this.resourceManager.isClassPathResource(tmpScript)) {
                                    String[] parameter = new String[]{COMP_JS, ajx.getWorkingDir() + widgetPath + "', '" + this.resourceManager.getWebResourcePath() + widgetPath, "META-INF" + this.resourceManager.getResourcesDir() + widgetPath};
                                    throw new WidgetResourceException(new LocalizedMessage("ERROR_LOCATE_RESOURCE_IN", parameter));
                                }
                                this.script = tmpScript;
                                this.isWidgetWebAppResource = false;
                            }
                        }
                        break block19;
                    }
                    this.script = COMP_JS;
                    widgetDir = ajx.getWorkingDir() + widgetPath;
                    tmpScript = IOUtil.resolvePath(widgetDir, this.script);
                    if (this.resourceManager.isWebAppResource(tmpScript)) {
                        this.script = tmpScript;
                        this.isWidgetWebAppResource = true;
                    } else {
                        widgetDir = this.resourceManager.getWebResourcePath() + widgetPath;
                        tmpScript = IOUtil.resolvePath(widgetDir, this.script);
                        if (this.resourceManager.isWebAppResource(tmpScript)) {
                            this.script = tmpScript;
                            this.isWidgetWebAppResource = true;
                        } else {
                            widgetDir = this.resourceManager.getResourcesDir() + widgetPath;
                            tmpScript = IOUtil.resolvePath(widgetDir, this.script);
                            if (!this.resourceManager.isClassPathResource(tmpScript)) {
                                String[] parameter = new String[]{this.script, ajx.getWorkingDir() + widgetPath + "', '" + this.resourceManager.getWebResourcePath() + widgetPath, "META-INF" + this.resourceManager.getResourcesDir() + widgetPath};
                                throw new WidgetResourceException(new LocalizedMessage("ERROR_LOCATE_RESOURCE_IN", parameter));
                            }
                            this.script = tmpScript;
                            this.isWidgetWebAppResource = false;
                        }
                    }
                }
                this.uuid = widget.getUuid();
                if (this.uuid == null) {
                    this.uuid = this.name + "" + ajx.getUniqueId();
                    this.uuid = this.uuid.replace('.', '_');
                }
                if ((this.style = widget.getStyle()) == null) {
                    String stylePath = widgetDir + "/component.css";
                    if (this.isWidgetWebAppResource ? this.resourceManager.isWebAppResource(stylePath) : this.resourceManager.isClassPathResource(stylePath)) {
                        this.style = stylePath;
                    }
                } else {
                    this.style = IOUtil.resolvePath(widgetDir, this.style);
                }
                this.template = widget.getTemplate();
                if (this.template != null) break block25;
                String templatePath = widgetDir + "/component.htm";
                if (this.isWidgetWebAppResource ? this.resourceManager.isWebAppResource(templatePath) : this.resourceManager.isClassPathResource(templatePath)) {
                    this.template = templatePath;
                    break block20;
                } else {
                    templatePath = templatePath + "l";
                    if (this.isWidgetWebAppResource ? this.resourceManager.isWebAppResource(templatePath) : this.resourceManager.isClassPathResource(templatePath)) {
                        this.template = templatePath;
                        break block20;
                    } else {
                        String[] parameter = new String[]{templatePath, this.name};
                        throw new WidgetResourceException(new LocalizedMessage("ERROR_LOCATE_RESOURCE_FOR_WIDGET", parameter));
                    }
                }
            }
            this.template = IOUtil.resolvePath(widgetDir, this.template);
        }
        this.widgetConfig = this.globalConfig.getWidgetConfig(this.name, widgetDir, ajx.getUseWidgetConifg());
        this.absoluteWidgetPath = this.isWidgetWebAppResource ? ajx.buildWebAppResourceReference(widgetDir) : ajx.buildClassPathResourceReference(widgetDir);
        AjaxContext.getLogger().finest("uuid: '" + this.uuid + "', widgettype: '" + this.name + "', widgetdir: '" + widgetDir + "', absoluteWidgetPath: '" + this.absoluteWidgetPath + "', template: '" + this.template + "', style: '" + this.style + "', script: '" + this.script);
    }

    public void writeResources(AjaxWriter out) throws IOException {
        CommonGlobalRenderer.writeTypeResources(this.ajx, out, this.widgetConfig, this.uuid);
        this.writeStyle(out);
        this.writeScript(out);
        this.writeAddWidget(out);
        if (this.eventSource != null) {
            this.writeListener(out);
        }
    }

    public void writeMarkup(AjaxWriter out) throws IOException {
        this.writeTemplate(out);
    }

    private void writeListener(AjaxWriter out) throws IOException {
        JMakiEventListener[] listeners = this.eventSource.getJMakiEventListeners();
        if (listeners != null && listeners.length > 0) {
            for (int i = 0; i < listeners.length; ++i) {
                Object[] subscribe;
                JMakiEventListener listener = listeners[i];
                String publish = listener.getPublish();
                if (publish == null) {
                    publish = this.publish;
                }
                if (publish != null) {
                    out.writeScript("jmaki.extensions.jmaki.dynafaces.topics['" + this.uuid + "']='" + publish + "';");
                }
                if ((subscribe = listener.getSubscribe()) == null) continue;
                boolean immediate = listener.getImmediate();
                for (int j = 0; j < subscribe.length; ++j) {
                    if (immediate) {
                        out.writeScript("jmaki.subscribe(" + (subscribe[j] instanceof Pattern ? JSONRegExp.toString((Pattern)((Pattern)subscribe[j])) : "'" + subscribe[j] + "'") + ", jmaki.extensions.jmaki.dynafaces.ImmediateHandler('" + this.uuid + "','" + this.formid + "','" + listener.getRender() + "','" + listener.getExecute() + "'));");
                        continue;
                    }
                    out.writeScript("jmaki.subscribe(" + (subscribe[j] instanceof Pattern ? JSONRegExp.toString((Pattern)((Pattern)subscribe[j])) : "'" + subscribe[j] + "'") + ", jmaki.extensions.jmaki.dynafaces.QueuedHandler('" + this.uuid + "'));");
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeStyle(AjaxWriter out) throws IOException {
        if (this.style == null) return;
        if (this.ajx.isStyleWritten(this.style)) return;
        if (this.ajx.getInlineStyles() || this.ajx.getCombineStyles() && this.ajx.getCombinedResourceManager() != null) {
            if (this.ajx.getInlineStyles()) {
                URL styleURL = this.isWidgetWebAppResource ? this.resourceManager.locateWebAppResource(this.style) : this.resourceManager.locateClassPathResource(this.style);
                StringBuffer styleBuffer = null;
                try {
                    styleBuffer = IOUtil.loadResource(styleURL.openStream(), "UTF-8");
                }
                catch (Exception ioe) {
                    String[] parameter = new String[]{this.style, this.name};
                    throw new WidgetResourceException(new LocalizedMessage("ERROR_LOCATE_RESOURCE_FOR_WIDGET", parameter), (Throwable)ioe);
                }
                out.writeInlineStyle(styleBuffer.toString());
                return;
            }
            if (this.ajx.getIsChildOfPage()) {
                this.ajx.getCombinedResourceManager().addStyleResource(this.style, this.name, this.absoluteWidgetPath, this.isWidgetWebAppResource);
                return;
            }
            String[] parameter = new String[]{this.name};
            throw new WidgetResourceException(new LocalizedMessage("ERROR_COMBINE_RESOURCE_TYPE", parameter));
        }
        out.writeStyle(this.ajx.buildResourceReference(this.style, this.isWidgetWebAppResource));
        this.ajx.setStyleWritten(this.style);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeScript(AjaxWriter out) throws IOException {
        block5: {
            block7: {
                block6: {
                    if (this.ajx.isLibraryWritten(this.script)) break block5;
                    if (!this.ajx.getInlineScripts() && (!this.ajx.getCombineScripts() || this.ajx.getCombinedResourceManager() == null)) break block6;
                    if (this.ajx.getInlineScripts()) {
                        URL scriptURL = this.isWidgetWebAppResource ? this.resourceManager.locateWebAppResource(this.script) : this.resourceManager.locateClassPathResource(this.script);
                        StringBuffer scriptBuffer = null;
                        try {
                            scriptBuffer = IOUtil.loadResource(scriptURL.openStream(), "UTF-8");
                        }
                        catch (Exception ioe) {
                            String[] parameter = new String[]{this.script, this.name};
                            throw new WidgetResourceException(new LocalizedMessage("ERROR_LOCATE_RESOURCE_FOR_WIDGET", parameter), (Throwable)ioe);
                        }
                        out.writeScript(scriptBuffer.toString());
                        break block7;
                    } else {
                        if (!this.ajx.getIsChildOfPage()) {
                            String[] parameter = new String[]{this.name};
                            throw new WidgetResourceException(new LocalizedMessage("ERROR_COMBINE_RESOURCE_TYPE", parameter));
                        }
                        this.ajx.getCombinedResourceManager().addScriptResource(this.script, this.name, this.absoluteWidgetPath, this.isWidgetWebAppResource);
                    }
                    break block7;
                }
                out.writeLib(this.ajx.buildResourceReference(this.script, this.isWidgetWebAppResource));
            }
            this.ajx.setLibraryWritten(this.script);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAddWidget(AjaxWriter out) throws IOException {
        HashMap<String, Object> widgetProperties = new HashMap<String, Object>();
        try {
            widgetProperties.put("uuid", this.uuid);
            widgetProperties.put("name", this.name);
            if (this.ajx.getIncludeSourceURL()) {
                widgetProperties.put("sourceURL", this.ajx.getSourceURL());
            }
            widgetProperties.put("widgetDir", this.absoluteWidgetPath);
            if (this.service != null) {
                widgetProperties.put("service", this.service);
            }
            if (this.publish != null) {
                widgetProperties.put("publish", this.publish);
            }
            if (this.subscribe != null) {
                widgetProperties.put("subscribe", this.subscribe);
            }
            if (this.value != null) {
                widgetProperties.put("value", this.value);
            }
            if (this.args != null) {
                widgetProperties.put("args", this.args);
            }
            out.writeScript("jmaki.addWidget(" + IOUtil.createJavaScriptObject(widgetProperties) + ");");
        }
        finally {
            widgetProperties.clear();
        }
    }

    private void writeTemplate(AjaxWriter out) throws IOException {
        URL templateURL = this.isWidgetWebAppResource ? this.resourceManager.locateWebAppResource(this.template) : this.resourceManager.locateClassPathResource(this.template);
        StringBuffer templateBuffer = null;
        try {
            templateBuffer = IOUtil.loadResource(templateURL.openStream(), "UTF-8");
        }
        catch (Exception ioe) {
            String[] parameter = new String[]{this.template, this.name};
            throw new WidgetResourceException(new LocalizedMessage("ERROR_LOCATE_RESOURCE_FOR_WIDGET", parameter), (Throwable)ioe);
        }
        IOUtil.replace(templateBuffer, "${uuid}", this.uuid);
        if (this.service != null) {
            IOUtil.replace(templateBuffer, "${service}", this.service);
        }
        if (this.args != null) {
            IOUtil.replace(templateBuffer, "${args}", this.args);
        }
        if (this.value != null && this.value instanceof String) {
            if (((String)this.value).startsWith("@{")) {
                IOUtil.replace(templateBuffer, "${value}", "");
            } else {
                IOUtil.replace(templateBuffer, "${value}", this.value.toString());
            }
        }
        IOUtil.replace(templateBuffer, "${webRoot}", this.ajx.getGlobalWebRoot());
        IOUtil.replace(templateBuffer, "${widgetDir}", this.absoluteWidgetPath);
        IOUtil.replace(templateBuffer, "${contextPath}", this.ajx.getRequest().getContextPath());
        out.write(templateBuffer.toString());
    }

    public void cleanup() {
        this.widgetConfig = null;
        this.ajx = null;
        this.resourceManager = null;
        this.globalConfig = null;
        this.args = null;
        this.name = null;
        this.publish = null;
        this.script = null;
        this.subscribe = null;
        this.service = null;
        this.style = null;
        this.template = null;
        this.value = null;
        this.uuid = null;
        this.absoluteWidgetPath = null;
    }
}

