/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.j2ee;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.j2ee.Management;
import javax.management.j2ee.ManagementHome;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.impl.j2ee.Metadata;
import org.glassfish.admin.amx.impl.j2ee.MetadataImpl;
import org.glassfish.admin.amx.impl.mbean.AMXImplBase;
import org.glassfish.admin.amx.impl.util.ObjectNameBuilder;
import org.glassfish.admin.amx.intf.config.Domain;
import org.glassfish.admin.amx.j2ee.J2EEManagedObject;
import org.glassfish.admin.amx.j2ee.J2EEServer;
import org.glassfish.admin.amx.util.SetUtil;
import org.glassfish.admin.amx.util.StringUtil;
import org.glassfish.admin.amx.util.jmx.JMXUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class J2EEManagedObjectImplBase
extends AMXImplBase {
    protected final long mStartTime;
    private final boolean mStateManageable;
    private final boolean mStatisticsProvider;
    private final boolean mEventProvider;
    private final Metadata mMeta;
    private static final Set<String> REQUIRES_J2EE_APP = SetUtil.newUnmodifiableStringSet("WebModule", "ResourceAdapterModule", "AppClientModule", "StatefulSessionBean", "StatelessSessionBean", "EntityBean", "MessageDrivenBean", "Servlet", "ResourceAdapter");
    private static final String NULL_APP_PROP = Util.makeProp("J2EEApplication", null);
    private static final Set<String> DEPLOYED_TYPES = SetUtil.newUnmodifiableStringSet("J2EEApplication", "WebModule", "EJBModule", "AppClientModule", "ResourceAdapterModule");

    public J2EEManagedObjectImplBase(ObjectName parentObjectName, Metadata meta, Class<? extends J2EEManagedObject> intf) {
        this(parentObjectName, meta, intf, false, false, false);
    }

    public J2EEManagedObjectImplBase(ObjectName parentObjectName, Metadata meta, Class<? extends J2EEManagedObject> intf, boolean stateManageable, boolean statisticsProvider, boolean evengProvider) {
        super(parentObjectName, intf);
        this.mMeta = meta;
        this.mStateManageable = stateManageable;
        this.mStatisticsProvider = statisticsProvider;
        this.mEventProvider = evengProvider;
        this.mStartTime = System.currentTimeMillis();
    }

    protected MetadataImpl defaultChildMetadata() {
        HashMap<String, Object> meta = new HashMap<String, Object>();
        meta.put("Parent", (Object)this);
        MetadataImpl impl = new MetadataImpl(meta);
        return impl;
    }

    protected Metadata metadata() {
        return this.mMeta;
    }

    public ObjectName getCorrespondingConfig() {
        return this.metadata().getCorrespondingConfig();
    }

    protected Domain getDomainConfig() {
        return this.getDomainRootProxy().getDomain().as(Domain.class);
    }

    protected ObjectName preRegisterModifyName(MBeanServer server, ObjectName nameIn) {
        String props = this.getExtraObjectNameProps(server, nameIn);
        if (props == null || props.length() == 0) {
            return nameIn;
        }
        return JMXUtil.newObjectName(nameIn.toString() + "," + props);
    }

    protected String getExtraObjectNameProps(MBeanServer server, ObjectName nameIn) {
        String type = Util.getTypeProp(nameIn);
        String props = Util.makeProp("j2eeType", type);
        List ancestors = ObjectNameBuilder.getAncestors((MBeanServer)server, (ObjectName)this.getParent());
        boolean foundApp = false;
        for (int i = 2; i < ancestors.size(); ++i) {
            ObjectName ancestor = (ObjectName)ancestors.get(i);
            String ancestorType = ancestor.getKeyProperty("j2eeType");
            String ancestorName = ancestor.getKeyProperty("name");
            String ancestorProp = Util.makeProp(ancestorType, ancestorName);
            props = Util.concatenateProps(props, ancestorProp);
            if (!ancestorType.equals("J2EEApplication")) continue;
            foundApp = true;
        }
        if (REQUIRES_J2EE_APP.contains(type) && !foundApp) {
            props = Util.concatenateProps(props, NULL_APP_PROP);
        }
        return props;
    }

    protected String j2eeType(ObjectName objectName) {
        return objectName.getKeyProperty("j2eeType");
    }

    public long getstartTime() {
        return this.mStartTime;
    }

    protected String getServerName() {
        return this.getObjectName().getKeyProperty("J2EEServer");
    }

    public String getobjectName() {
        return this.getObjectName().toString();
    }

    public boolean isstatisticsProvider() {
        return this.mEventProvider;
    }

    public boolean iseventProvider() {
        return this.mStatisticsProvider;
    }

    public boolean isstateManageable() {
        return this.mStateManageable;
    }

    public J2EEServer getJ2EEServer() {
        return this.getProxyFactory().getProxy(this.getServerObjectName(), J2EEServer.class);
    }

    public ObjectName getServerObjectName() {
        String serverType = Util.deduceType(J2EEServer.class);
        return this.getAncestorByType(serverType);
    }

    public String[] getdeployedObjects() {
        return this.getChildrenAsStrings(DEPLOYED_TYPES);
    }

    public int getstate() {
        return 3;
    }

    protected String[] getChildrenAsStrings(Set<String> types) {
        Object[] children = this.getChildren(types);
        return StringUtil.toStringArray(children);
    }

    protected String[] getChildrenAsStrings(String ... args) {
        if (args.length == 0) {
            throw new IllegalArgumentException("Must specify at least one child");
        }
        Set<String> types = SetUtil.newStringSet(args);
        return this.getChildrenAsStrings(types);
    }

    public final Management getMEJB() {
        Management mejb = null;
        try {
            InitialContext ic = new InitialContext();
            String ejbName = System.getProperty("mejb.name", "ejb/mgmt/MEJB");
            Object objref = ic.lookup(ejbName);
            ManagementHome home = (ManagementHome)PortableRemoteObject.narrow((Object)objref, ManagementHome.class);
            mejb = home.create();
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't find MEJB", ex);
        }
        return mejb;
    }
}

