/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.faces;

import com.sun.data.provider.RowKey;
import com.sun.data.provider.SortCriteria;
import com.sun.data.provider.TableDataProvider;
import com.sun.data.provider.impl.TableRowDataProvider;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;

public class ValueExpressionSortCriteria
extends SortCriteria {
    private String valueExpression;
    private String requestMapKey = "currentRow";
    private transient TableRowDataProvider rowProvider;
    private String rowProviderLock = "rowProviderLock";

    public ValueExpressionSortCriteria() {
    }

    public ValueExpressionSortCriteria(String valueExpression) {
        this.valueExpression = valueExpression;
    }

    public ValueExpressionSortCriteria(String valueExpression, boolean ascending) {
        this.valueExpression = valueExpression;
        this.setAscending(ascending);
    }

    public String getValueExpression() {
        return this.valueExpression;
    }

    public void setValueExpression(String valueExpression) {
        this.valueExpression = valueExpression;
    }

    public String getRequestMapKey() {
        return this.requestMapKey;
    }

    public void setRequestMapKey(String requestMapKey) {
        this.requestMapKey = requestMapKey;
    }

    public String getDisplayName() {
        String name = super.getDisplayName();
        if ((name == null || "".equals(name)) && this.valueExpression != null && !"".equals(this.valueExpression)) {
            return this.valueExpression;
        }
        return name;
    }

    public String getCriteriaKey() {
        return this.valueExpression != null ? this.valueExpression : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSortValue(TableDataProvider provider, RowKey row) {
        if (this.valueExpression == null || "".equals(this.valueExpression)) {
            return null;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ValueExpression valueBinding = facesContext.getApplication().getExpressionFactory().createValueExpression(facesContext.getELContext(), this.valueExpression, Object.class);
        if (valueBinding == null) {
            return null;
        }
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        Object value = null;
        String string = this.rowProviderLock;
        synchronized (string) {
            Object storedRequestMapValue = null;
            if (this.requestMapKey != null && !"".equals(this.requestMapKey)) {
                storedRequestMapValue = requestMap.get(this.requestMapKey);
                if (this.rowProvider == null) {
                    this.rowProvider = new TableRowDataProvider();
                }
                this.rowProvider.setTableDataProvider(provider);
                this.rowProvider.setTableRow(row);
                requestMap.put(this.requestMapKey, this.rowProvider);
            }
            value = valueBinding.getValue(facesContext.getELContext());
            if (this.requestMapKey != null && !"".equals(this.requestMapKey)) {
                if (this.rowProvider != null) {
                    this.rowProvider.setTableDataProvider(null);
                    this.rowProvider.setTableRow(null);
                }
                requestMap.put(this.requestMapKey, storedRequestMapValue);
            }
        }
        return value;
    }
}

