/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.multipart;

import com.sun.jersey.core.header.ContentDisposition;
import com.sun.jersey.core.header.ParameterizedHeader;
import com.sun.jersey.core.util.UnmodifiableMultivaluedMap;
import com.sun.jersey.multipart.BodyPartEntity;
import com.sun.jersey.multipart.HeadersMap;
import com.sun.jersey.multipart.MultiPart;
import com.sun.jersey.multipart.ParameterizedHeadersMap;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.text.ParseException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Providers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BodyPart {
    private Object entity;
    private MultivaluedMap<String, String> headers = new HeadersMap();
    protected ContentDisposition cd = null;
    private MediaType mediaType = null;
    private MultiPart parent = null;
    private Providers providers = null;

    public BodyPart() {
        this(MediaType.TEXT_PLAIN_TYPE);
    }

    public BodyPart(MediaType mediaType) {
        this.setMediaType(mediaType);
    }

    public BodyPart(Object entity, MediaType mediaType) {
        this.setEntity(entity);
        this.setMediaType(mediaType);
    }

    public Object getEntity() {
        return this.entity;
    }

    public void setEntity(Object entity) {
        this.entity = entity;
    }

    public MultivaluedMap<String, String> getHeaders() {
        return this.headers;
    }

    public MultivaluedMap<String, ParameterizedHeader> getParameterizedHeaders() throws ParseException {
        return new UnmodifiableMultivaluedMap((MultivaluedMap)new ParameterizedHeadersMap(this.headers));
    }

    public ContentDisposition getContentDisposition() {
        String scd;
        if (this.cd == null && (scd = (String)this.headers.getFirst((Object)"Content-Disposition")) != null) {
            try {
                this.cd = new ContentDisposition(scd);
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException("Error parsing content disposition: " + scd, ex);
            }
        }
        return this.cd;
    }

    public void setContentDisposition(ContentDisposition cd) {
        this.cd = cd;
        this.headers.remove((Object)"Content-Disposition");
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaType mediaType) {
        if (mediaType == null) {
            throw new IllegalArgumentException("mediaType cannot be null");
        }
        this.mediaType = mediaType;
    }

    public MultiPart getParent() {
        return this.parent;
    }

    public void setParent(MultiPart parent) {
        this.parent = parent;
    }

    public Providers getProviders() {
        return this.providers;
    }

    public void setProviders(Providers providers) {
        this.providers = providers;
    }

    public void cleanup() {
        if (this.getEntity() != null && this.getEntity() instanceof BodyPartEntity) {
            ((BodyPartEntity)this.getEntity()).cleanup();
        }
    }

    public BodyPart entity(Object entity) {
        this.setEntity(entity);
        return this;
    }

    public <T> T getEntityAs(Class<T> clazz) {
        if (this.entity == null || !(this.entity instanceof BodyPartEntity)) {
            throw new IllegalStateException("Entity instance does not contain the unconverted content");
        }
        if (this.getProviders() == null) {
            throw new IllegalStateException("The providers property has not been set, which is done automatically when a MultiPart entity is received");
        }
        Annotation[] annotations = new Annotation[]{};
        MessageBodyReader reader = this.getProviders().getMessageBodyReader(clazz, clazz, annotations, this.mediaType);
        if (reader == null) {
            throw new IllegalArgumentException("No available MessageBodyReader for class " + clazz.getName() + " and media type " + this.mediaType);
        }
        try {
            return (T)reader.readFrom(clazz, clazz, annotations, this.mediaType, this.headers, ((BodyPartEntity)this.entity).getInputStream());
        }
        catch (IOException e) {
            return null;
        }
    }

    public BodyPart type(MediaType type) {
        this.setMediaType(type);
        return this;
    }

    public BodyPart contentDisposition(ContentDisposition cd) {
        this.setContentDisposition(cd);
        return this;
    }
}

