/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.scripting.jruby.monitor;

import java.util.logging.Logger;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.StringStatistic;
import org.glassfish.external.statistics.annotations.Reset;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.external.statistics.impl.StringStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="jruby-runtime-pool-mon", group="monitoring")
@ManagedObject
@Description(value="JRuby runtime pool info")
public class JRubyRuntimePoolStatsProvider {
    private final Logger logger = Logger.getLogger(JRubyRuntimePoolStatsProvider.class.getName());
    private final StringStatisticImpl appName = new StringStatisticImpl("ApplicationName", null, "Ruby application name");
    private final CountStatisticImpl hardMinimum = new CountStatisticImpl("HardMinimum", "count", "Minimum active runtimes");
    private final CountStatisticImpl hardMaximum = new CountStatisticImpl("HardMaximum", "count", "Maximum active runtimes");
    private final CountStatisticImpl activeRuntimes = new CountStatisticImpl("ActiveRuntimes", "count", "Currently active runtimes");

    public JRubyRuntimePoolStatsProvider(String appName) {
        this.appName.setCurrent(appName);
    }

    @ProbeListener(value="glassfish:jruby:runtime-pool:runtimePoolStartEvent")
    @Description(value="JRuby runtime pool creation Event")
    public void runtimePoolStartedEvent(@ProbeParam(value="appName") String appName, @ProbeParam(value="hardMinimum") int hardMinimum, @ProbeParam(value="hardMaximum") int hardMaximum, @ProbeParam(value="activeRuntimes") int activeRuntimes) {
        if (appName == null) {
            this.logger.warning("appName is null in runtimePoolStartedEvent! Looks like the event is not triggered properly, ignoring this monitoring event.");
        } else if (this.appName.getCurrent().equals(appName)) {
            this.hardMinimum.setCount((long)hardMinimum);
            this.hardMaximum.setCount((long)hardMaximum);
            this.activeRuntimes.setCount((long)activeRuntimes);
        }
    }

    @ProbeListener(value="glassfish:jruby:runtime-pool:runtimePoolUpdateEvent")
    @Description(value="JRuby runtime pool update Event")
    public void runtimePoolUpdatedEvent(@ProbeParam(value="appName") String appName, @ProbeParam(value="activeRuntimes") int activeRuntimes) {
        if (appName == null) {
            this.logger.warning("appName is null in runtimePoolUpdatedEvent! Looks like the event is not triggered properly, ignoring this monitoring event.");
        } else if (this.appName.getCurrent().equals(appName)) {
            this.activeRuntimes.setCount((long)activeRuntimes);
        }
    }

    @ManagedAttribute(id="applicationname")
    @Description(value="Application name")
    public StringStatistic getApplicationName() {
        return this.appName;
    }

    @ManagedAttribute
    public CountStatistic getHardMinimum() {
        return this.hardMinimum;
    }

    @ManagedAttribute
    public CountStatistic getHardMaximum() {
        return this.hardMaximum;
    }

    @ManagedAttribute
    public CountStatistic getActiveRuntimes() {
        return this.activeRuntimes;
    }

    @Reset
    public void reset() {
    }
}

