/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.record.DOMReader;
import org.eclipse.persistence.internal.oxm.record.PlatformUnmarshaller;
import org.eclipse.persistence.internal.oxm.record.SAXUnmarshallerHandler;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.XMLUnmarshallerHandler;
import org.eclipse.persistence.oxm.mappings.UnmarshalKeepAsElementPolicy;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.oxm.record.XMLRootRecord;
import org.eclipse.persistence.platform.xml.DefaultErrorHandler;
import org.eclipse.persistence.platform.xml.SAXDocumentBuilder;
import org.eclipse.persistence.platform.xml.XMLParser;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.platform.xml.XMLTransformer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAXUnmarshaller
implements PlatformUnmarshaller {
    private static final String VALIDATING = "http://xml.org/sax/features/validation";
    private static final String SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private int validationMode;
    private Object[] schemas;
    private SAXParser saxParser;
    private XMLReader xmlReader;
    private XMLUnmarshaller xmlUnmarshaller;
    private XMLParser xmlParser;
    private boolean isResultAlwaysXMLRoot;
    private SAXParserFactory saxParserFactory;

    public SAXUnmarshaller(XMLUnmarshaller xmlUnmarshaller, Map<String, Boolean> parserFeatures) throws XMLMarshalException {
        try {
            this.saxParserFactory = SAXParserFactory.newInstance();
            this.saxParserFactory.setNamespaceAware(true);
            this.saxParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            if (null != parserFeatures) {
                for (Map.Entry<String, Boolean> parserFeature : parserFeatures.entrySet()) {
                    try {
                        this.saxParserFactory.setFeature(parserFeature.getKey(), parserFeature.getValue());
                    }
                    catch (SAXNotRecognizedException ex) {
                    }
                    catch (SAXNotSupportedException ex) {}
                }
            }
            this.saxParser = this.saxParserFactory.newSAXParser();
            this.xmlReader = new XMLReader(this.saxParser.getXMLReader());
            this.xmlReader.setErrorHandler(new DefaultErrorHandler());
            this.xmlParser = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLParser();
            this.xmlParser.setNamespaceAware(true);
            this.xmlParser.setValidationMode(0);
            this.xmlUnmarshaller = xmlUnmarshaller;
        }
        catch (Exception e) {
            throw XMLMarshalException.errorInstantiatingSchemaPlatform(e);
        }
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.xmlReader.getEntityResolver();
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.xmlReader.setEntityResolver(entityResolver);
        this.xmlParser.setEntityResolver(entityResolver);
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.xmlReader.getErrorHandler();
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.xmlReader.setErrorHandler(errorHandler);
        this.xmlParser.setErrorHandler(errorHandler);
    }

    @Override
    public int getValidationMode() {
        return this.validationMode;
    }

    @Override
    public void setValidationMode(int validationMode) {
        try {
            this.validationMode = validationMode;
            this.xmlParser.setValidationMode(validationMode);
            switch (validationMode) {
                case 0: {
                    this.xmlReader.setFeature(VALIDATING, false);
                    break;
                }
                case 2: {
                    this.xmlReader.setFeature(VALIDATING, true);
                    break;
                }
                case 3: {
                    try {
                        this.xmlReader.setFeature(VALIDATING, true);
                        this.saxParser.setProperty(SCHEMA_LANGUAGE, XML_SCHEMA);
                        this.saxParser.setProperty(SCHEMA_SOURCE, this.schemas);
                        break;
                    }
                    catch (Exception e) {
                        this.xmlReader.setFeature(VALIDATING, false);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setWhitespacePreserving(boolean isWhitespacePreserving) {
        this.xmlParser.setWhitespacePreserving(isWhitespacePreserving);
    }

    @Override
    public void setSchemas(Object[] schemas) {
        this.schemas = schemas;
    }

    @Override
    public void setSchema(Schema schema) {
        this.saxParserFactory.setSchema(schema);
        try {
            this.saxParser = this.saxParserFactory.newSAXParser();
            XMLReader newXmlReader = new XMLReader(this.saxParser.getXMLReader());
            newXmlReader.setFeature(VALIDATING, this.xmlReader.getFeature(VALIDATING));
            newXmlReader.setEntityResolver(this.xmlReader.getEntityResolver());
            newXmlReader.setErrorHandler(this.xmlReader.getErrorHandler());
            this.xmlReader = newXmlReader;
            this.xmlParser.setXMLSchema(schema);
        }
        catch (Exception e) {
            throw XMLMarshalException.errorInstantiatingSchemaPlatform(e);
        }
    }

    @Override
    public Schema getSchema() {
        return this.saxParserFactory.getSchema();
    }

    @Override
    public Object unmarshal(File file) {
        try {
            if (this.xmlUnmarshaller.getXMLContext().hasDocumentPreservation()) {
                Element domElement = this.xmlParser.parse(file).getDocumentElement();
                return this.unmarshal(domElement);
            }
            FileInputStream inputStream = new FileInputStream(file);
            return this.unmarshal(inputStream);
        }
        catch (FileNotFoundException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
    }

    @Override
    public Object unmarshal(File file, Class clazz) {
        try {
            if (this.xmlUnmarshaller.getXMLContext().hasDocumentPreservation()) {
                Element domElement = this.xmlParser.parse(file).getDocumentElement();
                return this.unmarshal(domElement, clazz);
            }
            FileInputStream inputStream = new FileInputStream(file);
            return this.unmarshal(inputStream, clazz);
        }
        catch (FileNotFoundException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
    }

    @Override
    public Object unmarshal(InputStream inputStream) {
        if (this.xmlUnmarshaller.getXMLContext().hasDocumentPreservation()) {
            Element domElement = this.xmlParser.parse(inputStream).getDocumentElement();
            return this.unmarshal(domElement);
        }
        InputSource inputSource = new InputSource(inputStream);
        return this.unmarshal(inputSource);
    }

    @Override
    public Object unmarshal(InputStream inputStream, Class clazz) {
        if (this.xmlUnmarshaller.getXMLContext().hasDocumentPreservation()) {
            Element domElement = this.xmlParser.parse(inputStream).getDocumentElement();
            return this.unmarshal(domElement, clazz);
        }
        InputSource inputSource = new InputSource(inputStream);
        return this.unmarshal(inputSource, clazz);
    }

    @Override
    public Object unmarshal(InputSource inputSource) {
        return this.unmarshal(this.xmlReader, inputSource);
    }

    public Object unmarshal(InputSource inputSource, XMLReader xmlReader) {
        try {
            SAXUnmarshallerHandler saxUnmarshallerHandler = new SAXUnmarshallerHandler(this.xmlUnmarshaller.getXMLContext());
            saxUnmarshallerHandler.setXMLReader(xmlReader);
            saxUnmarshallerHandler.setUnmarshaller(this.xmlUnmarshaller);
            xmlReader.setContentHandler(saxUnmarshallerHandler);
            xmlReader.parse(inputSource);
            saxUnmarshallerHandler.resolveReferences();
            return saxUnmarshallerHandler.getObject();
        }
        catch (IOException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        catch (SAXException e) {
            throw this.convertSAXException(e);
        }
    }

    @Override
    public Object unmarshal(InputSource inputSource, Class clazz) {
        return this.unmarshal(this.xmlReader, inputSource, clazz);
    }

    public Object unmarshal(InputSource inputSource, Class clazz, XMLReader xmlReader) {
        UnmarshalRecord unmarshalRecord;
        boolean isPrimitiveWrapper = this.isPrimitiveWrapper(clazz);
        XMLDescriptor xmlDescriptor = null;
        AbstractSession session = null;
        if (isPrimitiveWrapper) {
            unmarshalRecord = new XMLRootRecord(clazz);
            unmarshalRecord.setSession((AbstractSession)((Object)this.xmlUnmarshaller.getXMLContext().getSession(0)));
        } else {
            if (clazz == ClassConstants.OBJECT) {
                try {
                    SAXUnmarshallerHandler saxUnmarshallerHandler = new SAXUnmarshallerHandler(this.xmlUnmarshaller.getXMLContext());
                    saxUnmarshallerHandler.setXMLReader(xmlReader);
                    saxUnmarshallerHandler.setUnmarshaller(this.xmlUnmarshaller);
                    saxUnmarshallerHandler.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
                    xmlReader.setContentHandler(saxUnmarshallerHandler);
                    xmlReader.parse(inputSource);
                    saxUnmarshallerHandler.resolveReferences();
                    return saxUnmarshallerHandler.getObject();
                }
                catch (IOException e) {
                    throw XMLMarshalException.unmarshalException(e);
                }
                catch (SAXException e) {
                    throw this.convertSAXException(e);
                }
            }
            session = this.xmlUnmarshaller.getXMLContext().getReadSession(clazz);
            xmlDescriptor = (XMLDescriptor)session.getDescriptor(clazz);
            unmarshalRecord = (UnmarshalRecord)xmlDescriptor.getObjectBuilder().createRecord(session);
        }
        try {
            unmarshalRecord.setXMLReader(xmlReader);
            unmarshalRecord.setUnmarshaller(this.xmlUnmarshaller);
            xmlReader.setContentHandler(unmarshalRecord);
            try {
                unmarshalRecord.getXMLReader().setProperty("http://xml.org/sax/properties/lexical-handler", unmarshalRecord);
            }
            catch (SAXNotRecognizedException ex) {
            }
            catch (SAXNotSupportedException ex) {
                // empty catch block
            }
            xmlReader.parse(inputSource);
        }
        catch (IOException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        catch (SAXException e) {
            throw this.convertSAXException(e);
        }
        this.xmlUnmarshaller.resolveReferences(session);
        if (isPrimitiveWrapper) {
            return unmarshalRecord.getCurrentObject();
        }
        return xmlDescriptor.wrapObjectInXMLRoot(unmarshalRecord, this.isResultAlwaysXMLRoot);
    }

    @Override
    public Object unmarshal(Node node) {
        DOMReader reader = new DOMReader();
        return this.unmarshal(reader, node);
    }

    public Object unmarshal(DOMReader reader, Node node) {
        try {
            SAXUnmarshallerHandler handler = new SAXUnmarshallerHandler(this.xmlUnmarshaller.getXMLContext());
            reader.setContentHandler(handler);
            handler.setXMLReader(reader);
            handler.setUnmarshaller(this.xmlUnmarshaller);
            reader.parse(node);
            handler.resolveReferences();
            return handler.getObject();
        }
        catch (SAXException e) {
            throw this.convertSAXException(e);
        }
    }

    @Override
    public Object unmarshal(Node node, Class clazz) {
        DOMReader reader = new DOMReader();
        return this.unmarshal(reader, node, clazz);
    }

    public Object unmarshal(DOMReader domReader, Node node, Class clazz) {
        UnmarshalRecord unmarshalRecord;
        boolean isPrimitiveWrapper = this.isPrimitiveWrapper(clazz);
        XMLDescriptor xmlDescriptor = null;
        AbstractSession session = null;
        if (isPrimitiveWrapper) {
            unmarshalRecord = new XMLRootRecord(clazz);
            unmarshalRecord.setSession((AbstractSession)((Object)this.xmlUnmarshaller.getXMLContext().getSession(0)));
        } else {
            if (clazz == ClassConstants.OBJECT) {
                SAXUnmarshallerHandler saxUnmarshallerHandler = new SAXUnmarshallerHandler(this.xmlUnmarshaller.getXMLContext());
                saxUnmarshallerHandler.setXMLReader(domReader);
                saxUnmarshallerHandler.setUnmarshaller(this.xmlUnmarshaller);
                saxUnmarshallerHandler.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
                domReader.setContentHandler(saxUnmarshallerHandler);
                try {
                    domReader.parse(node);
                }
                catch (SAXException e) {
                    throw this.convertSAXException(e);
                }
                saxUnmarshallerHandler.resolveReferences();
                return saxUnmarshallerHandler.getObject();
            }
            session = this.xmlUnmarshaller.getXMLContext().getReadSession(clazz);
            xmlDescriptor = (XMLDescriptor)session.getDescriptor(clazz);
            unmarshalRecord = (UnmarshalRecord)xmlDescriptor.getObjectBuilder().createRecord(session);
        }
        try {
            unmarshalRecord.setXMLReader(domReader);
            unmarshalRecord.setUnmarshaller(this.xmlUnmarshaller);
            domReader.setContentHandler(unmarshalRecord);
            domReader.setProperty("http://xml.org/sax/properties/lexical-handler", unmarshalRecord);
            domReader.parse(node);
        }
        catch (SAXException e) {
            throw this.convertSAXException(e);
        }
        this.xmlUnmarshaller.resolveReferences(session);
        if (isPrimitiveWrapper) {
            return unmarshalRecord.getCurrentObject();
        }
        return xmlDescriptor.wrapObjectInXMLRoot(unmarshalRecord, this.isResultAlwaysXMLRoot);
    }

    @Override
    public Object unmarshal(Reader reader) {
        if (this.xmlUnmarshaller.getXMLContext().hasDocumentPreservation()) {
            Element domElement = this.xmlParser.parse(reader).getDocumentElement();
            return this.unmarshal(domElement);
        }
        InputSource inputSource = new InputSource(reader);
        return this.unmarshal(inputSource);
    }

    @Override
    public Object unmarshal(Reader reader, Class clazz) {
        if (this.xmlUnmarshaller.getXMLContext().hasDocumentPreservation()) {
            Element domElement = this.xmlParser.parse(reader).getDocumentElement();
            return this.unmarshal(domElement, clazz);
        }
        InputSource inputSource = new InputSource(reader);
        return this.unmarshal(inputSource, clazz);
    }

    @Override
    public Object unmarshal(Source source) {
        if (source instanceof SAXSource) {
            SAXSource saxSource = (SAXSource)source;
            XMLReader xmlReader = null;
            if (saxSource.getXMLReader() != null) {
                xmlReader = new XMLReader(saxSource.getXMLReader());
            }
            if (null == xmlReader) {
                return this.unmarshal(saxSource.getInputSource());
            }
            return this.unmarshal(saxSource.getInputSource(), xmlReader);
        }
        if (source instanceof DOMSource) {
            DOMSource domSource = (DOMSource)source;
            return this.unmarshal(domSource.getNode());
        }
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            if (null != streamSource.getReader()) {
                return this.unmarshal(streamSource.getReader());
            }
            if (null != streamSource.getInputStream()) {
                return this.unmarshal(streamSource.getInputStream());
            }
            return this.unmarshal(streamSource.getSystemId());
        }
        XMLUnmarshallerHandler handler = this.xmlUnmarshaller.getUnmarshallerHandler();
        XMLTransformer transformer = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLTransformer();
        SAXResult result = new SAXResult(handler);
        transformer.transform(source, (Result)result);
        return handler.getResult();
    }

    @Override
    public Object unmarshal(Source source, Class clazz) {
        if (source instanceof SAXSource) {
            SAXSource saxSource = (SAXSource)source;
            XMLReader xmlReader = null;
            if (saxSource.getXMLReader() != null) {
                xmlReader = new XMLReader(saxSource.getXMLReader());
            }
            if (null == saxSource.getXMLReader()) {
                return this.unmarshal(saxSource.getInputSource(), clazz);
            }
            return this.unmarshal(saxSource.getInputSource(), clazz, xmlReader);
        }
        if (source instanceof DOMSource) {
            DOMSource domSource = (DOMSource)source;
            return this.unmarshal(domSource.getNode(), clazz);
        }
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            if (null != streamSource.getReader()) {
                return this.unmarshal(streamSource.getReader(), clazz);
            }
            if (null != streamSource.getInputStream()) {
                return this.unmarshal(streamSource.getInputStream(), clazz);
            }
            return this.unmarshal(streamSource.getSystemId(), clazz);
        }
        DOMResult result = new DOMResult();
        XMLTransformer transformer = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLTransformer();
        transformer.transform(source, (Result)result);
        return this.unmarshal(result.getNode(), clazz);
    }

    @Override
    public Object unmarshal(URL url) {
        InputStream inputStream = null;
        try {
            inputStream = url.openStream();
        }
        catch (IOException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        boolean hasThrownException = false;
        try {
            Object object = this.unmarshal(inputStream);
            return object;
        }
        catch (RuntimeException runtimeException) {
            hasThrownException = true;
            throw runtimeException;
        }
        finally {
            block11: {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    if (hasThrownException) break block11;
                    throw XMLMarshalException.unmarshalException(e);
                }
            }
        }
    }

    @Override
    public Object unmarshal(URL url, Class clazz) {
        try {
            InputStream inputStream = url.openStream();
            Object result = this.unmarshal(inputStream, clazz);
            inputStream.close();
            return result;
        }
        catch (IOException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
    }

    public Object unmarshal(String systemId) {
        try {
            SAXUnmarshallerHandler saxUnmarshallerHandler = new SAXUnmarshallerHandler(this.xmlUnmarshaller.getXMLContext());
            saxUnmarshallerHandler.setXMLReader(this.xmlReader);
            saxUnmarshallerHandler.setUnmarshaller(this.xmlUnmarshaller);
            this.xmlReader.setContentHandler(saxUnmarshallerHandler);
            this.xmlReader.parse(systemId);
            saxUnmarshallerHandler.resolveReferences();
            return saxUnmarshallerHandler.getObject();
        }
        catch (IOException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        catch (SAXException e) {
            throw this.convertSAXException(e);
        }
    }

    public Object unmarshal(String systemId, Class clazz) {
        UnmarshalRecord unmarshalRecord;
        boolean isPrimitiveWrapper = this.isPrimitiveWrapper(clazz);
        XMLDescriptor xmlDescriptor = null;
        AbstractSession session = null;
        if (isPrimitiveWrapper) {
            unmarshalRecord = new XMLRootRecord(clazz);
        } else {
            if (clazz == ClassConstants.OBJECT) {
                SAXUnmarshallerHandler saxUnmarshallerHandler = new SAXUnmarshallerHandler(this.xmlUnmarshaller.getXMLContext());
                try {
                    saxUnmarshallerHandler.setXMLReader(this.xmlReader);
                    saxUnmarshallerHandler.setUnmarshaller(this.xmlUnmarshaller);
                    saxUnmarshallerHandler.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
                    this.xmlReader.setContentHandler(saxUnmarshallerHandler);
                    this.xmlReader.parse(systemId);
                }
                catch (IOException e) {
                    throw XMLMarshalException.unmarshalException(e);
                }
                catch (SAXException e) {
                    throw this.convertSAXException(e);
                }
                saxUnmarshallerHandler.resolveReferences();
                return saxUnmarshallerHandler.getObject();
            }
            session = this.xmlUnmarshaller.getXMLContext().getReadSession(clazz);
            xmlDescriptor = (XMLDescriptor)session.getDescriptor(clazz);
            unmarshalRecord = (UnmarshalRecord)xmlDescriptor.getObjectBuilder().createRecord(session);
        }
        try {
            unmarshalRecord.setXMLReader(this.xmlReader);
            unmarshalRecord.setUnmarshaller(this.xmlUnmarshaller);
            this.xmlReader.setContentHandler(unmarshalRecord);
            try {
                unmarshalRecord.getXMLReader().setProperty("http://xml.org/sax/properties/lexical-handler", unmarshalRecord);
            }
            catch (SAXNotRecognizedException ex) {
            }
            catch (SAXNotSupportedException ex) {
                // empty catch block
            }
            this.xmlReader.parse(systemId);
        }
        catch (IOException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        catch (SAXException e) {
            throw this.convertSAXException(e);
        }
        this.xmlUnmarshaller.resolveReferences(session);
        if (isPrimitiveWrapper) {
            return unmarshalRecord.getCurrentObject();
        }
        return xmlDescriptor.wrapObjectInXMLRoot(unmarshalRecord, this.isResultAlwaysXMLRoot);
    }

    @Override
    public Object unmarshal(org.xml.sax.XMLReader xmlReader, InputSource inputSource) {
        try {
            XMLContext xmlContext = this.xmlUnmarshaller.getXMLContext();
            if (xmlContext.hasDocumentPreservation()) {
                SAXDocumentBuilder saxDocumentBuilder = new SAXDocumentBuilder();
                xmlReader.setContentHandler(saxDocumentBuilder);
                xmlReader.parse(inputSource);
                return this.unmarshal(saxDocumentBuilder.getDocument().getDocumentElement());
            }
            XMLReader extendedXMLReader = xmlReader instanceof XMLReader ? (XMLReader)xmlReader : new XMLReader(xmlReader);
            SAXUnmarshallerHandler saxUnmarshallerHandler = new SAXUnmarshallerHandler(xmlContext);
            saxUnmarshallerHandler.setXMLReader(extendedXMLReader);
            saxUnmarshallerHandler.setUnmarshaller(this.xmlUnmarshaller);
            extendedXMLReader.setContentHandler(saxUnmarshallerHandler);
            extendedXMLReader.parse(inputSource);
            saxUnmarshallerHandler.resolveReferences();
            return saxUnmarshallerHandler.getObject();
        }
        catch (IOException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        catch (SAXException e) {
            throw this.convertSAXException(e);
        }
    }

    @Override
    public Object unmarshal(org.xml.sax.XMLReader xmlReader, InputSource inputSource, Class clazz) {
        try {
            UnmarshalRecord unmarshalRecord;
            XMLContext xmlContext = this.xmlUnmarshaller.getXMLContext();
            if (xmlContext.hasDocumentPreservation()) {
                SAXDocumentBuilder saxDocumentBuilder = new SAXDocumentBuilder();
                xmlReader.setContentHandler(saxDocumentBuilder);
                xmlReader.parse(inputSource);
                return this.unmarshal(saxDocumentBuilder.getDocument().getDocumentElement(), clazz);
            }
            boolean isPrimitiveWrapper = this.isPrimitiveWrapper(clazz);
            XMLDescriptor xmlDescriptor = null;
            AbstractSession session = null;
            if (isPrimitiveWrapper) {
                unmarshalRecord = new XMLRootRecord(clazz);
                unmarshalRecord.setSession((AbstractSession)((Object)this.xmlUnmarshaller.getXMLContext().getSession(0)));
            } else {
                if (clazz == ClassConstants.OBJECT) {
                    SAXUnmarshallerHandler saxUnmarshallerHandler = new SAXUnmarshallerHandler(this.xmlUnmarshaller.getXMLContext());
                    saxUnmarshallerHandler.setXMLReader((XMLReader)xmlReader);
                    saxUnmarshallerHandler.setUnmarshaller(this.xmlUnmarshaller);
                    saxUnmarshallerHandler.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
                    xmlReader.setContentHandler(saxUnmarshallerHandler);
                    xmlReader.parse(inputSource);
                    saxUnmarshallerHandler.resolveReferences();
                    return saxUnmarshallerHandler.getObject();
                }
                session = xmlContext.getReadSession(clazz);
                xmlDescriptor = (XMLDescriptor)session.getDescriptor(clazz);
                unmarshalRecord = (UnmarshalRecord)xmlDescriptor.getObjectBuilder().createRecord(session);
            }
            XMLReader extendedXMLReader = xmlReader instanceof XMLReader ? (XMLReader)xmlReader : new XMLReader(xmlReader);
            unmarshalRecord.setXMLReader(extendedXMLReader);
            unmarshalRecord.setUnmarshaller(this.xmlUnmarshaller);
            extendedXMLReader.setContentHandler(unmarshalRecord);
            try {
                extendedXMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", unmarshalRecord);
            }
            catch (SAXNotRecognizedException ex) {
            }
            catch (SAXNotSupportedException ex) {
                // empty catch block
            }
            extendedXMLReader.parse(inputSource);
            this.xmlUnmarshaller.resolveReferences(session);
            if (isPrimitiveWrapper || clazz == ClassConstants.OBJECT) {
                return unmarshalRecord.getCurrentObject();
            }
            return xmlDescriptor.wrapObjectInXMLRoot(unmarshalRecord, this.isResultAlwaysXMLRoot);
        }
        catch (IOException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        catch (SAXException e) {
            throw this.convertSAXException(e);
        }
    }

    private EclipseLinkException convertSAXException(SAXException saxException) {
        Exception internalException = saxException.getException();
        if (internalException != null) {
            if (EclipseLinkException.class.isAssignableFrom(internalException.getClass())) {
                return (EclipseLinkException)internalException;
            }
            return XMLMarshalException.unmarshalException(internalException);
        }
        return XMLMarshalException.unmarshalException(saxException);
    }

    @Override
    public boolean isResultAlwaysXMLRoot() {
        return this.isResultAlwaysXMLRoot;
    }

    @Override
    public void setResultAlwaysXMLRoot(boolean alwaysReturnRoot) {
        this.isResultAlwaysXMLRoot = alwaysReturnRoot;
    }

    private boolean isPrimitiveWrapper(Class clazz) {
        return XMLConversionManager.getDefaultJavaTypes().get(clazz) != null || ClassConstants.XML_GREGORIAN_CALENDAR.isAssignableFrom(clazz) || ClassConstants.DURATION.isAssignableFrom(clazz);
    }
}

