/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.v3.services.impl.GrizzlyProxy;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import com.sun.grizzly.config.dom.FileCache;
import com.sun.grizzly.config.dom.Http;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.Ssl;
import com.sun.grizzly.config.dom.ThreadPool;
import com.sun.grizzly.config.dom.Transport;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicConfigListener
implements ConfigListener {
    private GrizzlyService grizzlyService;
    private Logger logger;

    @Override
    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        UnprocessedChangeEvents unp = ConfigSupport.sortAndDispatch(events, new Changed(){

            @Override
            public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> tClass, T t) {
                if (DynamicConfigListener.this.logger.isLoggable(Level.FINE)) {
                    DynamicConfigListener.this.logger.log(Level.FINE, "NetworkConfig changed " + (Object)((Object)type) + " " + tClass + " " + t);
                }
                if (t instanceof NetworkListener) {
                    return DynamicConfigListener.this.processNetworkListener(type, (NetworkListener)t);
                }
                if (t instanceof Http) {
                    return DynamicConfigListener.this.processProtocol(type, (Protocol)((Http)t).getParent());
                }
                if (t instanceof FileCache) {
                    return DynamicConfigListener.this.processProtocol(type, (Protocol)((FileCache)t).getParent().getParent());
                }
                if (t instanceof Ssl) {
                    return DynamicConfigListener.this.processProtocol(type, (Protocol)((Ssl)t).getParent());
                }
                if (t instanceof Protocol) {
                    return DynamicConfigListener.this.processProtocol(type, (Protocol)t);
                }
                if (t instanceof ThreadPool) {
                    ThreadPool pool = (ThreadPool)t;
                    NotProcessed notProcessed = null;
                    for (NetworkListener listener : pool.findNetworkListeners()) {
                        notProcessed = DynamicConfigListener.this.processNetworkListener(type, listener);
                    }
                    return notProcessed;
                }
                if (t instanceof Transport) {
                    Transport transport = (Transport)t;
                    NotProcessed notProcessed = null;
                    for (NetworkListener listener : transport.findNetworkListeners()) {
                        notProcessed = DynamicConfigListener.this.processNetworkListener(type, listener);
                    }
                    return notProcessed;
                }
                if (t instanceof VirtualServer && !DynamicConfigListener.this.grizzlyService.hasMapperUpdateListener()) {
                    return DynamicConfigListener.this.processVirtualServer(type, (VirtualServer)t);
                }
                return null;
            }
        }, this.logger);
        return unp;
    }

    private <T extends ConfigBeanProxy> NotProcessed processNetworkListener(Changed.TYPE type, NetworkListener listener) {
        if (!"admin-listener".equals(listener.getName())) {
            int listenerPort = -1;
            try {
                listenerPort = Integer.parseInt(listener.getPort());
            }
            catch (NumberFormatException e) {
                this.logger.log(Level.WARNING, "Can not parse network-listener port number: " + listener.getPort());
            }
            if (type == Changed.TYPE.ADD) {
                this.grizzlyService.createNetworkProxy(listener);
                this.grizzlyService.registerNetworkProxy(listenerPort);
            } else if (type == Changed.TYPE.REMOVE) {
                this.grizzlyService.removeNetworkProxy(listenerPort);
            } else if (type == Changed.TYPE.CHANGE) {
                boolean isRemovedOld = this.grizzlyService.removeNetworkProxy(listenerPort) || this.grizzlyService.removeNetworkProxy(listener.getName());
                this.grizzlyService.createNetworkProxy(listener);
                this.grizzlyService.registerNetworkProxy(listenerPort);
            }
        }
        return null;
    }

    private NotProcessed processProtocol(Changed.TYPE type, Protocol protocol) {
        NotProcessed notProcessed = null;
        for (NetworkListener listener : protocol.findNetworkListeners()) {
            notProcessed = this.processNetworkListener(type, listener);
        }
        return notProcessed;
    }

    private NotProcessed processVirtualServer(Changed.TYPE type, VirtualServer vs) {
        NotProcessed notProcessed = null;
        String list = vs.getNetworkListeners();
        Collection nls = this.grizzlyService.getHabitat().getAllByType(NetworkListener.class);
        ArrayList<String> as = GrizzlyProxy.toArray(list, ",");
        for (String s : as) {
            for (NetworkListener n : nls) {
                if (!n.getName().equals(s)) continue;
                notProcessed = this.processNetworkListener(type, n);
            }
        }
        return notProcessed;
    }

    public void setGrizzlyService(GrizzlyService grizzlyService) {
        this.grizzlyService = grizzlyService;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}

