/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.util.LocalStringManagerImpl;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.deployment.admin.ListAppRefsCommand;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="show-component-status")
@Scoped(value=PerLookup.class)
public class ShowComponentStatusCommand
implements AdminCommand {
    @Param(primary=true)
    public String name = null;
    @Param(optional=true)
    String target = "server";
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListAppRefsCommand.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        ActionReport.MessagePart part = report.getTopMessagePart();
        part.setMessage(this.target);
        ApplicationRef appRef = ConfigBeansUtilities.getApplicationRefInServer((String)this.target, (String)this.name);
        if (appRef == null) {
            report.setMessage(localStrings.getLocalString("application.notreg", "Application {0} not registered", new Object[]{this.name}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        String status = "enabled";
        if (!Boolean.valueOf(appRef.getEnabled()).booleanValue()) {
            status = "disabled";
        }
        report.setMessage(localStrings.getLocalString("component.status", "Status of {0} is {1}.", new Object[]{this.name, status}));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

