/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.impl;

import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.annotation.impl.ModuleScanner;
import com.sun.enterprise.deployment.deploy.shared.InputJarArchive;
import com.sun.enterprise.deployment.deploy.shared.MultiReadableArchive;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import javax.annotation.ManagedBean;
import org.glassfish.apf.impl.AnnotationUtils;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.GenericAnnotationDetector;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="car")
@Scoped(value=PerLookup.class)
public class AppClientScanner
extends ModuleScanner<ApplicationClientDescriptor> {
    private ApplicationClientDescriptor descriptor;
    private static final Class[] managedBeanAnnotations = new Class[]{ManagedBean.class};

    @Override
    public void process(ReadableArchive archive, ApplicationClientDescriptor bundleDesc, ClassLoader classLoader) throws IOException {
        this.doProcess(archive, bundleDesc, classLoader);
        this.completeProcess(bundleDesc, archive);
    }

    public void process(File archiveFile, ApplicationClientDescriptor bundleDesc, ClassLoader classLoader) throws IOException {
        throw new UnsupportedOperationException("Not supported.");
    }

    private void doProcess(ReadableArchive archive, ApplicationClientDescriptor desc, ClassLoader classLoader) throws IOException {
        GenericAnnotationDetector detector;
        if (AnnotationUtils.getLogger().isLoggable(Level.FINE)) {
            AnnotationUtils.getLogger().fine("archiveFile is " + archive.getURI().toASCIIString());
            AnnotationUtils.getLogger().fine("classLoader is " + classLoader);
        }
        this.descriptor = desc;
        String mainClassName = desc.getMainClassName();
        this.addScanClassName(mainClassName);
        String callbackHandler = desc.getCallbackHandler();
        if (callbackHandler != null && !callbackHandler.trim().equals("")) {
            this.addScanClassName(desc.getCallbackHandler());
        }
        if ((detector = new GenericAnnotationDetector(managedBeanAnnotations)).hasAnnotationInArchive(archive)) {
            if (archive instanceof FileArchive) {
                this.addScanDirectory(new File(archive.getURI()));
            } else if (archive instanceof InputJarArchive) {
                URI uriToAdd = archive.getURI();
                this.addScanJar(this.scanJar(uriToAdd));
            } else if (archive instanceof MultiReadableArchive) {
                this.addScanJar(this.scanJar(((MultiReadableArchive)archive).getURI(1)));
            }
        }
        this.classLoader = classLoader;
        this.archiveFile = null;
    }

    private File scanJar(URI uriToAdd) throws IOException {
        if (uriToAdd.getScheme().equals("jar")) {
            try {
                uriToAdd = new URI("file", uriToAdd.getSchemeSpecificPart(), null);
            }
            catch (URISyntaxException ex) {
                throw new IOException(ex);
            }
        }
        return new File(uriToAdd);
    }
}

