/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ssl;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Iterator;
import javax.net.ssl.X509TrustManager;

public class UnifiedX509TrustManager
implements X509TrustManager {
    private X509TrustManager[] mgrs = null;
    private X509Certificate[] issuers = new X509Certificate[0];

    public UnifiedX509TrustManager(X509TrustManager[] mgrs) {
        if (mgrs == null) {
            throw new IllegalArgumentException("Null array of X509TrustManagers");
        }
        this.mgrs = mgrs;
        HashSet<X509Certificate> tset = new HashSet<X509Certificate>();
        for (int i = 0; i < mgrs.length; ++i) {
            X509Certificate[] tcerts = mgrs[i].getAcceptedIssuers();
            if (tcerts == null || tcerts.length <= 0) continue;
            for (int j = 0; j < tcerts.length; ++j) {
                tset.add(tcerts[j]);
            }
        }
        this.issuers = new X509Certificate[tset.size()];
        Iterator iter = tset.iterator();
        int i = 0;
        while (iter.hasNext()) {
            this.issuers[i] = (X509Certificate)iter.next();
            ++i;
        }
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        CertificateException cex = null;
        for (int i = 0; i < this.mgrs.length; ++i) {
            try {
                cex = null;
                this.mgrs[i].checkClientTrusted(chain, authType);
                break;
            }
            catch (CertificateException ex) {
                cex = ex;
                continue;
            }
        }
        if (cex != null) {
            throw cex;
        }
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        CertificateException cex = null;
        for (int i = 0; i < this.mgrs.length; ++i) {
            try {
                cex = null;
                this.mgrs[i].checkServerTrusted(chain, authType);
                break;
            }
            catch (CertificateException ex) {
                cex = ex;
                continue;
            }
        }
        if (cex != null) {
            throw cex;
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.issuers;
    }
}

