/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.cometd.bayeux;

import com.sun.grizzly.cometd.bayeux.Advice;
import com.sun.grizzly.cometd.bayeux.ConnectRequest;
import com.sun.grizzly.cometd.bayeux.ConnectResponse;
import com.sun.grizzly.cometd.bayeux.Data;
import com.sun.grizzly.cometd.bayeux.DeliverResponse;
import com.sun.grizzly.cometd.bayeux.DisconnectRequest;
import com.sun.grizzly.cometd.bayeux.DisconnectResponse;
import com.sun.grizzly.cometd.bayeux.Ext;
import com.sun.grizzly.cometd.bayeux.HandshakeRequest;
import com.sun.grizzly.cometd.bayeux.HandshakeResponse;
import com.sun.grizzly.cometd.bayeux.Ping;
import com.sun.grizzly.cometd.bayeux.PublishRequest;
import com.sun.grizzly.cometd.bayeux.PublishResponse;
import com.sun.grizzly.cometd.bayeux.ReconnectRequest;
import com.sun.grizzly.cometd.bayeux.ReconnectResponse;
import com.sun.grizzly.cometd.bayeux.Status;
import com.sun.grizzly.cometd.bayeux.SubscribeRequest;
import com.sun.grizzly.cometd.bayeux.SubscribeResponse;
import com.sun.grizzly.cometd.bayeux.UnsubscribeRequest;
import com.sun.grizzly.cometd.bayeux.UnsubscribeResponse;
import com.sun.grizzly.cometd.bayeux.Verb;
import com.sun.grizzly.cometd.bayeux.VerbBase;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerbUtils {
    private static final String HANDSHAKE = "/meta/handshake";
    private static final String CONNECT = "/meta/connect";
    private static final String DISCONNECT = "/meta/disconnect";
    private static final String RECONNECT = "/meta/reconnect";
    private static final String SUBSCRIBE = "/meta/subscribe";
    private static final String UNSUBSCRIBE = "/meta/unsubscribe";
    private static final String STATUS = "/status";
    private static final String PING = "/ping";
    private static final String DATA = "data";

    public static List<Verb> parseRequest(Object verb) {
        return VerbUtils.parse(verb, true);
    }

    public static List<Verb> parseResponse(Object verb) {
        return VerbUtils.parse(verb, false);
    }

    private static List<Verb> parse(Object verb, boolean isRequest) {
        ArrayList<Verb> verbs = new ArrayList<Verb>();
        VerbBase wellFormedVerb = null;
        if (verb.getClass().isArray()) {
            int length = Array.getLength(verb);
            for (int i = 0; i < length; ++i) {
                wellFormedVerb = VerbUtils.parseMap((Map)Array.get(verb, i), isRequest);
                if (wellFormedVerb == null) {
                    throw new RuntimeException("Wrong type");
                }
                if (i == 0) {
                    wellFormedVerb.setFirst(true);
                } else {
                    wellFormedVerb.setFollow(true);
                }
                verbs.add(wellFormedVerb);
            }
            wellFormedVerb.setLast(true);
        } else {
            wellFormedVerb = VerbUtils.parseMap((Map)verb, isRequest);
            if (wellFormedVerb == null) {
                throw new RuntimeException("Wrong type");
            }
            wellFormedVerb.setFirst(true);
            wellFormedVerb.setLast(true);
            verbs.add(wellFormedVerb);
        }
        return verbs;
    }

    protected static VerbBase parseMap(Map map, boolean isRequest) {
        String channel = (String)map.get("channel");
        VerbBase vb = null;
        vb = channel.indexOf(HANDSHAKE) != -1 ? (isRequest ? VerbUtils.newHandshakeRequest(map) : VerbUtils.newHandshakeResponse(map)) : (channel.indexOf(CONNECT) != -1 ? (isRequest ? VerbUtils.newConnectRequest(map) : VerbUtils.newConnectResponse(map)) : (channel.indexOf(DISCONNECT) != -1 ? (isRequest ? VerbUtils.newDisconnectRequest(map) : VerbUtils.newDisconnectResponse(map)) : (channel.indexOf(RECONNECT) != -1 ? (isRequest ? VerbUtils.newReconnectRequest(map) : VerbUtils.newReconnectResponse(map)) : (channel.indexOf(SUBSCRIBE) != -1 ? (isRequest ? VerbUtils.newSubscribeRequest(map) : VerbUtils.newSubscribeResponse(map)) : (channel.indexOf(UNSUBSCRIBE) != -1 ? (isRequest ? VerbUtils.newUnsubscribeRequest(map) : VerbUtils.newUnsubscribeResponse(map)) : (channel.indexOf(PING) != -1 ? VerbUtils.newPing(map) : (channel.indexOf(STATUS) != -1 ? VerbUtils.newStatus(map) : (isRequest ? VerbUtils.newPublishRequest(map) : (map.get(DATA) != null ? VerbUtils.newDeliverResponse(map) : VerbUtils.newPublishResponse(map))))))))));
        VerbUtils.configureExt(vb, map);
        return vb;
    }

    private static final HandshakeRequest newHandshakeRequest(Map map) {
        HandshakeRequest handshakeReq = new HandshakeRequest();
        handshakeReq.setAuthScheme((String)map.get("authScheme"));
        handshakeReq.setAuthUser((String)map.get("authUser"));
        handshakeReq.setAuthToken((String)map.get("authToken"));
        handshakeReq.setChannel((String)map.get("channel"));
        handshakeReq.setVersion((String)map.get("version"));
        handshakeReq.setMinimumVersion((String)map.get("minimumVersion"));
        handshakeReq.setId((String)map.get("id"));
        handshakeReq.setSupportedConnectionTypes(VerbUtils.getSupportedConnectionTypes(map));
        return handshakeReq;
    }

    private static final HandshakeResponse newHandshakeResponse(Map map) {
        HandshakeResponse handshakeRes = new HandshakeResponse();
        handshakeRes.setAuthScheme((String)map.get("authScheme"));
        handshakeRes.setAuthUser((String)map.get("authUser"));
        handshakeRes.setAuthToken((String)map.get("authToken"));
        handshakeRes.setChannel((String)map.get("channel"));
        handshakeRes.setVersion((String)map.get("version"));
        handshakeRes.setMinimumVersion((String)map.get("minimumVersion"));
        handshakeRes.setId((String)map.get("id"));
        handshakeRes.setSupportedConnectionTypes(VerbUtils.getSupportedConnectionTypes(map));
        handshakeRes.setClientId((String)map.get("clientId"));
        handshakeRes.setSuccessful((Boolean)map.get("successful"));
        handshakeRes.setAuthSuccessful((Boolean)map.get("authSuccessful"));
        handshakeRes.setError((String)map.get("error"));
        VerbUtils.configureAdvice(handshakeRes, map);
        return handshakeRes;
    }

    private static final ConnectRequest newConnectRequest(Map map) {
        ConnectRequest connectReq = new ConnectRequest();
        connectReq.setAuthToken((String)map.get("authToken"));
        connectReq.setChannel((String)map.get("channel"));
        connectReq.setClientId((String)map.get("clientId"));
        connectReq.setConnectionType((String)map.get("connectionType"));
        connectReq.setId((String)map.get("id"));
        return connectReq;
    }

    private static final ConnectResponse newConnectResponse(Map map) {
        ConnectResponse connectRes = new ConnectResponse();
        connectRes.setAuthToken((String)map.get("authToken"));
        connectRes.setChannel((String)map.get("channel"));
        connectRes.setClientId((String)map.get("clientId"));
        connectRes.setId((String)map.get("id"));
        connectRes.setSuccessful((Boolean)map.get("successful"));
        connectRes.setError((String)map.get("error"));
        connectRes.setTimestamp((String)map.get("timestamp"));
        VerbUtils.configureAdvice(connectRes, map);
        return connectRes;
    }

    private static final DisconnectRequest newDisconnectRequest(Map map) {
        DisconnectRequest disconnectReq = new DisconnectRequest();
        disconnectReq.setAuthToken((String)map.get("authToken"));
        disconnectReq.setChannel((String)map.get("channel"));
        disconnectReq.setClientId((String)map.get("clientId"));
        disconnectReq.setId((String)map.get("id"));
        return disconnectReq;
    }

    private static final DisconnectResponse newDisconnectResponse(Map map) {
        DisconnectResponse disconnectRes = new DisconnectResponse();
        disconnectRes.setAuthToken((String)map.get("authToken"));
        disconnectRes.setChannel((String)map.get("channel"));
        disconnectRes.setClientId((String)map.get("clientId"));
        disconnectRes.setId((String)map.get("id"));
        disconnectRes.setSuccessful((Boolean)map.get("successful"));
        disconnectRes.setError((String)map.get("error"));
        VerbUtils.configureAdvice(disconnectRes, map);
        return disconnectRes;
    }

    private static final ReconnectRequest newReconnectRequest(Map map) {
        ReconnectRequest reconnectReq = new ReconnectRequest();
        reconnectReq.setAuthToken((String)map.get("authToken"));
        reconnectReq.setChannel((String)map.get("channel"));
        reconnectReq.setClientId((String)map.get("clientId"));
        reconnectReq.setId((String)map.get("id"));
        return reconnectReq;
    }

    private static final ReconnectResponse newReconnectResponse(Map map) {
        ReconnectResponse reconnectRes = new ReconnectResponse();
        reconnectRes.setAuthToken((String)map.get("authToken"));
        reconnectRes.setChannel((String)map.get("channel"));
        reconnectRes.setClientId((String)map.get("clientId"));
        reconnectRes.setId((String)map.get("id"));
        reconnectRes.setSuccessful((Boolean)map.get("successful"));
        reconnectRes.setError((String)map.get("error"));
        return reconnectRes;
    }

    private static final SubscribeRequest newSubscribeRequest(Map map) {
        SubscribeRequest subscribeReq = new SubscribeRequest();
        subscribeReq.setChannel((String)map.get("channel"));
        subscribeReq.setAuthToken((String)map.get("authToken"));
        subscribeReq.setSubscription((String)map.get("subscription"));
        subscribeReq.setClientId((String)map.get("clientId"));
        subscribeReq.setId((String)map.get("id"));
        return subscribeReq;
    }

    private static final SubscribeResponse newSubscribeResponse(Map map) {
        SubscribeResponse subscribeRes = new SubscribeResponse();
        subscribeRes.setChannel((String)map.get("channel"));
        subscribeRes.setAuthToken((String)map.get("authToken"));
        subscribeRes.setSubscription((String)map.get("subscription"));
        subscribeRes.setClientId((String)map.get("clientId"));
        subscribeRes.setId((String)map.get("id"));
        subscribeRes.setSuccessful((Boolean)map.get("successful"));
        subscribeRes.setError((String)map.get("error"));
        VerbUtils.configureAdvice(subscribeRes, map);
        return subscribeRes;
    }

    private static final UnsubscribeRequest newUnsubscribeRequest(Map map) {
        UnsubscribeRequest unsubscribeReq = new UnsubscribeRequest();
        unsubscribeReq.setChannel((String)map.get("channel"));
        unsubscribeReq.setAuthToken((String)map.get("authToken"));
        unsubscribeReq.setSubscription((String)map.get("subscription"));
        unsubscribeReq.setClientId((String)map.get("clientId"));
        unsubscribeReq.setId((String)map.get("id"));
        return unsubscribeReq;
    }

    private static final UnsubscribeResponse newUnsubscribeResponse(Map map) {
        UnsubscribeResponse unsubscribeRes = new UnsubscribeResponse();
        unsubscribeRes.setChannel((String)map.get("channel"));
        unsubscribeRes.setAuthToken((String)map.get("authToken"));
        unsubscribeRes.setSubscription((String)map.get("subscription"));
        unsubscribeRes.setClientId((String)map.get("clientId"));
        unsubscribeRes.setId((String)map.get("id"));
        unsubscribeRes.setSuccessful((Boolean)map.get("successful"));
        unsubscribeRes.setError((String)map.get("error"));
        unsubscribeRes.setTimestamp((String)map.get("timestamp"));
        VerbUtils.configureAdvice(unsubscribeRes, map);
        return unsubscribeRes;
    }

    private static final Ping newPing(Map map) {
        Ping ping = new Ping();
        ping.setChannel((String)map.get("channel"));
        return ping;
    }

    private static final Status newStatus(Map map) {
        Status status = new Status();
        status.setChannel((String)map.get("channel"));
        return status;
    }

    private static final PublishRequest newPublishRequest(Map map) {
        PublishRequest publishReq = new PublishRequest();
        Map mapData = (Map)map.get(DATA);
        Data data = new Data();
        data.setMapData(mapData);
        publishReq.setChannel((String)map.get("channel"));
        publishReq.setData(data);
        publishReq.setClientId((String)map.get("clientId"));
        publishReq.setId((String)map.get("id"));
        return publishReq;
    }

    private static final PublishResponse newPublishResponse(Map map) {
        PublishResponse publishRes = new PublishResponse();
        publishRes.setChannel((String)map.get("channel"));
        publishRes.setClientId((String)map.get("clientId"));
        publishRes.setId((String)map.get("id"));
        publishRes.setError((String)map.get("error"));
        publishRes.setSuccessful((Boolean)map.get("successful"));
        return publishRes;
    }

    private static final DeliverResponse newDeliverResponse(Map map) {
        DeliverResponse deliverRes = new DeliverResponse();
        Map mapData = (Map)map.get(DATA);
        Data data = new Data();
        data.setMapData(mapData);
        deliverRes.setChannel((String)map.get("channel"));
        deliverRes.setData(data);
        deliverRes.setClientId((String)map.get("clientId"));
        deliverRes.setId((String)map.get("id"));
        VerbUtils.configureAdvice(deliverRes, map);
        return deliverRes;
    }

    private static void configureExt(VerbBase vb, Map map) {
        Map extMap = (Map)map.get("ext");
        if (extMap == null) {
            return;
        }
        Ext ext = new Ext();
        ext.setExtensionMap(extMap);
        vb.setExt(ext);
    }

    private static void configureAdvice(VerbBase vb, Map map) {
        String[] hosts;
        Boolean multipleClients;
        Integer interval;
        Map adviceMap = (Map)map.get("advice");
        if (adviceMap == null) {
            return;
        }
        Advice advice = new Advice();
        String reconnect = (String)adviceMap.get("reconnect");
        if (reconnect != null) {
            advice.setReconnect(reconnect);
        }
        if ((interval = new Integer(((Number)adviceMap.get("interval")).intValue())) != null) {
            advice.setInterval(interval);
        }
        if ((multipleClients = (Boolean)adviceMap.get("multiple-clients")) != null) {
            advice.setMultipleClients(multipleClients);
        }
        if ((hosts = (String[])adviceMap.get("hosts")) != null) {
            advice.setHosts(hosts);
        }
        vb.setAdvice(advice);
    }

    private static String[] getSupportedConnectionTypes(Map map) {
        String[] types = null;
        Object[] typeObjs = (Object[])map.get("supportedConnectionTypes");
        if (typeObjs != null) {
            types = new String[typeObjs.length];
            for (int i = 0; i < typeObjs.length; ++i) {
                types[i] = (String)typeObjs[i];
            }
        }
        return types;
    }
}

