/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core.jws;

import com.sun.enterprise.config.serverbeans.IiopListener;
import com.sun.enterprise.config.serverbeans.IiopService;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.grizzly.util.http.MimeType;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.appclient.server.core.jws.LoaderConfigContent;
import org.glassfish.appclient.server.core.jws.RestrictedContentAdapter;
import org.glassfish.appclient.server.core.jws.Util;
import org.glassfish.appclient.server.core.jws.servedcontent.ACCConfigContent;
import org.glassfish.appclient.server.core.jws.servedcontent.DynamicContent;
import org.glassfish.appclient.server.core.jws.servedcontent.StaticContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppClientHTTPAdapter
extends RestrictedContentAdapter {
    private static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
    private static final String ARG_QUERY_PARAM_NAME = "arg";
    private static final String PROP_QUERY_PARAM_NAME = "prop";
    private static final String VMARG_QUERY_PARAM_NAME = "vmarg";
    private static final String ACC_ARG_QUERY_PARAM_NAME = "accarg";
    private static final String DEFAULT_ORB_LISTENER_ID = "orb-listener-1";
    private final String LINE_SEP = System.getProperty("line.separator");
    private final Logger logger = LogDomains.getLogger(((Object)((Object)this)).getClass(), (String)"javax.enterprise.system.container.appclient");
    private final Map<String, DynamicContent> dynamicContent;
    private final Properties tokens;
    private final IiopService iiopService;
    private final ACCConfigContent accConfigContent;
    private final LoaderConfigContent loaderConfigContent;

    public AppClientHTTPAdapter(String contextRoot, Map<String, StaticContent> staticContent, Map<String, DynamicContent> dynamicContent, Properties tokens, File domainDir, File installDir, IiopService iiopService) throws IOException {
        super(contextRoot, staticContent);
        this.dynamicContent = dynamicContent;
        this.tokens = tokens;
        this.iiopService = iiopService;
        this.accConfigContent = new ACCConfigContent(new File(domainDir, "config"), new File(new File(installDir, "lib"), "appclient"));
        this.loaderConfigContent = new LoaderConfigContent(installDir);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(this.dumpContent());
        }
    }

    @Override
    public void service(GrizzlyRequest gReq, GrizzlyResponse gResp) {
        String relativeURIString = this.relativizeURIString(this.contextRoot(), gReq.getRequestURI());
        if (relativeURIString == null) {
            this.respondNotFound(gResp);
        } else {
            if (this.dynamicContent.containsKey(relativeURIString)) {
                try {
                    this.processDynamicContent(this.tokens, relativeURIString, gReq, gResp);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            try {
                if (!this.serviceContent(gReq, gResp)) {
                    this.respondNotFound(gResp);
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public void addContentIfAbsent(Map<String, StaticContent> staticAdditions, Map<String, DynamicContent> dynamicAdditions) throws IOException {
        this.addContentIfAbsent(staticAdditions);
        this.addDynamicContentIfAbsent(dynamicAdditions);
    }

    private void addDynamicContentIfAbsent(Map<String, DynamicContent> additions) {
        for (Map.Entry<String, DynamicContent> entry : additions.entrySet()) {
            this.addContentIfAbsent(entry.getKey(), entry.getValue());
        }
    }

    private void addContentIfAbsent(String relativeURIString, DynamicContent addition) {
        if (!this.dynamicContent.containsKey(relativeURIString)) {
            this.dynamicContent.put(relativeURIString, addition);
        }
    }

    private void processDynamicContent(Properties tokens, String relativeURIString, GrizzlyRequest gReq, GrizzlyResponse gResp) throws IOException {
        DynamicContent dc = this.dynamicContent.get(relativeURIString);
        if (dc == null) {
            this.respondNotFound(gResp);
            this.logger.fine(this.logPrefix() + "Could not find dynamic content requested using " + relativeURIString);
            return;
        }
        if (!dc.isAvailable()) {
            this.finishErrorResponse(gResp, this.contentStateToResponseStatus(dc));
            this.logger.fine(this.logPrefix() + "Found dynamic content (" + relativeURIString + " but is is not marked as available");
            return;
        }
        Properties allTokens = null;
        try {
            allTokens = this.prepareRequestPlaceholders(tokens, gReq);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "prepareRequestPlaceholder", e);
            this.finishErrorResponse(gResp, 500);
        }
        DynamicContent.Instance instance = dc.getOrCreateInstance(allTokens);
        Date instanceTimestamp = instance.getTimestamp();
        if (this.returnIfClientCacheIsCurrent(relativeURIString, gReq, instanceTimestamp.getTime())) {
            return;
        }
        gResp.setDateHeader("Last-Modified", instanceTimestamp.getTime());
        gResp.setDateHeader("Date", System.currentTimeMillis());
        gResp.setContentType(dc.getMimeType());
        gResp.setStatus(200);
        String methodType = gReq.getMethod();
        if (methodType.equalsIgnoreCase("GET")) {
            this.writeData(instance.getText(), gResp);
        }
        this.logger.fine(this.logPrefix() + "Served dyn content for " + methodType + ": " + relativeURIString + (this.logger.isLoggable(Level.FINER) ? "->" + instance.getText() : ""));
        this.finishResponse(gResp, 200);
    }

    private Properties prepareRequestPlaceholders(Properties adapterTokens, GrizzlyRequest request) throws FileNotFoundException, IOException {
        Properties answer = new Properties(adapterTokens);
        answer.setProperty("request.scheme", request.getScheme());
        answer.setProperty("request.host", request.getServerName());
        answer.setProperty("request.port", Integer.toString(request.getServerPort()));
        answer.setProperty("request.adapter.context.root", this.contextRoot());
        answer.setProperty("request.sun-ac.xml.content", Util.toXMLEscaped(this.accConfigContent.sunACC()));
        answer.setProperty("request.appclient.login.conf.content", Util.toXMLEscaped(this.accConfigContent.appClientLogin()));
        answer.setProperty("request.message.security.config.provider.security.config", Util.toXMLEscaped(this.accConfigContent.securityConfig()));
        answer.setProperty("loader.config", Util.toXMLEscaped(this.loaderConfigContent.content()));
        answer.setProperty("request.iiop.properties", this.buildIIOPProperties());
        String queryString = request.getQueryString();
        StringBuilder queryStringPropValue = new StringBuilder();
        if (queryString != null && queryString.length() > 0) {
            queryStringPropValue.append("?").append(queryString);
        }
        answer.setProperty("request.query.string", queryStringPropValue.toString());
        this.processQueryParameters(queryString, answer);
        return answer;
    }

    private String buildIIOPProperties() {
        StringBuilder sb = new StringBuilder();
        String indent = "        ";
        for (IiopListener listener : this.iiopService.getIiopListener()) {
            String propPrefix = "appclient.iiop.listener." + listener.getId() + ".";
            sb.append(this.propertyDef("        ", propPrefix + "port", listener.getPort()));
            sb.append(this.propertyDef("        ", propPrefix + "isSecure", listener.getSecurityEnabled()));
        }
        return sb.toString();
    }

    private String propertyDef(String indent, String name, String value) {
        return indent + "<property name=\"" + name + "\" value=\"" + value + "\"/>" + this.LINE_SEP;
    }

    private String getPathInfo(GrizzlyRequest gReq) {
        return gReq.getRequestURI();
    }

    private String targetServerSetting(Properties props) {
        String port = null;
        for (IiopListener listener : this.iiopService.getIiopListener()) {
            if (!listener.getId().equals(DEFAULT_ORB_LISTENER_ID)) continue;
            port = listener.getPort();
            break;
        }
        return props.getProperty("request.host") + ":" + port;
    }

    private void processQueryParameters(String queryString, Properties answer) {
        if (queryString == null) {
            queryString = "";
        }
        String[] queryParams = null;
        try {
            queryParams = URLDecoder.decode(queryString, "UTF-8").split("&");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        ArgQueryParams arguments = new ArgQueryParams();
        PropQueryParams properties = new PropQueryParams();
        VMArgQueryParams vmArguments = new VMArgQueryParams();
        ACCArgQueryParams accArguments = new ACCArgQueryParams(this.targetServerSetting(answer));
        QueryParams[] paramTypes = new QueryParams[]{arguments, properties, vmArguments, accArguments};
        for (String param : queryParams) {
            for (QueryParams qpType : paramTypes) {
                if (qpType.processParameter(param)) break;
            }
        }
        answer.setProperty("request.arguments", ((QueryParams)arguments).toString());
        answer.setProperty("request.properties", ((QueryParams)properties).toString());
        answer.setProperty("request.vmargs", ((QueryParams)vmArguments).toString());
        answer.setProperty("request.extra.agent.args", ((QueryParams)accArguments).toString());
    }

    private void writeData(String data, GrizzlyResponse res) {
        try {
            res.setStatus(200);
            res.setContentLength(data.length());
            res.getResponse().sendHeaders();
            PrintWriter pw = res.getWriter();
            pw.println(data);
            pw.flush();
        }
        catch (Exception e) {
            res.setStatus(500);
            res.getResponse().setErrorException(e);
            return;
        }
    }

    private String mimeType(String uri) {
        int dot = uri.lastIndexOf(".");
        if (dot > 0) {
            String ext = uri.substring(dot + 1);
            String ct = MimeType.get((String)ext);
            if (ct != null) {
                return ct;
            }
        } else {
            return MimeType.get((String)"html");
        }
        return "";
    }

    private String commaIfNeeded(int origLength) {
        return origLength > 0 ? "," : "";
    }

    @Override
    protected String dumpContent() {
        if (this.dynamicContent == null) {
            return "   Dynamic content: not initialized";
        }
        if (this.dynamicContent.isEmpty()) {
            return "  Dynamic content: empty" + this.LINE_SEP;
        }
        StringBuilder sb = new StringBuilder("  Dynamic content:");
        for (Map.Entry<String, DynamicContent> entry : this.dynamicContent.entrySet()) {
            sb.append("  " + entry.getKey());
            if (!this.logger.isLoggable(Level.FINER)) continue;
            sb.append("  ====").append(this.LINE_SEP).append(entry.getValue().toString()).append("  ====").append(this.LINE_SEP);
        }
        sb.append("  ========");
        return sb.toString();
    }

    private class VMArgQueryParams
    extends QueryParams {
        private StringBuilder vmArgs;

        public VMArgQueryParams() {
            super(AppClientHTTPAdapter.VMARG_QUERY_PARAM_NAME);
            this.vmArgs = new StringBuilder();
        }

        public void processValue(String value) {
            this.vmArgs.append(value).append(" ");
        }

        public String toString() {
            return this.vmArgs.length() > 0 ? " java-vm=args=\"" + this.vmArgs.toString() + "\"" : "";
        }
    }

    private class PropQueryParams
    extends QueryParams {
        private StringBuilder properties;

        public PropQueryParams() {
            super(AppClientHTTPAdapter.PROP_QUERY_PARAM_NAME);
            this.properties = new StringBuilder();
        }

        public void processValue(String value) {
            if (value.length() > 0) {
                int equalsSign = value.indexOf(61);
                String propValue = "";
                if (equalsSign > 0) {
                    String propName = value.substring(0, equalsSign);
                    if (equalsSign + 1 < value.length()) {
                        propValue = value.substring(equalsSign + 1);
                    }
                    this.properties.append("<property name=\"" + propName + "\" value=\"" + propValue + "\"/>").append(AppClientHTTPAdapter.this.LINE_SEP);
                }
            }
        }

        public String toString() {
            return this.properties.toString();
        }
    }

    private class ACCArgQueryParams
    extends QueryParams {
        private StringBuilder settings;
        private final String targetServerSetting;

        public ACCArgQueryParams(String targetServerSetting) {
            super(AppClientHTTPAdapter.ACC_ARG_QUERY_PARAM_NAME);
            this.settings = new StringBuilder();
            this.targetServerSetting = "arg=-targetserver,arg=" + targetServerSetting;
        }

        public void processValue(String value) {
            this.settings.append(AppClientHTTPAdapter.this.commaIfNeeded(this.settings.length())).append("arg=").append(value);
        }

        public String toString() {
            return this.settings.toString() + AppClientHTTPAdapter.this.commaIfNeeded(this.settings.length()) + this.targetServerSetting;
        }
    }

    private class ArgQueryParams
    extends QueryParams {
        private StringBuilder arguments;

        public ArgQueryParams() {
            super(AppClientHTTPAdapter.ARG_QUERY_PARAM_NAME);
            this.arguments = new StringBuilder();
        }

        public void processValue(String value) {
            if (value.length() == 0) {
                value = "#missing#";
            }
            this.arguments.append("<argument>").append(value).append("</argument>").append(AppClientHTTPAdapter.this.LINE_SEP);
        }

        public String toString() {
            return this.arguments.toString();
        }
    }

    private abstract class QueryParams {
        private String prefix;

        protected QueryParams(String prefix) {
            this.prefix = prefix;
        }

        private boolean handles(String prefix) {
            return prefix.equals(this.prefix);
        }

        protected abstract void processValue(String var1);

        public abstract String toString();

        public boolean processParameter(String param) {
            boolean result = false;
            int equalsSign = param.indexOf("=");
            String value = "";
            String prefix = equalsSign != -1 ? param.substring(0, equalsSign) : param;
            if (this.handles(prefix)) {
                result = true;
                if (equalsSign + 1 < param.length()) {
                    value = param.substring(equalsSign + 1);
                }
                this.processValue(value);
            }
            return result;
        }
    }
}

