/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.xml;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.xml.BeansXmlElement;
import org.jboss.weld.xml.MergedElements;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnabledClasses {
    private List<Class<? extends Annotation>> enabledAlternativeStereotypes = new ArrayList<Class<? extends Annotation>>();
    private List<Class<?>> enabledAlternativeClasses = new ArrayList();
    private List<Class<?>> enabledDecoratorClasses = new ArrayList();
    private List<Class<?>> enabledInterceptorClasses = new ArrayList();
    private ResourceLoader resourceLoader;

    private EnabledClasses(MergedElements beanXmlElements, ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
        this.process(beanXmlElements);
    }

    public static EnabledClasses of(MergedElements beanXmlElements, ResourceLoader resourceLoader) {
        return new EnabledClasses(beanXmlElements, resourceLoader);
    }

    private void process(MergedElements beanXmlElements) {
        this.processAlternatives(beanXmlElements.getAlternativesElements());
        this.enabledDecoratorClasses.addAll(this.getClassesInElements(beanXmlElements.getDecoratorsElements()));
        this.enabledInterceptorClasses.addAll(this.getClassesInElements(beanXmlElements.getInterceptorsElements()));
    }

    private void processAlternatives(List<BeansXmlElement> alternativesElements) {
        Collection<Class<?>> classes = this.getClassesInElements(alternativesElements);
        for (Class<?> clazz : classes) {
            if (clazz.isAnnotation()) {
                this.enabledAlternativeStereotypes.add(clazz.asSubclass(Annotation.class));
                continue;
            }
            this.enabledAlternativeClasses.add(clazz);
        }
    }

    private Collection<Class<?>> getClassesInElements(List<BeansXmlElement> elements) {
        ArrayList classes = new ArrayList();
        for (BeansXmlElement element : elements) {
            classes.addAll(element.getClasses(this.resourceLoader));
        }
        return classes;
    }

    public List<Class<? extends Annotation>> getEnabledAlternativeStereotypes() {
        return this.enabledAlternativeStereotypes;
    }

    public List<Class<?>> getEnabledAlternativeClasses() {
        return this.enabledAlternativeClasses;
    }

    public List<Class<?>> getEnabledDecoratorClasses() {
        return this.enabledDecoratorClasses;
    }

    public List<Class<?>> getEnabledInterceptorClasses() {
        return this.enabledInterceptorClasses;
    }
}

