/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.client.prefs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LoginInfo
implements Comparable<LoginInfo> {
    private String host;
    private int port;
    private String user;
    private String password;

    public LoginInfo(String host, int port, String user, String password) {
        if (host == null || port < 0 || user == null || password == null) {
            throw new IllegalArgumentException("null value");
        }
        this.init(host, port, user, password);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean equals(Object other) {
        boolean same = false;
        if (other instanceof LoginInfo) {
            LoginInfo that = (LoginInfo)other;
            same = this.host.equals(that.host) && this.port == that.port && this.user.equals(that.user) && this.password.equals(that.password);
        }
        return same;
    }

    public int hashCode() {
        return 31 * this.host.hashCode() + 23 * this.port + 53 * this.user.hashCode() + 13 * this.password.hashCode();
    }

    private void init(String host, int port, String user, String password) {
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = password;
    }

    public String toString() {
        return this.host + this.port + this.user + this.password;
    }

    @Override
    public int compareTo(LoginInfo that) {
        String thisKey = this.user + this.host + this.port;
        String thatKey = that.user + that.host + that.port;
        return thisKey.compareTo(thatKey);
    }
}

