/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.lang.reflect.Member;
import java.util.Vector;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.MethodCallNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;

public class NewInvocationNode
extends MethodCallNode {
    private boolean singleInstantiation = false;
    private boolean delimitedIdentifier;
    private boolean isBuiltinVTI = false;

    public void init(Object object, Object object2, Object object3) throws StandardException {
        super.init("<init>");
        this.addParms((Vector)object2);
        this.javaClassName = (String)object;
        this.delimitedIdentifier = (Boolean)object3;
    }

    public void init(Object object, Object object2, Object object3, Object object4) throws StandardException {
        boolean bl;
        super.init("<init>");
        this.addParms((Vector)object3);
        TableName tableName = (TableName)object;
        TableDescriptor tableDescriptor = (TableDescriptor)object2;
        boolean bl2 = bl = object != null;
        if (bl) {
            tableDescriptor = new TableDescriptor(this.getDataDictionary(), tableName.getTableName(), this.getSchemaDescriptor(tableName.getSchemaName()), 5, 'R');
        }
        this.javaClassName = this.getDataDictionary().getVTIClass(tableDescriptor, bl);
        boolean bl3 = this.isBuiltinVTI = this.getDataDictionary().getBuiltinVTIClass(tableDescriptor, bl) != null;
        if (this.javaClassName == null) {
            if (!bl) {
                tableName = this.makeTableName(tableDescriptor.getSchemaName(), tableDescriptor.getDescriptorName());
            }
            throw StandardException.newException(bl ? "42Y03" : "42X05", tableName.getFullTableName());
        }
        this.delimitedIdentifier = (Boolean)object4;
    }

    public boolean isBuiltinVTI() {
        return this.isBuiltinVTI;
    }

    void setSingleInstantiation() {
        this.singleInstantiation = true;
    }

    public JavaValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        TypeDescriptor typeDescriptor;
        Object object;
        this.bindParameters(fromList, subqueryList, vector);
        this.verifyClassExist(this.javaClassName);
        String[] stringArray = this.getObjectSignature();
        boolean[] blArray = this.getIsParam();
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        try {
            this.method = classInspector.findPublicConstructor(this.javaClassName, stringArray, null, blArray);
            if (this.method == null) {
                object = this.getPrimitiveSignature(false);
                this.method = classInspector.findPublicConstructor(this.javaClassName, stringArray, (String[])object, blArray);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.method = null;
        }
        if (this.method == null) {
            object = "";
            for (int i = 0; i < stringArray.length; ++i) {
                if (i != 0) {
                    object = (String)object + ", ";
                }
                object = (String)object + (stringArray[i].length() != 0 ? stringArray[i] : MessageService.getTextMessage("42Z01.U"));
            }
            throw StandardException.newException("42X75", (Object)this.javaClassName, object);
        }
        this.methodParameterTypes = classInspector.getParameterTypes(this.method);
        for (int i = 0; i < this.methodParameterTypes.length; ++i) {
            if (!ClassInspector.primitiveType(this.methodParameterTypes[i])) continue;
            this.methodParms[i].castToPrimitive(true);
        }
        if (this.someParametersAreNull()) {
            this.setNullParameterInfo(this.methodParameterTypes);
        }
        this.setJavaTypeName(this.javaClassName);
        if (this.routineInfo != null && (typeDescriptor = this.routineInfo.getReturnType()) != null) {
            this.setCollationType(typeDescriptor.getCollationType());
        }
        return this;
    }

    public boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        if (bl) {
            return false;
        }
        boolean bl2 = true;
        bl2 = bl2 && super.categorize(jBitSet, bl);
        return bl2;
    }

    protected boolean assignableTo(String string) throws StandardException {
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        return classInspector.assignableTo(this.javaClassName, string);
    }

    protected Member findPublicMethod(String string, boolean bl) throws StandardException {
        Member member;
        String[] stringArray = this.getObjectSignature();
        boolean[] blArray = this.getIsParam();
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        try {
            member = classInspector.findPublicMethod(this.javaClassName, string, stringArray, null, blArray, bl, false);
            if (member == null) {
                String[] stringArray2 = this.getPrimitiveSignature(false);
                member = classInspector.findPublicMethod(this.javaClassName, string, stringArray, stringArray2, blArray, bl, false);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        return member;
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        LocalField localField = null;
        if (this.singleInstantiation) {
            localField = expressionClassBuilder.newFieldDeclaration(2, this.javaClassName);
            methodBuilder.getField(localField);
            methodBuilder.conditionalIfNull();
        }
        methodBuilder.pushNewStart(this.javaClassName);
        int n = this.generateParameters(expressionClassBuilder, methodBuilder);
        methodBuilder.pushNewComplete(n);
        if (this.singleInstantiation) {
            methodBuilder.putField(localField);
            methodBuilder.startElseCode();
            methodBuilder.getField(localField);
            methodBuilder.completeConditional();
        }
    }
}

