/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ExternalJndiResource;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-jndi-resource")
@Scoped(value=PerLookup.class)
@I18n(value="delete.jndi.resource")
public class DeleteJndiResource
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteJndiResource.class);
    @Param(optional=true, defaultValue="server")
    String target;
    @Param(name="jndi_name", primary=true)
    String jndiName;
    @Inject
    Resources resources;
    @Inject
    ExternalJndiResource[] jndiResources;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Server targetServer = this.domain.getServerNamed(this.target);
        if (!this.isResourceExists(this.resources, this.jndiName)) {
            report.setMessage(localStrings.getLocalString("delete.jndi.resource.notfound", "A jndi resource named {0} does not exist.", new Object[]{this.jndiName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply(new SingleConfigCode<Resources>(){

                @Override
                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    for (ExternalJndiResource resource : DeleteJndiResource.this.jndiResources) {
                        if (!resource.getJndiName().equals(DeleteJndiResource.this.jndiName)) continue;
                        param.getResources().remove(resource);
                        break;
                    }
                    return DeleteJndiResource.this.jndiResources;
                }
            }, this.resources);
            targetServer.deleteResourceRef(this.jndiName);
            report.setMessage(localStrings.getLocalString("delete.jndi.resource.success", "Jndi resource {0} deleted.", new Object[]{this.jndiName}));
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("delete.jndi.resource.fail", "Unable to delete jndi resource {0}.", new Object[]{this.jndiName}) + " " + tfe.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)tfe);
        }
    }

    private boolean isResourceExists(Resources resources, String jndiName) {
        for (Resource resource : resources.getResources()) {
            if (!(resource instanceof ExternalJndiResource) || !((ExternalJndiResource)resource).getJndiName().equals(jndiName)) continue;
            return true;
        }
        return false;
    }
}

