/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.aggregation;

import java.io.PrintWriter;
import java.io.Serializable;

public class HistogramData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long[] values;
    private long[] counts;

    public HistogramData(long[] values, long[] counts) {
        if (values.length != counts.length) {
            throw new IllegalArgumentException("values and counts are different lengths");
        }
        this.values = values;
        this.counts = counts;
    }

    public long[] getValues() {
        return this.values;
    }

    public long[] getCounts() {
        return this.counts;
    }

    public void print(PrintWriter p) {
        int i;
        int totalCount = 0;
        for (i = 0; i < this.counts.length; ++i) {
            totalCount = (int)((long)totalCount + this.counts[i]);
        }
        p.println("          value  ------------- Distribution ------------- count");
        for (i = 0; i < this.values.length; ++i) {
            p.print(String.format("%15d", this.values[i]));
            p.print(" |");
            long lineLength = 40L * this.counts[i] / (long)totalCount;
            for (int j = 0; j < 40; ++j) {
                p.print((long)j < lineLength ? "@" : " ");
            }
            p.print(" ");
            p.println(this.counts[i]);
        }
    }
}

