/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.service;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.appserv.connectors.internal.spi.ConnectorNamingEvent;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorDescriptorInfo;
import com.sun.enterprise.connectors.naming.ConnectorNamingEventNotifier;
import com.sun.enterprise.connectors.naming.ConnectorResourceNamingEventNotifier;
import com.sun.enterprise.connectors.service.ConnectorAdminServiceUtils;
import com.sun.enterprise.connectors.service.ConnectorService;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;

public class ConnectorResourceAdminServiceImpl
extends ConnectorService {
    public void createConnectorResource(String jndiName, String poolName, String resourceType) throws ConnectorRuntimeException {
        String errMsg = "rardeployment.jndi_lookup_failed";
        String name = poolName;
        try {
            ConnectorConnectionPool ccp = null;
            String jndiNameForPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolName);
            Context ic = this._runtime.getNamingManager().getInitialContext();
            try {
                ccp = (ConnectorConnectionPool)ic.lookup(jndiNameForPool);
            }
            catch (NamingException ne) {
                try {
                    this.checkAndLoadPool(poolName);
                    ccp = (ConnectorConnectionPool)ic.lookup(jndiNameForPool);
                }
                catch (NamingException e) {
                    Object[] params = new Object[]{name, e};
                    _logger.log(Level.SEVERE, "unable.to.lookup.pool", params);
                }
            }
            ccp = (ConnectorConnectionPool)ic.lookup(jndiNameForPool);
            ConnectorDescriptorInfo cdi = ccp.getConnectorDescriptorInfo();
            Reference ref = new Reference(cdi.getConnectionFactoryClass(), "com.sun.enterprise.resource.naming.ConnectorObjectFactory", null);
            StringRefAddr addr = new StringRefAddr("poolName", poolName);
            ref.add(addr);
            addr = new StringRefAddr("rarName", cdi.getRarName());
            ref.add(addr);
            errMsg = "Failed to bind connector resource in JNDI";
            name = jndiName;
            this._runtime.getNamingManager().publishObject(jndiName, (Object)ref, true);
            ConnectorResourceNamingEventNotifier.getInstance().notifyListeners(new ConnectorNamingEvent(jndiName, 0));
        }
        catch (NamingException ne) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException(errMsg);
            cre.initCause((Throwable)ne);
            _logger.log(Level.SEVERE, errMsg, name);
            _logger.log(Level.SEVERE, "", (Throwable)cre);
            throw cre;
        }
    }

    public void deleteConnectorResource(String jndiName) throws ConnectorRuntimeException {
        try {
            this._runtime.getNamingManager().unpublishObject(jndiName);
        }
        catch (NamingException ne) {
            if (ne instanceof NameNotFoundException) {
                _logger.log(Level.FINE, "rardeployment.connectorresource_removal_from_jndi_error", jndiName);
                _logger.log(Level.FINE, "", ne);
                return;
            }
            ConnectorRuntimeException cre = new ConnectorRuntimeException("Failed to delete connector resource from jndi");
            cre.initCause((Throwable)ne);
            _logger.log(Level.SEVERE, "rardeployment.connectorresource_removal_from_jndi_error", jndiName);
            _logger.log(Level.SEVERE, "", (Throwable)cre);
            throw cre;
        }
    }

    public ConnectorNamingEventNotifier getResourceRebindEventNotifier() {
        return ConnectorResourceNamingEventNotifier.getInstance();
    }

    public Object lookup(String name) throws NamingException {
        Hashtable<String, String> ht = null;
        String suffix = ConnectorsUtil.getValidSuffix((String)name);
        if (suffix != null) {
            ht = new Hashtable<String, String>();
            ht.put("com.sun.enterprise.connectors.jndisuffix", suffix);
            name = name.substring(0, name.lastIndexOf(suffix));
        }
        InitialContext ic = new InitialContext(ht);
        return ic.lookup(name);
    }
}

