/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.recovery;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.TransactionService;
import com.sun.enterprise.deployment.ResourcePrincipal;
import com.sun.enterprise.transaction.api.XAResourceWrapper;
import com.sun.enterprise.transaction.spi.RecoveryResourceHandler;
import com.sun.logging.LogDomains;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.types.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class JdbcRecoveryResourceHandler
implements RecoveryResourceHandler {
    @Inject
    private TransactionService txService;
    @Inject
    private Resources resources;
    @Inject
    private Habitat connectorRuntimeHabitat;
    private static Logger _logger = LogDomains.getLogger(JdbcRecoveryResourceHandler.class, (String)"javax.enterprise.resource.resourceadapter");

    private void loadAllJdbcResources() {
        block5: {
            try {
                Collection<JdbcResource> jdbcResources = this.getJdbcResources();
                InitialContext ic = new InitialContext();
                for (JdbcResource resource : jdbcResources) {
                    JdbcResource jdbcResource = resource;
                    if (!this.isEnabled(jdbcResource)) continue;
                    try {
                        ic.lookup(jdbcResource.getJndiName());
                    }
                    catch (Exception ex) {
                        _logger.log(Level.SEVERE, "error.loading.jdbc.resources.during.recovery", jdbcResource.getJndiName());
                        if (!_logger.isLoggable(Level.FINE)) continue;
                        _logger.log(Level.FINE, ex.toString(), ex);
                    }
                }
            }
            catch (NamingException ne) {
                _logger.log(Level.SEVERE, "error.loading.jdbc.resources.during.recovery", ne.getMessage());
                if (!_logger.isLoggable(Level.FINE)) break block5;
                _logger.log(Level.FINE, ne.toString(), ne);
            }
        }
    }

    private Collection<JdbcResource> getJdbcResources() {
        return this.resources.getResources(JdbcResource.class);
    }

    public void loadXAResourcesAndItsConnections(List xaresList, List connList) {
        Collection<JdbcResource> jdbcres = this.getJdbcResources();
        if (jdbcres == null || jdbcres.size() == 0) {
            return;
        }
        ArrayList<JdbcConnectionPool> jdbcPools = new ArrayList<JdbcConnectionPool>();
        for (JdbcResource resource : jdbcres) {
            JdbcResource jdbcResource = resource;
            if (!this.isEnabled(jdbcResource)) continue;
            JdbcConnectionPool pool = this.getJdbcConnectionPoolByName(jdbcResource.getPoolName());
            if (pool != null && "javax.sql.XADataSource".equals(pool.getResType())) {
                jdbcPools.add(pool);
            }
            if (!_logger.isLoggable(Level.FINE)) continue;
            _logger.fine("JdbcRecoveryResourceHandler:: loadXAResourcesAndItsConnections :: adding : " + jdbcResource.getPoolName());
        }
        ConnectorRuntime crt = (ConnectorRuntime)this.connectorRuntimeHabitat.getComponent(ConnectorRuntime.class);
        this.loadAllJdbcResources();
        Properties xaresourcewrappers = new Properties();
        xaresourcewrappers.put("oracle.jdbc.xa.client.OracleXADataSource", "com.sun.enterprise.transaction.jts.recovery.OracleXAResource");
        List properties = this.txService.getProperty();
        if (properties != null) {
            for (Property property : properties) {
                String name = property.getName();
                String value = property.getValue();
                if (name.equals("oracle-xa-recovery-workaround")) {
                    if (!"false".equals(value)) continue;
                    xaresourcewrappers.remove("oracle.jdbc.xa.client.OracleXADataSource");
                    continue;
                }
                if (!name.equals("sybase-xa-recovery-workaround") || !value.equals("true")) continue;
                xaresourcewrappers.put("com.sybase.jdbc2.jdbc.SybXADataSource", "com.sun.enterprise.transaction.jts.recovery.SybaseXAResource");
            }
        }
        for (JdbcConnectionPool jdbcConnectionPool : jdbcPools) {
            if (jdbcConnectionPool.getResType() == null || jdbcConnectionPool.getName() == null || !jdbcConnectionPool.getResType().equals("javax.sql.XADataSource")) continue;
            String poolName = jdbcConnectionPool.getName();
            try {
                String[] dbUserPassword = this.getdbUserPasswordOfJdbcConnectionPool(jdbcConnectionPool);
                String dbUser = dbUserPassword[0];
                String dbPassword = dbUserPassword[1];
                ManagedConnectionFactory fac = crt.obtainManagedConnectionFactory(poolName);
                Subject subject = new Subject();
                PasswordCredential pc = new PasswordCredential(dbUser, dbPassword.toCharArray());
                pc.setManagedConnectionFactory(fac);
                ResourcePrincipal prin = new ResourcePrincipal(dbUser, dbPassword);
                subject.getPrincipals().add((Principal)prin);
                subject.getPrivateCredentials().add(pc);
                ManagedConnection mc = fac.createManagedConnection(subject, null);
                connList.add(mc);
                try {
                    XAResource xares = mc.getXAResource();
                    if (xares == null) continue;
                    String clName = jdbcConnectionPool.getDatasourceClassname();
                    String wrapperclass = (String)xaresourcewrappers.get(clName);
                    if (wrapperclass != null) {
                        XAResourceWrapper xaresWrapper = null;
                        xaresWrapper = (XAResourceWrapper)Class.forName(wrapperclass).newInstance();
                        xaresWrapper.init(mc, subject);
                        xaresList.add(xaresWrapper);
                        continue;
                    }
                    xaresList.add(xares);
                }
                catch (ResourceException ex) {
                }
            }
            catch (Exception ex) {
                _logger.log(Level.WARNING, "datasource.xadatasource_error", poolName);
                _logger.log(Level.FINE, "datasource.xadatasource_error_excp", ex);
            }
        }
    }

    private JdbcConnectionPool getJdbcConnectionPoolByName(String poolName) {
        JdbcConnectionPool result = null;
        Collection jdbcPools = this.resources.getResources(JdbcConnectionPool.class);
        for (JdbcConnectionPool jdbcPool : jdbcPools) {
            if (!jdbcPool.getName().equals(poolName)) continue;
            result = jdbcPool;
            break;
        }
        return result;
    }

    public void closeConnections(List connList) {
        for (Object obj : connList) {
            try {
                ManagedConnection con = (ManagedConnection)obj;
                con.destroy();
            }
            catch (Exception ex) {
                _logger.log(Level.WARNING, "recovery.jdbc-resource.destroy-error", ex);
            }
        }
    }

    private boolean isEnabled(JdbcResource resource) {
        return Boolean.valueOf(resource.getEnabled());
    }

    public String[] getdbUserPasswordOfJdbcConnectionPool(JdbcConnectionPool jdbcConnectionPool) {
        String[] userPassword = new String[]{null, null};
        List properties = jdbcConnectionPool.getProperty();
        if (properties != null && properties.size() > 0) {
            for (Property property : properties) {
                String prop = property.getName().toUpperCase();
                if ("USERNAME".equals(prop) || "USER".equals(prop)) {
                    userPassword[0] = property.getValue();
                    continue;
                }
                if (!"PASSWORD".equals(prop)) continue;
                userPassword[1] = property.getValue();
            }
        } else {
            return userPassword;
        }
        return userPassword;
    }
}

